/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.confadmin;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.confadmin.KmsDirectStoreImportVo;
import com.biz.crm.kms.confadmin.entity.KmsDirectStoreAreaEntity;
import com.biz.crm.kms.confadmin.entity.KmsDirectStoreEntity;
import com.biz.crm.kms.confadmin.entity.KmsDirectSystemEntity;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreAreaMapper;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.kms.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.util.AssertUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsDirectStoreValidator")
public class KmsDirectStoreValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsDirectStoreMapper, KmsDirectStoreEntity, KmsDirectStoreImportVo>
implements ExcelImportValidator<KmsDirectStoreImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsDirectStoreValidator.class);
    private Map<String, KmsDirectSystemEntity> spareDirectSystemMap = Maps.newHashMap();
    private final Map<String, Map<String, KmsDirectStoreAreaEntity>> spareStoreAreaMap = Maps.newHashMap();
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private KmsDirectStoreAreaMapper kmsDirectStoreAreaMapper;
    @Resource
    private KmsDirectSystemMapper kmsDirectSystemMapper;

    @Override
    public void validate(List<KmsDirectStoreImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet directIdSet = Sets.newHashSet();
        HashSet areaCodeSet = Sets.newHashSet();
        HashSet storeCodeSet = Sets.newHashSet();
        HashMap storeCodeAreaMap = Maps.newHashMap();
        data.forEach(x -> {
            AssertUtils.isNotEmpty((String)x.getDirectId(), (String)"\u5546\u8d85\u4f53\u7cfbId\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getStoreCode(), (String)"\u5546\u8d85\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getStoreName(), (String)"\u5546\u8d85\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isNotBlank((CharSequence)x.getAreaCode())) {
                areaCodeSet.add(x.getAreaCode());
                storeCodeAreaMap.put(x.getStoreCode(), x.getAreaCode());
            }
            if (storeCodeSet.contains(x.getStoreCode())) {
                throw new BusinessException("\u5546\u8d85\u7f16\u7801" + x.getStoreCode() + "\u4e0d\u53ef\u91cd\u590d\u5bfc\u5165");
            }
            storeCodeSet.add(x.getStoreCode());
            directIdSet.add(x.getDirectId());
        });
        this.spareCheckData(directIdSet, areaCodeSet);
        this.compareSpareAndExcel(directIdSet, data);
        this.compareDbAndExcel(storeCodeSet);
    }

    private void compareDbAndExcel(Set<String> storeCodeSet) {
        List kmsDirectStoreEntities = this.kmsDirectStoreMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        if (CollectionUtils.isEmpty((Collection)kmsDirectStoreEntities)) {
            return;
        }
        Map kmsDirectStoreEntityMap = kmsDirectStoreEntities.stream().collect(Collectors.toMap(KmsDirectStoreEntity::getStoreCode, Function.identity()));
        storeCodeSet.retainAll(kmsDirectStoreEntityMap.keySet());
        if (CollectionUtils.isNotEmpty(storeCodeSet)) {
            throw new BusinessException("\u5546\u8d85\u95e8\u5e97\u7f16\u7801" + storeCodeSet.toString() + "\u884c\u7684\u5546\u8d85\u95e8\u5e97\u5df2\u5b58\u5728");
        }
    }

    private void compareSpareAndExcel(Set<String> directIdSet, List<KmsDirectStoreImportVo> data) {
        directIdSet.removeAll(this.spareDirectSystemMap.keySet());
        if (CollectionUtils.isNotEmpty(directIdSet)) {
            throw new BusinessException("\u5546\u8d85\u95e8\u5e97Id\uff1a" + directIdSet.toString() + "\u7684\u5546\u8d85\u95e8\u5e97\u4e0d\u5728\u7ef4\u62a4\u4e2d");
        }
        data.forEach(x -> {
            Map<String, KmsDirectStoreAreaEntity> areaEntityMap = this.spareStoreAreaMap.get(x.getDirectId());
            if (StringUtils.isNotBlank((CharSequence)x.getAreaCode())) {
                if (!areaEntityMap.containsKey(x.getAreaCode())) {
                    throw new BusinessException("\u5546\u8d85\u7cfb\u7edf" + x.getDirectId() + "\u95e8\u5e97\u533a\u57df\u7f16\u7801" + x.getStoreCode() + "\u884c\u7684\u95e8\u5e97\u533a\u57df\u7f16\u7801\u4e0d\u5728\u7ef4\u62a4\u4e2d");
                }
                x.setAreaId(areaEntityMap.get(x.getAreaCode()).getId());
            }
        });
    }

    private void spareCheckData(Set<String> directIdSet, Set<String> areaCodeSet) {
        this.spareDirectSystemData(directIdSet);
        this.spareAreaData(areaCodeSet);
    }

    private void spareAreaData(Set<String> areaCodeSet) {
        if (CollectionUtils.isNotEmpty(areaCodeSet)) {
            List kmsDirectStoreAreaEntities = this.kmsDirectStoreAreaMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsDirectStoreAreaEntity::getDsAreaCode, areaCodeSet)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
            if (CollectionUtils.isEmpty((Collection)kmsDirectStoreAreaEntities)) {
                throw new BusinessException("\u6ca1\u6709\u7ef4\u62a4\u4e2d\u7684\u95e8\u5e97\u533a\u57df");
            }
            kmsDirectStoreAreaEntities.forEach(x -> {
                Map<Object, Object> areaEntityMap = Maps.newHashMap();
                if (this.spareStoreAreaMap.containsKey(x.getDirectId())) {
                    areaEntityMap = this.spareStoreAreaMap.get(x.getDirectId());
                }
                areaEntityMap.put(x.getDsAreaCode(), x);
                this.spareStoreAreaMap.put(x.getDirectId(), areaEntityMap);
            });
        }
    }

    private void spareDirectSystemData(Set<String> directIdSet) {
        if (CollectionUtils.isNotEmpty(directIdSet)) {
            List kmsDirectSystemEntities = this.kmsDirectSystemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).in(BaseIdEntity::getId, directIdSet)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
            if (CollectionUtils.isEmpty((Collection)kmsDirectSystemEntities)) {
                throw new BusinessException("\u6ca1\u6709\u7ef4\u62a4\u4e2d\u7684\u5546\u8d85\u7cfb\u7edf");
            }
            this.spareDirectSystemMap = kmsDirectSystemEntities.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        }
    }
}

