/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.kaproduct;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.kaproduct.KmsTenantryDirectProductImportVo;
import com.biz.crm.kms.confadmin.entity.KmsDirectOrderTypeEntity;
import com.biz.crm.kms.confadmin.mapper.KmsDirectOrderTypeMapper;
import com.biz.crm.kms.eunm.ProductUnitEnum;
import com.biz.crm.kms.kaproduct.entity.KmsTenantryDirectProductEntity;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTenantryDirectProductValidator")
public class KmsTenantryDirectProductValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTenantryDirectProductMapper, KmsTenantryDirectProductEntity, KmsTenantryDirectProductImportVo>
implements ExcelImportValidator<KmsTenantryDirectProductImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectProductValidator.class);
    private List<KmsTenantryDirectCustomerOrgEntity> spareCustomerOrgList = Lists.newArrayList();
    private Map<String, KmsTenantryDirectCustomerOrgEntity> spareCustomerOrgMap = Maps.newHashMap();
    private Map<String, MdmCustomerMsgSelectRespVo> spareSellPartyMap = Maps.newHashMap();
    private Map<String, MdmProductRespVo> spareProductMap = Maps.newHashMap();
    private final Map<String, Set<String>> spareOrderTypeMap = Maps.newHashMap();
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private KmsDirectOrderTypeMapper kmsDirectOrderTypeMapper;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    @Override
    public void validate(List<KmsTenantryDirectProductImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet bsCodeSet = Sets.newHashSet();
        HashSet sellPartySet = Sets.newHashSet();
        HashSet productCodeSet = Sets.newHashSet();
        HashSet kaProductCodeSet = Sets.newHashSet();
        HashMap repeatWithoutWeekMap = Maps.newHashMap();
        HashMap repeatWithWeekMap = Maps.newHashMap();
        data.forEach(x -> {
            String repeatStr;
            x.setId(StringUtils.replace((String)UUID.randomUUID().toString(), (String)"-", (String)""));
            AssertUtils.isNotEmpty((String)x.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getSellPartyCode(), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getProductCode(), (String)"\u4f01\u4e1a\u4ea7\u54c1\u4fe1\u606f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getKaProductCode(), (String)"\u5ba2\u6237\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getIsDefault(), (String)"\u662f\u5426\u9ed8\u8ba4\u4ea7\u54c1");
            AssertUtils.isNotEmpty((String)x.getOrderType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getUnitCode(), (String)"\u4f01\u4e1a\u4ea7\u54c1\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getKaUnitCode(), (String)"\u5546\u8d85\u4ea7\u54c1\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)x.getRatio(), (String)"\u5355\u4f4d\u8f6c\u6362\u6bd4\u4f8b\u7cfb\u6570\u4e0d\u80fd\u4e3a\u4e3a\u7a7a");
            if (!GlobalWhetherEnum.YES.getCode().equals(x.getIsDefault()) && !GlobalWhetherEnum.NO.getCode().equals(x.getIsDefault())) {
                throw new BusinessException("\u662f\u5426\u9ed8\u8ba4\u4ea7\u54c1\u53ea\u80fd\u586b\u5199Y/N");
            }
            if (StringUtils.isBlank((CharSequence)x.getIsDirect()) && !GlobalWhetherEnum.YES.getCode().equals(x.getIsDirect()) && !GlobalWhetherEnum.NO.getCode().equals(x.getIsDirect())) {
                throw new BusinessException("\u662f\u5426\u9ed8\u8ba4\u76f4\u8425\u4ea7\u54c1\u53ea\u80fd\u586b\u5199Y/N");
            }
            bsCodeSet.add(x.getBsDirectSystemCode());
            sellPartySet.add(x.getSellPartyCode());
            productCodeSet.add(x.getProductCode());
            kaProductCodeSet.add(x.getKaProductCode());
            if (x.getTimeOfWeek() != null) {
                repeatStr = x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode() + x.getTimeOfWeek();
                if (repeatWithWeekMap.containsKey(repeatStr)) {
                    throw new BusinessException(repeatStr + "\u884c\u7684\u6570\u636e\u91cd\u590d");
                }
                repeatWithWeekMap.put(repeatStr, x);
            }
            if (x.getTimeOfWeek() == null) {
                repeatStr = x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode();
                if (repeatWithoutWeekMap.containsKey(repeatStr)) {
                    throw new BusinessException(repeatStr + "\u884c\u7684\u6570\u636e\u91cd\u590d");
                }
                repeatWithoutWeekMap.put(repeatStr, x);
            }
        });
        this.buildSpareData(bsCodeSet, sellPartySet, productCodeSet);
        this.checkSpare(data);
        this.checkExistByDb(repeatWithoutWeekMap, repeatWithWeekMap, bsCodeSet, sellPartySet, productCodeSet, kaProductCodeSet);
    }

    private void checkExistByDb(Map<String, KmsTenantryDirectProductImportVo> repeatWithoutWeekMap, Map<String, KmsTenantryDirectProductImportVo> repeatWithWeekMap, Set<String> bsCodeSet, Set<String> sellPartySet, Set<String> productCodeSet, Set<String> kaProductCodeSet) {
        List productEntities = this.kmsTenantryDirectProductMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsTenantryDirectProductEntity::getBsDirectSystemCode, bsCodeSet)).in(KmsTenantryDirectProductEntity::getProductCode, productCodeSet)).in(KmsTenantryDirectProductEntity::getKaProductCode, kaProductCodeSet)).in(KmsTenantryDirectProductEntity::getSellPartyCode, sellPartySet)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        if (CollectionUtils.isEmpty((Collection)productEntities)) {
            return;
        }
        HashMap checkWithoutWeekByDb = Maps.newHashMap();
        HashMap checkWithWeekByDb = Maps.newHashMap();
        productEntities.forEach(x -> {
            if (x.getTimeOfWeek() == null) {
                checkWithoutWeekByDb.put(x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode(), x);
            }
            if (x.getTimeOfWeek() != null) {
                checkWithWeekByDb.put(x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode() + x.getTimeOfWeek(), x);
            }
        });
        repeatWithoutWeekMap.keySet().retainAll(checkWithoutWeekByDb.keySet());
        if (CollectionUtils.isNotEmpty(repeatWithoutWeekMap.keySet())) {
            throw new BusinessException(repeatWithoutWeekMap.keySet().toString() + "\u884c\u4e0e\u6570\u636e\u5e93\u91cd\u590d");
        }
        repeatWithWeekMap.keySet().retainAll(checkWithWeekByDb.keySet());
        if (CollectionUtils.isNotEmpty(repeatWithWeekMap.keySet())) {
            throw new BusinessException(repeatWithWeekMap.keySet().toString() + "\u884c\u4e0e\u6570\u636e\u5e93\u91cd\u590d");
        }
    }

    private void checkSpare(List<KmsTenantryDirectProductImportVo> data) {
        Map<String, String> unitMap = ProductUnitEnum.unitMap();
        data.forEach(x -> {
            if (!this.spareCustomerOrgMap.containsKey(x.getBsDirectSystemCode())) {
                throw new BusinessException("\u76f4\u8425\u4f53\u7cfb\u7f16\u7801" + x.getBsDirectSystemCode() + "\u7684\u6570\u636e\u76f4\u8425\u4f53\u7cfb\u4e0d\u5728\u7ef4\u62a4\u4e2d");
            }
            KmsTenantryDirectCustomerOrgEntity entity = this.spareCustomerOrgMap.get(x.getBsDirectSystemCode());
            x.setBsDirectSystemId(entity.getBsDirectSystemId());
            x.setBsDirectSystemName(entity.getBsDirectSystemName());
            x.setDirectId(entity.getDirectId());
            if (!this.spareSellPartyMap.containsKey(x.getSellPartyCode())) {
                throw new BusinessException("\u552e\u8fbe\u65b9\u7f16\u7801" + x.getSellPartyCode() + "\u7684\u6570\u636e\u552e\u8fbe\u65b9\u4e0d\u5b58\u5728");
            }
            x.setSellPartyName(this.spareSellPartyMap.get(x.getSellPartyCode()).getCustomerName());
            if (!this.spareProductMap.containsKey(x.getProductCode())) {
                throw new BusinessException("\u4f01\u4e1a\u4ea7\u54c1\u7f16\u7801" + x.getProductCode() + "\u7684\u4ea7\u54c1\u4e0d\u5b58\u5728");
            }
            x.setProductName(this.spareProductMap.get(x.getProductCode()).getProductName());
            if (!this.spareOrderTypeMap.get(x.getDirectId()).contains(x.getOrderType())) {
                throw new BusinessException("\u5355\u636e\u7c7b\u578b" + x.getBsDirectSystemCode() + x.getOrderType() + "\u6570\u636e\u7684\u5355\u636e\u7c7b\u578b\u4e0d\u53ef\u7528");
            }
            if (!unitMap.containsKey(x.getUnitCode())) {
                throw new BusinessException("\u4f01\u4e1a\u5355\u4f4d\u7f16\u7801" + x.getUnitCode() + "\u7684\u4f01\u4e1a\u5355\u4f4d\u4e0d\u5b58\u5728");
            }
            x.setUnitName((String)unitMap.get(x.getUnitCode()));
        });
    }

    private void buildSpareData(Set<String> bsCodeSet, Set<String> sellPartySet, Set<String> productCodeSet) {
        if (CollectionUtils.isNotEmpty(bsCodeSet)) {
            this.spareCustomerOrgData(bsCodeSet);
        }
        if (CollectionUtils.isNotEmpty(sellPartySet)) {
            this.spareSellPartyData(sellPartySet);
        }
        if (CollectionUtils.isNotEmpty(productCodeSet)) {
            this.spareProductData(productCodeSet);
        }
        if (CollectionUtils.isNotEmpty(this.spareCustomerOrgList)) {
            Set directIdCode = this.spareCustomerOrgList.stream().map(KmsTenantryDirectCustomerOrgEntity::getDirectId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(directIdCode)) {
                throw new BusinessException("\u5355\u636e\u7c7b\u578b\u4e0d\u53ef\u7528");
            }
            List orderTypeEntities = this.kmsDirectOrderTypeMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).in(KmsDirectOrderTypeEntity::getDirectId, directIdCode));
            if (CollectionUtils.isEmpty((Collection)orderTypeEntities)) {
                throw new BusinessException("\u6ca1\u6709\u53ef\u7528\u5355\u636e\u7c7b\u578b");
            }
            orderTypeEntities.forEach(x -> {
                if (this.spareOrderTypeMap.containsKey(x.getDirectId())) {
                    Set<String> orderTypeSet = this.spareOrderTypeMap.get(x.getDirectId());
                    orderTypeSet.add(x.getOrderType());
                    this.spareOrderTypeMap.put(x.getDirectId(), orderTypeSet);
                } else {
                    HashSet initOrderTypeSet = Sets.newHashSet();
                    initOrderTypeSet.add(x.getOrderType());
                    this.spareOrderTypeMap.put(x.getDirectId(), initOrderTypeSet);
                }
            });
        }
    }

    private void spareProductData(Set<String> productCodeSet) {
        ArrayList productCodeList = Lists.newArrayList(productCodeSet);
        this.spareProductMap = ((List)ApiResultUtil.objResult((Result)this.mdmProductFeign.queryBatchByProductCodeList((List)productCodeList), (boolean)true)).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, Function.identity()));
    }

    private void spareSellPartyData(Set<String> sellPartySet) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setCustomerCodeList(new ArrayList<String>(sellPartySet));
        mdmCustomerMsgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.spareSellPartyMap = ((List)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.findCustomerSelectList(mdmCustomerMsgReqVo), (boolean)true)).stream().collect(Collectors.toMap(MdmCustomerMsgSelectRespVo::getCustomerCode, Function.identity()));
    }

    private void spareCustomerOrgData(Set<String> bsCodeSet) {
        KmsTenantryDirectCustomerOrgReqVo reqVo = new KmsTenantryDirectCustomerOrgReqVo();
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setBsDirectSystemCodeList(bsCodeSet);
        this.spareCustomerOrgList = this.kmsTenantryDirectCustomerOrgMapper.selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(this.spareCustomerOrgList)) {
            return;
        }
        this.spareCustomerOrgMap = this.spareCustomerOrgList.stream().collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
    }
}

