/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.tenantrydirectaccount;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectaccount.KmsTenantryDirectAccountImportVo;
import com.biz.crm.kms.config.KmsConfig;
import com.biz.crm.kms.tenantrydirectaccount.entity.KmsTenantryDirectAccountEntity;
import com.biz.crm.kms.tenantrydirectaccount.mapper.KmsTenantryDirectAccountMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.util.AesEncoder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTenantryDirectAccountValidator")
public class KmsTenantryDirectAccountValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTenantryDirectAccountMapper, KmsTenantryDirectAccountEntity, KmsTenantryDirectAccountImportVo>
implements ExcelImportValidator<KmsTenantryDirectAccountImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectAccountValidator.class);
    @Resource
    private KmsTenantryDirectAccountMapper accountMapper;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper customerOrgMapper;
    @Resource
    private KmsConfig kmsConfig;
    private static final Integer MAX_PASS_LENGTH = 32;

    @Override
    public void validate(List<KmsTenantryDirectAccountImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet deduplicationLoginAcc = Sets.newHashSet();
        HashSet deduplicationCode = Sets.newHashSet();
        HashMap dataMap = Maps.newHashMap();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getLoginAcc())) {
                throw new BusinessException("\u8d26\u53f7\u6ca1\u6709\u586b\u5199");
            }
            if (StringUtils.isBlank((CharSequence)x.getLoginPass())) {
                throw new BusinessException("\u767b\u5f55\u5bc6\u7801\u6ca1\u6709\u586b\u5199");
            }
            x.setLoginPass(new AesEncoder(this.kmsConfig.getEncryptAesKey()).encode((CharSequence)x.getLoginPass()));
            if (deduplicationLoginAcc.contains(x.getLoginAcc())) {
                throw new BusinessException(x.getLoginAcc() + "\u884c\u7684\u767b\u5f55\u8d26\u53f7\u91cd\u590d");
            }
            if (StringUtils.isBlank((CharSequence)x.getBsDirectSystemCode()) || StringUtils.isBlank((CharSequence)x.getBsDirectSystemId()) || StringUtils.isBlank((CharSequence)x.getBsDirectSystemName())) {
                throw new BusinessException("\u76f4\u8425\u4f53\u7cfb\u76f8\u5173\u4fe1\u606f\u672a\u5b8c\u6574\u586b\u5199");
            }
            deduplicationCode.add(x.getBsDirectSystemCode());
            dataMap.put(x.getLoginAcc(), x.getBsDirectSystemCode());
            deduplicationLoginAcc.add(x.getLoginAcc());
        });
        if (CollectionUtils.isEmpty((Collection)deduplicationLoginAcc)) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        List entityList = this.accountMapper.selectList((Wrapper)wrapper);
        Set loginAccByDb = entityList.stream().map(KmsTenantryDirectAccountEntity::getLoginAcc).collect(Collectors.toSet());
        deduplicationLoginAcc.forEach(x -> {
            if (loginAccByDb.contains(x)) {
                throw new BusinessException(x + "\u7684\u6570\u636e\u5df2\u5b58\u5728");
            }
        });
        LambdaQueryWrapper customerOrgEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)customerOrgEntityLambdaQueryWrapper.eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, (Collection)deduplicationCode)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode());
        List customerOrgEntities = this.customerOrgMapper.selectList((Wrapper)customerOrgEntityLambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)customerOrgEntities)) {
            throw new BusinessException("\u6ca1\u6709\u7ef4\u62a4\u4e2d\u7684\u76f4\u8425\u4f53\u7cfb");
        }
        Set codeByDb = customerOrgEntities.stream().map(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode).collect(Collectors.toSet());
        dataMap.keySet().forEach(x -> {
            String value = (String)dataMap.get(x);
            if (!codeByDb.contains(value)) {
                throw new BusinessException("\u767b\u5f55\u8d26\u53f7" + x + "\u884c\u7684\u6570\u636e\u76f4\u8425\u4f53\u7cfb\u4e0d\u5728\u7ef4\u62a4\u4e2d");
            }
        });
    }
}

