/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.tenantrydirectcustomerorg;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectcustomerorg.KmsTenantryDirectCustomerOrgImportVo;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.util.AssertUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTenantryDirectCustomerOrgValidator")
public class KmsTenantryDirectCustomerOrgValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTenantryDirectCustomerOrgMapper, KmsTenantryDirectCustomerOrgEntity, KmsTenantryDirectCustomerOrgImportVo>
implements ExcelImportValidator<KmsTenantryDirectCustomerOrgImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectCustomerOrgValidator.class);
    @Resource
    private KmsTenantryDirectCustomerOrgMapper customerOrgMapper;
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;
    private List<KmsTenantryDirectCustomerOrgImportVo> importVoList = Lists.newArrayList();
    private List<KmsTenantryDirectCustomerOrgEntity> updateEntities = Lists.newArrayList();

    @Override
    public void validate(List<KmsTenantryDirectCustomerOrgImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet systemCodeSet = Sets.newHashSet();
        HashSet directIdSet = Sets.newHashSet();
        HashSet cusOrgIdSet = Sets.newHashSet();
        data.forEach(x -> {
            AssertUtils.isNotEmpty((String)x.getDirectId(), (String)"\u76f4\u8425\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getBsDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getCustomerOrgId(), (String)"\u7ec4\u7ec7\u5ba2\u6237\u4fe1\u606f\u5fc5\u586b");
            if (systemCodeSet.contains(x.getBsDirectSystemCode())) {
                throw new BusinessException(x.getBsDirectSystemCode() + "\u7684\u7f16\u7801\u91cd\u590d");
            }
            if (directIdSet.contains(x.getDirectId())) {
                throw new BusinessException(x.getDirectId() + "\u7684\u5546\u8d85Id\u91cd\u590d");
            }
            cusOrgIdSet.add(x.getCustomerOrgId());
            systemCodeSet.add(x.getBsDirectSystemCode());
            directIdSet.add(x.getDirectId());
        });
        List cusOrgEntities = this.mdmCusOrgMapper.selectBatchIds(cusOrgIdSet);
        Map mdmCusOrgEntityMap = cusOrgEntities.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        List customerOrgEntities = this.customerOrgMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(KmsTenantryDirectCustomerOrgEntity::getDirectId, (Collection)directIdSet));
        data.forEach(x -> {
            if (!mdmCusOrgEntityMap.containsKey(x.getCustomerOrgId())) {
                throw new BusinessException("\u7ec4\u7ec7\u5ba2\u6237\u4e3a" + x.getCustomerOrgId() + "\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            }
            x.setCustomerOrgCode(((MdmCusOrgEntity)((Object)((Object)mdmCusOrgEntityMap.get(x.getCustomerOrgId())))).getCustomerOrgCode());
            x.setCustomerOrgName(((MdmCusOrgEntity)((Object)((Object)mdmCusOrgEntityMap.get(x.getCustomerOrgId())))).getCustomerOrgName());
            customerOrgEntities.forEach(y -> {
                if (x.getDirectId().equals(y.getDirectId())) {
                    if (y.getEnableStatus().equals(CrmEnableStatusEnum.ENABLE.getCode()) && y.getDelFlag().equals(CrmDelFlagEnum.NORMAL.getCode())) {
                        this.importVoList.add((KmsTenantryDirectCustomerOrgImportVo)((Object)x));
                    } else {
                        y.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                        y.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                        this.updateEntities.add((KmsTenantryDirectCustomerOrgEntity)((Object)((Object)y)));
                    }
                } else {
                    this.importVoList.add((KmsTenantryDirectCustomerOrgImportVo)((Object)x));
                }
            });
        });
        data = this.importVoList;
        this.updateBatchById(this.updateEntities);
    }
}

