/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.tenantrydirectstore;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectstore.KmsTenantryDirectStoreImportVo;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.kms.tenantrydirectstore.entity.KmsTenantryDirectStoreEntity;
import com.biz.crm.kms.tenantrydirectstore.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTenantryDirectStoreValidator")
public class KmsTenantryDirectStoreValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTenantryDirectStoreMapper, KmsTenantryDirectStoreEntity, KmsTenantryDirectStoreImportVo>
implements ExcelImportValidator<KmsTenantryDirectStoreImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectStoreValidator.class);
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Override
    public void validate(List<KmsTenantryDirectStoreImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet deduplicationTerminalCode = Sets.newHashSet();
        HashSet deduplicationDirectCode = Sets.newHashSet();
        HashSet deduplicationStrings = Sets.newHashSet();
        data.forEach(x -> {
            AssertUtils.isNotEmpty((String)x.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u672a\u586b\u5199");
            AssertUtils.isNotEmpty((String)x.getStoreCode(), (String)"\u76f4\u8425\u95e8\u5e97\u7f16\u7801\u672a\u586b\u5199");
            AssertUtils.isNotEmpty((String)x.getTerminalCode(), (String)"\u4f01\u4e1a\u95e8\u5e97\u7f16\u7801\u672a\u586b\u5199");
            if (deduplicationStrings.contains(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode())) {
                throw new BusinessException(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode() + "\u884c\u7684\u6570\u636e\u91cd\u590d");
            }
            if (x.getTimeOfDay() == null) {
                x.setTimeOfDay(0);
            }
            deduplicationStrings.add(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode());
            deduplicationDirectCode.add(x.getBsDirectSystemCode());
            deduplicationTerminalCode.add(x.getTerminalCode());
        });
        if (CollectionUtils.isEmpty((Collection)deduplicationStrings)) {
            return;
        }
        this.checkDirectCusOrgAndTerminal(data, deduplicationTerminalCode, deduplicationDirectCode);
        this.checkDuplicationByDb(deduplicationStrings);
    }

    private void checkDuplicationByDb(Set<String> deduplicationStrings) {
        KmsTenantryDirectStoreReqVo storeReqVo = new KmsTenantryDirectStoreReqVo();
        storeReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectStoreEntity> entities = this.kmsTenantryDirectStoreMapper.selectListByCompetence(storeReqVo);
        HashSet duplicationStringsByDb = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getBsDirectSystemCode()) && StringUtils.isNotBlank((CharSequence)x.getStoreCode()) && StringUtils.isNotBlank((CharSequence)x.getTerminalCode())) {
                    duplicationStringsByDb.add(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode());
                }
            });
        }
        deduplicationStrings.retainAll(duplicationStringsByDb);
        if (CollectionUtils.isNotEmpty(deduplicationStrings)) {
            throw new BusinessException(deduplicationStrings.toString() + "\u884c\u7684\u6570\u636e\u91cd\u590d");
        }
    }

    private void checkDirectCusOrgAndTerminal(List<KmsTenantryDirectStoreImportVo> data, Set<String> deduplicationTerminalCode, Set<String> deduplicationDirectCode) {
        KmsTenantryDirectCustomerOrgReqVo customerOrgReqVo = new KmsTenantryDirectCustomerOrgReqVo();
        customerOrgReqVo.setBsDirectSystemCodeList(deduplicationDirectCode);
        customerOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectCustomerOrgEntity> customerOrgEntities = this.kmsTenantryDirectCustomerOrgMapper.selectListForExcel(customerOrgReqVo);
        if (CollectionUtils.isEmpty(customerOrgEntities)) {
            throw new BusinessException("\u6ca1\u6709\u7ef4\u62a4\u4e2d\u7684\u76f4\u8425\u4f53\u7cfb");
        }
        Map customerOrgEntityMap = customerOrgEntities.stream().collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
        MdmTerminalVo mdmTerminalVo = new MdmTerminalVo();
        mdmTerminalVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmTerminalVo.setTerminalCodeList(new ArrayList<String>(deduplicationTerminalCode));
        List terminalVos = (List)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.listCondition(mdmTerminalVo), (boolean)true);
        Map terminalVoMap = terminalVos.stream().collect(Collectors.toMap(MdmTerminalVo::getTerminalCode, Function.identity()));
        data.forEach(x -> {
            if (!customerOrgEntityMap.containsKey(x.getBsDirectSystemCode())) {
                throw new BusinessException(x.getBsDirectSystemCode() + "\u884c\u7684\u76f4\u8425\u4f53\u7cfb\u4e0d\u5728\u7ef4\u62a4\u4e2d");
            }
            KmsTenantryDirectCustomerOrgEntity customerOrgEntity = (KmsTenantryDirectCustomerOrgEntity)((Object)((Object)customerOrgEntityMap.get(x.getBsDirectSystemCode())));
            x.setBsDirectSystemId(customerOrgEntity.getBsDirectSystemId());
            x.setBsDirectSystemName(customerOrgEntity.getBsDirectSystemName());
            if (!terminalVoMap.containsKey(x.getTerminalCode())) {
                throw new BusinessException(x.getTerminalCode() + "\u884c\u7684\u4f01\u4e1a\u95e8\u5e97\u4e0d\u5728\u7ef4\u62a4\u4e2d");
            }
            x.setTerminalName(((MdmTerminalVo)terminalVoMap.get(x.getTerminalCode())).getTerminalName());
        });
    }
}

