/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.sfa;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaAchievementRuleImportVo;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.sfa.test.entity.SfaAchievementRuleEntity;
import com.biz.crm.sfa.test.entity.SfaIndexEntity;
import com.biz.crm.sfa.test.mapper.SfaAchievementRuleMapper;
import com.biz.crm.sfa.test.mapper.SfaIndexMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component(value="sfaAchievementRuleValidator")
public class SfaAchievementRuleValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<SfaAchievementRuleMapper, SfaAchievementRuleEntity, SfaAchievementRuleImportVo>
implements ExcelImportValidator<SfaAchievementRuleImportVo> {
    private static final Logger log = LoggerFactory.getLogger(SfaAchievementRuleValidator.class);
    @Resource
    private SfaIndexMapper indexMapper;
    @Resource
    private SfaAchievementRuleMapper sfaAchievementRuleMapper;
    @Resource
    private MdmUserFeign mdmUserFeign;
    private static List<SfaIndexEntity> sfaIndexEntityList;

    @Override
    public void validate(List<SfaAchievementRuleImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        if (CollectionUtil.listEmpty(sfaIndexEntityList)) {
            this.findAllIndex();
        }
        HashSet<SfaAchievementRuleImportVo> voSet = new HashSet<SfaAchievementRuleImportVo>();
        data.forEach(v -> {
            StringBuilder msg = new StringBuilder();
            this.doCheckObjectCodeAndName((SfaAchievementRuleImportVo)((Object)v), msg);
            this.doCheckAchievementType((SfaAchievementRuleImportVo)((Object)v), msg);
            this.doCheckAchievementTypeMM((SfaAchievementRuleImportVo)((Object)v), msg);
            this.doCheckAchievementTypeTD((SfaAchievementRuleImportVo)((Object)v), msg);
            this.doCheckAchievementTypeFT((SfaAchievementRuleImportVo)((Object)v), msg);
            if (org.apache.commons.lang.StringUtils.isBlank((String)v.getWeight())) {
                v.setWeight(BigDecimal.ZERO.toString());
            }
            this.doCheckWeight(v.getWeight(), msg);
            this.doCheckTargetNum(v.getTargetNum(), msg);
            this.doCheckIndex((SfaAchievementRuleImportVo)((Object)v), msg);
            if (org.apache.commons.lang.StringUtils.isBlank((String)v.getUnit())) {
                msg.append("\u7ee9\u6548\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            if (org.apache.commons.lang.StringUtils.isEmpty((String)v.getObjectCode()) || org.apache.commons.lang.StringUtils.isEmpty((String)v.getAchievementDate())) {
                msg.append("\u7ee9\u6548\u65f6\u95f4\u8bbe\u7f6e\u5931\u8d25\uff1b");
            }
            if (voSet.contains(v)) {
                msg.append("\u6570\u636e\u91cd\u590d\uff1b");
            }
            voSet.add((SfaAchievementRuleImportVo)((Object)v));
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)msg.toString())) {
                this.errorMsgAndSendWebsocket(v, msg.toString(), context);
            }
        });
        this.distinctData(data, voSet, context);
    }

    private void doCheckAchievementTypeTD(SfaAchievementRuleImportVo v, StringBuilder msg) {
        if (WorkSignEnum.achievementTimeType.TD.getDesc().equals(v.getAchievementType())) {
            this.doCheckMouth(v, msg);
            if (org.apache.commons.lang.StringUtils.isBlank((String)v.getAchievementDateTenDays())) {
                msg.append("\u7ee9\u6548\u65ec\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            if (!WorkSignEnum.achievementTimeType.XX.getDesc().equals(v.getAchievementDateTenDays()) && !WorkSignEnum.achievementTimeType.SX.getDesc().equals(v.getAchievementDateTenDays())) {
                msg.append("\u7ee9\u6548\u65ec\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            }
            StringBuilder achievementDate = new StringBuilder().append(v.getAchievementDateYear()).append("\u5e74").append(v.getAchievementDateMonth()).append("\u6708");
            if (v.getAchievementDateTenDays().equals(WorkSignEnum.achievementTimeType.SX.getDesc())) {
                achievementDate.append(WorkSignEnum.achievementTimeType.SX.getDesc());
            }
            if (v.getAchievementDateTenDays().equals(WorkSignEnum.achievementTimeType.XX.getDesc())) {
                achievementDate.append(WorkSignEnum.achievementTimeType.XX.getDesc());
            }
            v.setAchievementType(WorkSignEnum.achievementTimeType.TD.getVal());
            v.setAchievementDate(achievementDate.toString());
            this.getDayOfDate(v, msg);
        }
    }

    private void doCheckAchievementTypeFT(SfaAchievementRuleImportVo v, StringBuilder msg) {
        if (WorkSignEnum.achievementTimeType.FT.getDesc().equals(v.getAchievementType())) {
            if (org.apache.commons.lang.StringUtils.isBlank((String)v.getBeginDate())) {
                msg.append("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            if (org.apache.commons.lang.StringUtils.isBlank((String)v.getEndDate())) {
                msg.append("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            LocalDate beginDate = null;
            try {
                beginDate = LocalDate.parse(v.getBeginDate(), CrmDateUtils.yyyyMMdd);
            }
            catch (Exception e) {
                msg.append("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff1b");
            }
            LocalDate endDate = null;
            try {
                endDate = LocalDate.parse(v.getEndDate(), CrmDateUtils.yyyyMMdd);
            }
            catch (Exception e) {
                msg.append("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff1b");
            }
            if (!beginDate.isBefore(endDate)) {
                msg.append("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u7ed3\u675f\u65f6\u95f4\uff1b");
            }
            v.setAchievementType(WorkSignEnum.achievementTimeType.FT.getVal());
            v.setAchievementDate(v.getBeginDate() + "-" + v.getEndDate());
        }
    }

    private void doCheckAchievementTypeMM(SfaAchievementRuleImportVo v, StringBuilder msg) {
        if (WorkSignEnum.achievementTimeType.MM.getDesc().equals(v.getAchievementType())) {
            this.doCheckMouth(v, msg);
            v.setAchievementType(WorkSignEnum.achievementTimeType.MM.getVal());
            StringBuilder achievementDate = new StringBuilder().append(v.getAchievementDateYear()).append("\u5e74").append(v.getAchievementDateMonth()).append("\u6708");
            v.setAchievementDate(achievementDate.toString());
            this.getDayOfDate(v, msg);
        }
    }

    public void distinctData(List<SfaAchievementRuleImportVo> data, HashSet<SfaAchievementRuleImportVo> voSet, DefaultImportContext context) {
        Map<String, List<SfaAchievementRuleImportVo>> dataList = voSet.stream().distinct().collect(Collectors.groupingBy(o -> o.getObjectPosCode() + "-" + o.getAchievementDate()));
        dataList.keySet().forEach(s -> {
            boolean zero;
            List vos = (List)dataList.get(s);
            BigDecimal weightTotal = vos.stream().map(m -> new BigDecimal(m.getWeight())).reduce(BigDecimal.ZERO, BigDecimal::add);
            boolean one = weightTotal.compareTo(BigDecimal.ONE) == 0;
            boolean bl = zero = weightTotal.compareTo(BigDecimal.ZERO) == 0;
            if (!one && !zero) {
                ((List)dataList.get(s)).forEach(o -> {
                    if (data.contains(o)) {
                        this.errorMsgAndSendWebsocket(o, "\u6570\u636e\u6743\u91cd\u4e0d\u5408\u6cd5", context);
                    }
                });
            }
            String[] split = s.split("-");
            this.sfaAchievementRuleMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAchievementRuleEntity.class).eq(SfaAchievementRuleEntity::getObjectPosCode, (Object)split[0])).eq(SfaAchievementRuleEntity::getAchievementDate, (Object)split[1]));
        });
    }

    public SfaAchievementRuleImportVo getDayOfDate(SfaAchievementRuleImportVo reqVo, StringBuilder msg) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        String s = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
        Date date = null;
        try {
            date = format.parse(s);
        }
        catch (Exception e) {
            msg.append("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff1b");
            return new SfaAchievementRuleImportVo();
        }
        cale.setTime(date);
        cale.add(2, 0);
        cale.set(5, 1);
        String firstDay = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String lastDay = format.format(cale.getTime());
        if (StringUtils.isNotEmpty((String)reqVo.getAchievementDateTenDays())) {
            if (WorkSignEnum.achievementTimeType.SX.getDesc().equals(reqVo.getAchievementDateTenDays())) {
                lastDay = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
            } else {
                firstDay = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
            }
        }
        reqVo.setBeginDate(firstDay);
        reqVo.setEndDate(lastDay);
        return reqVo;
    }

    public void doCheckWeight(String weight, StringBuilder msg) {
        try {
            BigDecimal w = new BigDecimal(weight);
            if (w.compareTo(BigDecimal.ZERO) == -1 || w.compareTo(BigDecimal.ONE) == 1) {
                msg.append("\u7ee9\u6548\u6743\u91cd\u4e0d\u5408\u6cd5\uff1b");
            }
        }
        catch (Exception e) {
            msg.append("\u7ee9\u6548\u6743\u91cd\u4e0d\u5408\u6cd5\uff1b");
        }
    }

    public void doCheckTargetNum(String targetNum, StringBuilder msg) {
        if (!org.apache.commons.lang.StringUtils.isNumeric((String)targetNum)) {
            msg.append("\u7ee9\u6548\u76ee\u6807\u6570\u91cf\u4e0d\u5408\u6cd5\uff1b");
        }
        try {
            int t = Integer.parseInt(targetNum);
            if (t < YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) {
                msg.append("\u7ee9\u6548\u76ee\u6807\u6570\u91cf\u4e0d\u5408\u6cd5\uff1b");
            }
        }
        catch (Exception e) {
            msg.append("\u7ee9\u6548\u76ee\u6807\u6570\u91cf\u4e0d\u5408\u6cd5\uff1b");
        }
    }

    public void doCheckIndex(SfaAchievementRuleImportVo vo, StringBuilder msg) {
        Map indexMap;
        if (org.apache.commons.lang.StringUtils.isEmpty((String)vo.getIndexCode())) {
            msg.append("\u6307\u6807\u7f16\u7801\u4e3a\u7a7a\uff1b");
        }
        if (org.apache.commons.lang.StringUtils.isEmpty((String)vo.getIndexName())) {
            msg.append("\u6307\u6807\u540d\u79f0\u4e3a\u7a7a\uff1b");
        }
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)vo.getIndexCode()) && org.apache.commons.lang.StringUtils.isNotEmpty((String)vo.getIndexName()) && !(indexMap = sfaIndexEntityList.stream().collect(Collectors.toMap(s -> s.getIndexCode() + "-" + s.getIndexName(), Function.identity(), (k1, k2) -> k2))).containsKey(vo.getIndexCode() + "-" + vo.getIndexName())) {
            msg.append("\u6307\u6807\u4e0d\u5b58\u5728\uff1b");
        }
    }

    public void findAllIndex() {
        sfaIndexEntityList = this.indexMapper.selectList(null);
    }

    private void doCheckObjectCodeAndName(SfaAchievementRuleImportVo vo, StringBuilder msg) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)vo.getObjectCode()) || org.apache.commons.lang.StringUtils.isEmpty((String)vo.getObjectName())) {
            msg.append("\u5bf9\u8c61\u7f16\u7801\u6216\u5bf9\u8c61\u540d\u79f0\u4e3a\u7a7a\uff1b");
        }
        MdmOrgRespVo orgByCode = OrgUtil.getOrgByCode((String)vo.getObjectCode());
        MdmUserRespVo mdmUserRespVo = (MdmUserRespVo)ApiResultUtil.objResult((Result)this.mdmUserFeign.query(new MdmUserReqVo().setUserName(vo.getObjectCode())));
        if (ObjectUtils.isEmpty((Object)orgByCode) && ObjectUtils.isEmpty((Object)mdmUserRespVo)) {
            msg.append("\u7ec4\u7ec7\u6216\u7528\u6237\u4e0d\u5b58\u5728\uff1b");
            return;
        }
        if (!ObjectUtils.isEmpty((Object)orgByCode)) {
            if (!orgByCode.getOrgName().equals(vo.getObjectName())) {
                msg.append("\u7ec4\u7ec7\u7f16\u7801\u4e0e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u5339\u914d\uff1b");
            }
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)vo.getObjectPosName())) {
                msg.append("\u5bfc\u5165\u4e3a\u7ec4\u7ec7\u65f6\uff0c\u804c\u4f4d\u540d\u79f0\u4e3a\u7a7a\uff1b");
            }
            return;
        }
        if (!ObjectUtils.isEmpty((Object)mdmUserRespVo)) {
            List allPosName;
            List allPositionByUsername;
            MdmPositionRespVo position;
            if (!mdmUserRespVo.getFullName().equals(vo.getObjectName())) {
                msg.append("\u5bf9\u8c61\u7f16\u7801\u4e0e\u5bf9\u8c61\u540d\u79f0\u4e0d\u5339\u914d\uff1b");
            }
            if (org.apache.commons.lang.StringUtils.isEmpty((String)vo.getObjectPosCode())) {
                msg.append("\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            if (org.apache.commons.lang.StringUtils.isEmpty((String)vo.getObjectPosName())) {
                msg.append("\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            if (ObjectUtils.isEmpty((Object)(position = PositionUtil.getPositionByCode((String)vo.getObjectPosCode())))) {
                msg.append("\u672a\u627e\u5230\u8be5\u804c\u4f4d\uff1b");
            }
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)vo.getObjectPosName()) && !ObjectUtils.isEmpty((Object)position) && !vo.getObjectPosName().equals(position.getPositionName())) {
                msg.append("\u804c\u4f4d\u7f16\u7801\u4e3a\u804c\u4f4d\u540d\u79f0\u4e0d\u5339\u914d\uff1b");
            }
            if (CollectionUtil.listNotEmpty((List)(allPositionByUsername = PositionUtil.getAllPositionByUsername((String)vo.getObjectCode()))) && !(allPosName = allPositionByUsername.stream().map(MdmPositionRespVo::getPositionName).collect(Collectors.toList())).contains(vo.getObjectPosName())) {
                msg.append("\u804c\u4f4d\u4e0e\u7528\u6237\u4e0d\u5339\u914d\uff1b");
            }
        }
    }

    public void doCheckMouth(SfaAchievementRuleImportVo v, StringBuilder msg) {
        int month;
        if (!org.apache.commons.lang.StringUtils.isNumeric((String)v.getAchievementDateYear()) || !org.apache.commons.lang.StringUtils.isNumeric((String)v.getAchievementDateMonth())) {
            msg.append("\u7ee9\u6548\u5e74\u6708\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
        }
        if (v.getAchievementDateYear().length() != 4) {
            msg.append("\u7ee9\u6548\u5e74\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
        }
        if (v.getAchievementDateMonth().length() == 1) {
            v.setAchievementDateMonth(YesNoEnum.yesNoEnum.ZERO.getValue() + v.getAchievementDateMonth());
        }
        if (v.getAchievementDateMonth().length() != 2) {
            msg.append("\u7ee9\u6548\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
        }
        if ((month = Integer.parseInt(v.getAchievementDateMonth())) > 12 || month < 0) {
            msg.append("\u7ee9\u6548\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
        }
    }

    public void doCheckAchievementType(SfaAchievementRuleImportVo vo, StringBuilder msg) {
        if (!(vo.getAchievementType().equals(WorkSignEnum.achievementTimeType.MM.getDesc()) || vo.getAchievementType().equals(WorkSignEnum.achievementTimeType.TD.getDesc()) || vo.getAchievementType().equals(WorkSignEnum.achievementTimeType.FT.getDesc()))) {
            msg.append("\u7ee9\u6548\u7c7b\u578b\u4e0d\u6b63\u786e\uff1b");
        }
    }
}

