/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.dms.order;

import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.mdm.availablelist.AvailableListFeign;
import com.biz.crm.nebular.dms.order.OrderImportVo;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.util.CollectionUtil;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;

@Component(value="dmsOrderValidator")
public class DmsOrderValidator
implements ExcelImportValidator<OrderImportVo> {
    private static final String DATE_REGEX = "((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1][0-9])|([2][0-4]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?";
    private static final String NUMBER_REGEX = "[+-]?\\d+(\\.\\d+)?";
    @Resource
    private AvailableListFeign availableListFeign;

    @Override
    public void validate(List<OrderImportVo> list, DefaultImportContext defaultImportContext) {
        list.forEach(li -> {
            this.validate(li.getCusCode(), (OrderImportVo)li, "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validate(li.getCusName(), (OrderImportVo)li, "\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            li.setOrderTypeCode(this.getOrderTypeCodeByName(li.getOrderTypeName()));
            this.validate(li.getOrderTypeCode(), (OrderImportVo)li, "\u8ba2\u5355\u7c7b\u578b\u4e0d\u6b63\u786e");
            this.validate(li.getPickAddressCode(), (OrderImportVo)li, "\u9001\u8fbe\u65b9\u4e0d\u80fd\u4e3a\u7a7a");
            this.validate(li.getPickDate(), (OrderImportVo)li, "\u9001\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            this.validatePattern(li.getPickDate(), (OrderImportVo)li, DATE_REGEX, "\u9001\u8d27\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
            li.setPickDate(li.getPickDate().replace("/", "-"));
            this.validate(li.getProductCode(), (OrderImportVo)li, "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validate(li.getCount(), (OrderImportVo)li, "\u8d2d\u4e70\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            this.validatePattern(li.getCount(), (OrderImportVo)li, NUMBER_REGEX, "\u8d2d\u4e70\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
        });
        Map<String, List<OrderImportVo>> orderMap = list.stream().collect(Collectors.groupingBy(OrderImportVo::getCusCode));
        orderMap.forEach((k, v) -> {
            Set<String> productCodes = v.stream().collect(Collectors.groupingBy(OrderImportVo::getProductCode)).keySet();
            this.validateAndSetPrice((List<OrderImportVo>)v, (String)k, productCodes);
        });
    }

    private void validateAndSetPrice(List<OrderImportVo> orderList, String cusCode, Set<String> productCodes) {
        Map result = (Map)this.availableListFeign.findGoodsByCusAndGoodsCodes((List)Lists.newArrayList(productCodes), cusCode).getResult();
        if (!CollectionUtil.mapNotEmpty((Map)result)) {
            result = Maps.newHashMap();
        }
        for (OrderImportVo order : orderList) {
            if (Objects.isNull(result.get(order.getProductCode()))) {
                order.appendErrorValidateMsg("\u5ba2\u6237".concat(order.getCusCode()).concat("-\u5546\u54c1").concat(order.getProductCode()).concat("\u4e0d\u53ef\u8d2d\uff0c\u8bf7\u5148\u7ef4\u62a4\u53ef\u8d2d\u6e05\u5355"));
                continue;
            }
            if (((CusAvailablelistVo)result.get(order.getProductCode())).getPrice() == null) {
                order.appendErrorValidateMsg("\u5ba2\u6237".concat(order.getCusCode()).concat("-\u5546\u54c1").concat(order.getProductCode()).concat("\u4ef7\u683c\u4e0d\u53ef\u7528\uff0c\u8bf7\u5148\u7ef4\u62a4\u4ef7\u683c"));
                continue;
            }
            order.setPrice(((CusAvailablelistVo)result.get(order.getProductCode())).getPrice());
            order.setAmount(new BigDecimal(order.getCount()).multiply(order.getPrice()));
        }
    }

    private String getOrderTypeCodeByName(String name) {
        OrderEunm.TYPE[] types;
        for (OrderEunm.TYPE type : types = OrderEunm.TYPE.values()) {
            if (!Objects.equals(type.getValue(), name)) continue;
            return type.getCode();
        }
        return null;
    }

    private void validatePattern(String value, OrderImportVo li, String regex, String msg) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            li.appendErrorValidateMsg(msg);
        }
    }

    private void validate(Object value, OrderImportVo li, String msg) {
        if (Objects.isNull(value) || Objects.equals("", value)) {
            li.appendErrorValidateMsg(msg);
        }
    }
}

