/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.product;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.product.MdmProductLevelImportVo;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="mdmProductLevelImportValidator")
public class MdmProductLevelImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmProductLevelMapper, MdmProductLevelEntity, MdmProductLevelImportVo>
implements ExcelImportValidator<MdmProductLevelImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelImportValidator.class);
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;

    @Override
    public void validate(List<MdmProductLevelImportVo> data, DefaultImportContext context) {
        this.checkProductLevelNull(data);
        this.checkProductLevelCode(data);
        this.checkProductLevelType(data);
    }

    protected void checkProductLevelNull(List<MdmProductLevelImportVo> vos) {
        vos.stream().forEach(m -> {
            if (StringUtils.isEmpty((String)m.getProductLevelName())) {
                m.appendErrorValidateMsg("\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            if (StringUtils.isEmpty((String)m.getProductLevelTypeName())) {
                m.appendErrorValidateMsg("\u4ea7\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
        });
    }

    protected void checkProductLevelCode(List<MdmProductLevelImportVo> vos) {
        Set productLevelCodeSet = vos.stream().filter(item -> StringUtils.isNotEmpty((String)item.getProductLevelCode())).map(MdmProductLevelImportVo::getProductLevelCode).collect(Collectors.toSet());
        productLevelCodeSet.addAll(vos.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode())).map(MdmProductLevelImportVo::getParentCode).collect(Collectors.toSet()));
        if (productLevelCodeSet.isEmpty()) {
            return;
        }
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmProductLevelEntity::getProductLevelCode, productLevelCodeSet)).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode});
        Set collect = this.mdmProductLevelMapper.selectList((Wrapper)wrapper).stream().filter(m -> StringUtils.isNotEmpty((String)m.getProductLevelCode())).map(MdmProductLevelEntity::getProductLevelCode).collect(Collectors.toSet());
        HashMap<String, Integer> codeIndexMap = new HashMap<String, Integer>(16);
        HashSet<String> productsSet = new HashSet<String>();
        for (MdmProductLevelImportVo vo : vos) {
            if (StringUtils.isNotEmpty((String)vo.getProductLevelCode()) && collect.contains(vo.getProductLevelCode())) {
                vo.appendErrorValidateMsg("\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801:" + vo.getParentCode() + "\u5df2\u5b58\u5728\uff1b");
                continue;
            }
            if (codeIndexMap.containsKey(vo.getProductLevelCode())) {
                vo.appendErrorValidateMsg("\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801:" + vo.getProductLevelCode() + "\u4e0e\u7b2c" + codeIndexMap.get(vo.getProductLevelCode()) + "\u884c\u91cd\u590d\uff1b");
                continue;
            }
            productsSet.add(vo.getProductLevelCode());
            codeIndexMap.put(vo.getProductLevelCode(), vo.getRowIndex());
        }
        productsSet.addAll(collect);
        for (MdmProductLevelImportVo vo : vos) {
            if (!StringUtils.isNotEmpty((String)vo.getParentCode()) || productsSet.contains(vo.getParentCode())) continue;
            vo.appendErrorValidateMsg("\u4ea7\u54c1\u4e0a\u5c42\u7f16\u7801:" + vo.getParentCode() + "\u4e0d\u5b58\u5728\uff1b");
        }
    }

    protected void checkProductLevelType(List<MdmProductLevelImportVo> vos) {
        Map map = DictUtil.dictMap((String)"mdm_product_level_type");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmProductLevelImportVo mdmProductLevelImportVo : vos) {
            String productLevelTypeName = mdmProductLevelImportVo.getProductLevelTypeName();
            if (org.springframework.util.StringUtils.isEmpty((Object)productLevelTypeName)) continue;
            if (!channelMap.containsKey(productLevelTypeName)) {
                mdmProductLevelImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmProductLevelImportVo.getRowIndex() + "\u4ea7\u54c1\u5c42\u7ea7\u7c7b\u578b\u5b57\u5178mdm_product_level_type:" + productLevelTypeName + "\u4e0d\u5b58\u5728;");
                continue;
            }
            mdmProductLevelImportVo.setProductLevelType((String)channelMap.get(productLevelTypeName));
        }
    }
}

