/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.export.extend.head.sfa;

import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.util.CollectionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="line_group_managementExportHeadExtend")
public class VisitGroupListExportHeadExtend
implements ExportHeadExtend {
    private static final Logger log = LoggerFactory.getLogger(VisitGroupListExportHeadExtend.class);
    private static final String CLIENT_NAME = "\u7ec8\u7aef";
    private static final String CLIENT_CODE = "clientCode";
    private static final String CLIENT_NAMES = "clientNames";

    @Override
    public List<MdmColumnExportRespVo> getHeads(ExportHeadExtend.ExportHeadExtendParam headExtendParam) throws BusinessException {
        Integer headVariableSum = headExtendParam.getHeadVariableSum();
        ArrayList columnExportRespVos = Lists.newArrayList();
        this.buildColumn(headVariableSum, columnExportRespVos);
        return columnExportRespVos;
    }

    private void buildColumn(Integer headVariableSum, List<MdmColumnExportRespVo> columnExportRespVos) {
        for (int i = 1; i <= headVariableSum; ++i) {
            MdmColumnExportRespVo columnExportRespVo = new MdmColumnExportRespVo();
            columnExportRespVo.setField(CLIENT_CODE + i);
            columnExportRespVo.setTitle(CLIENT_NAME + i);
            columnExportRespVos.add(columnExportRespVo);
        }
    }

    @Override
    public List<Map> getHeadsValue(DefaultExportContext exportContext, List<Map> value) {
        if (CollectionUtil.listNotEmpty(value)) {
            value.forEach(v -> this.buildDate(exportContext, (Map)v));
        }
        return value;
    }

    private Map buildDate(DefaultExportContext exportContext, Map dataRow) {
        String clientNames = (String)dataRow.get(CLIENT_NAMES);
        String[] clientName = clientNames.split(",");
        if (clientName.length > exportContext.getHeadVariableSum()) {
            exportContext.setHeadVariableSum(clientName.length);
        }
        for (int i = 0; i < clientName.length; ++i) {
            dataRow.put(CLIENT_CODE + (i + 1), clientName[i]);
        }
        return dataRow;
    }
}

