/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.service.IExcelService;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.tpm.FeeBudgetImportVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/excelController"})
@Api(tags={"excel\u5bfc\u5165\u5bfc\u51fa "})
public class ExcelController {
    private static final Logger log = LoggerFactory.getLogger(ExcelController.class);
    @Resource
    private IExcelService excelService;
    @Resource(name="tpmFeeBudgetImportSavor")
    private ExcelImportSaver saver;

    @ApiOperation(value="\u52a8\u6001\u5bfc\u51faexcel")
    @PostMapping(value={"/repeatedWriteExport"})
    @CrmLog
    public Result repeatedWriteExport(@RequestBody HashMap<String, Object> requestParamMap) {
        this.excelService.repeatedWriteExport(requestParamMap);
        return Result.ok();
    }

    @ApiOperation(value="\u6d4b\u8bd5")
    @GetMapping(value={"/test"})
    @CrmLog
    public Result test() {
        DefaultImportContext context = new DefaultImportContext();
        ArrayList data = Lists.newArrayList();
        FeeBudgetImportVo vo = new FeeBudgetImportVo();
        vo.setBudgetYear("2021");
        vo.setBudgetMonth("1");
        vo.setBudgetSubjectsCode("121");
        vo.setProjectNumber("zb0222");
        vo.setOrgCode("CRM001");
        vo.setInitAmount("40000");
        data.add(vo);
        this.saver.save(data, context);
        return Result.ok();
    }
}

