/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.config.OperatorInterceptor;
import com.biz.crm.data.TpmDruidParam;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(value={"com.biz.crm.tpm.**.mapper*"}, sqlSessionTemplateRef="tpmSqlSessionTemplate")
public class TpmDruidConfig {
    private static final Logger log = LoggerFactory.getLogger(TpmDruidConfig.class);
    @Resource
    private TpmDruidParam tpmDruidParam;

    @Bean(value={"tpmDataSource"})
    public DataSource tpmDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.tpmDruidParam.getDbUrl());
        datasource.setUsername(this.tpmDruidParam.getUsername());
        datasource.setPassword(this.tpmDruidParam.getPassword());
        datasource.setDriverClassName(this.tpmDruidParam.getDriverClassName());
        datasource.setInitialSize(this.tpmDruidParam.getInitialSize());
        datasource.setMinIdle(this.tpmDruidParam.getMinIdle());
        datasource.setMaxActive(this.tpmDruidParam.getMaxActive());
        datasource.setMaxWait((long)this.tpmDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis((long)this.tpmDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis((long)this.tpmDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis((long)this.tpmDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(this.tpmDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(this.tpmDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(this.tpmDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(this.tpmDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(this.tpmDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.tpmDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(this.tpmDruidParam.getFilters());
        }
        catch (Exception e) {
            log.error("druid configuration initialization filter", (Throwable)e);
        }
        datasource.setConnectionProperties(this.tpmDruidParam.getConnectionProperties());
        return datasource;
    }

    @Bean
    public SqlSessionFactory tpmSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(this.tpmDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/tpm/**/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new OperatorInterceptor());
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }

    @Bean(name={"tpmTransactionManager"})
    @Primary
    public DataSourceTransactionManager tpmTransactionManager() {
        return new DataSourceTransactionManager(this.tpmDataSource());
    }

    @Primary
    @Bean(name={"tpmSqlSessionTemplate"})
    public SqlSessionTemplate tpmSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(this.tpmSqlSessionFactory());
    }
}

