/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.kms.kaproduct;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.kaproduct.KmsTenantryDirectProductImportVo;
import com.biz.crm.kms.kaproduct.entity.KmsTenantryDirectProductEntity;
import com.biz.crm.kms.kaproduct.entity.KmsTenantryDirectProductUnitEntity;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductUnitMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="kmsTenantryDirectProductImportSave")
@Transactional(value="kmsTransactionManager", rollbackFor={Exception.class})
public class KmsTenantryDirectProductImportSave<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<KmsTenantryDirectProductMapper, KmsTenantryDirectProductEntity, KmsTenantryDirectProductImportVo>
implements ExcelImportSaver<KmsTenantryDirectProductImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectProductImportSave.class);
    @Resource
    private KmsTenantryDirectProductUnitMapper unitMapper;

    @Override
    public void save(List<KmsTenantryDirectProductImportVo> data, DefaultImportContext context) {
        log.info("\u6570\u636e\u4fdd\u5b58:{}", data);
        List dateList = Lists.partition(data, (int)50);
        ArrayList list = Lists.newArrayList();
        dateList.forEach(v -> {
            for (int i = 0; i < v.size(); ++i) {
                if (((KmsTenantryDirectProductImportVo)((Object)((Object)v.get(i)))).getProcessType() != AbstractImportVo.ProcessTypeEnum.SUCCESS) continue;
                list.add(v.get(i));
            }
        });
        this.saveBatch(CrmBeanUtil.copyList((List)list, KmsTenantryDirectProductEntity.class));
        this.convertAndSaveUnit(data);
    }

    private void convertAndSaveUnit(List<KmsTenantryDirectProductImportVo> data) {
        ArrayList productUnitEntities = Lists.newArrayList();
        data.forEach(x -> {
            KmsTenantryDirectProductUnitEntity entity = new KmsTenantryDirectProductUnitEntity();
            entity.setTenantryDirectProductId(x.getId());
            entity.setUnitCode(x.getUnitCode());
            entity.setUnitName(x.getUnitName());
            entity.setOrderType(x.getOrderType());
            entity.setKaUnitCode(x.getKaUnitCode());
            entity.setRatio(x.getRatio());
            entity.setId(StringUtils.replaceAll((String)UUID.randomUUID().toString(), (String)"-", (String)""));
            entity.setNumerator(x.getNumerator());
            UserRedis userRedis = UserUtils.getUser();
            entity.setCreateCode(userRedis.getUsername());
            entity.setCreateDate(DateUtil.formatDate());
            entity.setCreateDateSecond(DateUtil.formatShortTime());
            entity.setCreateDateAll(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
            entity.setCreateOrgCode(userRedis.getOrgcode());
            entity.setCreateOrgName(userRedis.getOrgname());
            entity.setCreatePosCode(userRedis.getPoscode());
            entity.setCreatePosName(userRedis.getPosname());
            entity.setCreateName(userRedis.getRealname());
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            productUnitEntities.add(entity);
        });
        if (CollectionUtils.isNotEmpty((Collection)productUnitEntities)) {
            this.unitMapper.insertBatch(productUnitEntities);
        }
    }
}

