/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.acceptanceform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.acceptanceform.KmsAcceptanceFormImportVo;
import com.biz.crm.kms.confadmin.entity.KmsDirectStoreEntity;
import com.biz.crm.kms.confadmin.entity.KmsDirectSystemEntity;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.kms.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.kms.form.acceptanceform.entity.KmsAcceptanceFormEntity;
import com.biz.crm.kms.form.acceptanceform.mapper.AcceptanceFormMapper;
import com.biz.crm.kms.kaproduct.entity.KmsTenantryDirectProductEntity;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.kms.tenantrydirectstore.entity.KmsTenantryDirectStoreEntity;
import com.biz.crm.kms.tenantrydirectstore.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.util.CodeUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="kmsAcceptanceFormValidator")
public class KmsAcceptanceFormValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<AcceptanceFormMapper, KmsAcceptanceFormEntity, KmsAcceptanceFormImportVo>
implements ExcelImportValidator<KmsAcceptanceFormImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsAcceptanceFormValidator.class);
    @Value(value="${kms.config.tenantry-id:}")
    private String tenantryId;
    private Map<String, KmsDirectSystemEntity> spareDirectSystemMap = Maps.newHashMap();
    private Map<String, Map<String, KmsTenantryDirectStoreEntity>> spareTenantryDirectStoreMap = Maps.newHashMap();
    private Map<String, Map<String, KmsDirectStoreEntity>> spareDirectStoreMap = Maps.newHashMap();
    private Map<String, MdmCustomerEntity> spareCustomerMap = Maps.newHashMap();
    private Set<String> systemIdSet = Sets.newHashSet();
    private Map<String, List<KmsTenantryDirectCustomerOrgEntity>> spareCusOrgMap = Maps.newHashMap();
    @Resource
    private KmsDirectSystemMapper kmsDirectSystemMapper;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private AcceptanceFormMapper acceptanceFormMapper;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    @Override
    public void validate(List<KmsAcceptanceFormImportVo> data, DefaultImportContext context) {
        ConcurrentHashMap map = ThreadLocalUtil.get();
        map.put("functionCode", "acceptance_order_list");
        map.put("menuCode", "CRM20210528000001877");
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet kaNameSet = Sets.newHashSet();
        HashSet kaStoreCodeSet = Sets.newHashSet();
        HashSet orderNumberSet = Sets.newHashSet();
        HashSet kaOrderNumberSet = Sets.newHashSet();
        HashSet storeCode = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getKaName())) {
                x.appendErrorValidateMsg("\u6ca1\u6709\u586b\u5199\u3010\u5546\u8d85\u540d\u79f0\u3011\u3001");
            }
            kaNameSet.add(x.getKaName());
            if (StringUtils.isBlank((CharSequence)x.getKaStoreCode())) {
                x.appendErrorValidateMsg("\u6ca1\u6709\u586b\u5199\u3010\u5546\u8d85\u95e8\u5e97\u7f16\u7801\u3011\u3001");
            }
            kaStoreCodeSet.add(x.getKaStoreCode());
            if (StringUtils.isBlank((CharSequence)x.getKaOrderNumber())) {
                x.appendErrorValidateMsg("\u6ca1\u6709\u586b\u5199\u3010\u5ba2\u6237\u9a8c\u6536\u5355\u53f7\u3011\u3001");
            }
            if (kaOrderNumberSet.contains(x.getKaOrderNumber())) {
                x.appendErrorValidateMsg("\u3010\u5ba2\u6237\u9a8c\u6536\u5355\u53f7\u3011\u5728excel\u4e2d\u91cd\u590d\u3001");
            } else {
                kaOrderNumberSet.add(x.getKaOrderNumber());
            }
            if (StringUtils.isBlank((CharSequence)x.getStoreCode())) {
                x.appendErrorValidateMsg("\u6ca1\u6709\u586b\u5199\u3010\u4f01\u4e1a\u95e8\u5e97\u3011");
            }
            if (StringUtils.isBlank((CharSequence)x.getStoreCode())) {
                storeCode.add(x.getStoreCode());
            }
        });
        this.spareData(kaNameSet, kaStoreCodeSet, storeCode, data);
        data.forEach(x -> {
            x.setTenantryId(this.tenantryId);
            x.setRawDataId(StringUtils.replace((String)UUID.randomUUID().toString(), (String)"-", (String)""));
            x.setOrderNumber(CodeUtil.createOneCode((String)"acceptance_form"));
            x.setId(x.getOrderNumber());
        });
        this.checkGoods(data);
        this.checkDataExist(kaOrderNumberSet, data);
    }

    private void checkDataExist(Set<String> kaOrderNumberSet, List<KmsAcceptanceFormImportVo> data) {
    }

    private void spareData(Set<String> kaNameSet, Set<String> kaStoreCodeSet, Set<String> storeCode, List<KmsAcceptanceFormImportVo> data) {
        if (CollectionUtils.isNotEmpty(kaNameSet)) {
            this.spareDirectSystemData(kaNameSet);
        }
        data.forEach(x -> {
            if (this.spareDirectSystemMap.containsKey(x.getKaName())) {
                x.setKaCode(this.spareDirectSystemMap.get(x.getKaName()).getId());
                this.systemIdSet.add(x.getKaCode());
                x.setDirectId(x.getKaCode());
            } else {
                x.appendErrorValidateMsg("\u3010" + x.getKaName() + "\u3011\u7684\u5546\u8d85\u7cfb\u7edf\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
            }
        });
        KmsTenantryDirectCustomerOrgReqVo reqVo = new KmsTenantryDirectCustomerOrgReqVo();
        reqVo.setDirectIdList((List)Lists.newArrayList(this.systemIdSet));
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTenantryDirectCustomerOrgEntity> customerOrgEntities = this.kmsTenantryDirectCustomerOrgMapper.selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(customerOrgEntities)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u627e\u4e0d\u5230\u5173\u8054\u7684\u76f4\u8425\u4f53\u7cfb"));
            return;
        }
        this.spareCusOrgMap = customerOrgEntities.stream().collect(Collectors.groupingBy(BaseIdEntity::getId));
        Map<String, List<KmsTenantryDirectCustomerOrgEntity>> customerOrgEntityMap = customerOrgEntities.stream().collect(Collectors.groupingBy(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemName));
        data.forEach(x -> {
            if (customerOrgEntityMap.containsKey(x.getKaName())) {
                x.setBsDirectSystemId(((KmsTenantryDirectCustomerOrgEntity)((Object)((Object)((List)customerOrgEntityMap.get(x.getKaName())).get(0)))).getBsDirectSystemId());
            }
        });
        if (CollectionUtils.isNotEmpty(kaStoreCodeSet) && CollectionUtils.isNotEmpty(kaNameSet)) {
            this.spareDirectStoreData(kaStoreCodeSet, kaNameSet);
        }
        data.forEach(x -> {
            if (this.spareDirectStoreMap.containsKey(x.getDirectId())) {
                if (this.spareDirectStoreMap.get(x.getDirectId()).containsKey(x.getKaStoreCode())) {
                    KmsDirectStoreEntity entity = this.spareDirectStoreMap.get(x.getDirectId()).get(x.getKaStoreCode());
                    x.setKaStoreName(entity.getStoreName());
                } else {
                    x.appendErrorValidateMsg("\u3010\u5546\u8d85\u95e8\u5e97\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3011");
                }
            } else {
                x.appendErrorValidateMsg("\u3010\u5546\u8d85\u95e8\u5e97\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3011");
            }
        });
        if (CollectionUtils.isNotEmpty(storeCode) && CollectionUtils.isNotEmpty(kaStoreCodeSet)) {
            this.spareTenantryStoreData(storeCode, kaStoreCodeSet);
        }
        data.forEach(x -> {
            if (this.spareTenantryDirectStoreMap.containsKey(x.getBsDirectSystemId()) && this.spareTenantryDirectStoreMap.get(x.getBsDirectSystemId()).containsKey(x.getKaStoreCode())) {
                if (this.spareTenantryDirectStoreMap.get(x.getBsDirectSystemId()).get(x.getKaStoreCode()).getStoreCode().equals(x.getStoreCode())) {
                    x.setStoreName(this.spareTenantryDirectStoreMap.get(x.getBsDirectSystemId()).get(x.getKaStoreCode()).getStoreName());
                    x.setStoreRelatedId(this.spareTenantryDirectStoreMap.get(x.getBsDirectSystemId()).get(x.getKaStoreCode()).getId());
                } else {
                    x.appendErrorValidateMsg("\u4f01\u4e1a\u95e8\u5e97\u548c\u5546\u8d85\u95e8\u5e97\u4e0d\u5bf9\u5e94");
                }
            }
        });
    }

    private void spareTenantryStoreData(Set<String> storeCode, Set<String> kaStoreCodeSet) {
        KmsTenantryDirectStoreReqVo reqVo = new KmsTenantryDirectStoreReqVo();
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        reqVo.setKaStoreCodes((List)Lists.newArrayList(kaStoreCodeSet));
        reqVo.setBsDirectSystemIdList((List)Lists.newArrayList(this.spareCusOrgMap.keySet()));
        List<KmsTenantryDirectStoreEntity> entities = this.kmsTenantryDirectStoreMapper.selectListByCompetence(reqVo);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        entities.forEach(x -> {
            if (this.spareTenantryDirectStoreMap.containsKey(x.getBsDirectSystemId())) {
                this.spareTenantryDirectStoreMap.get(x.getBsDirectSystemId()).put(x.getStoreCode(), (KmsTenantryDirectStoreEntity)((Object)x));
            } else {
                HashMap entityMap = Maps.newHashMap();
                entityMap.put(x.getStoreCode(), x);
                this.spareTenantryDirectStoreMap.put(x.getBsDirectSystemId(), entityMap);
            }
        });
    }

    private void spareDirectStoreData(Set<String> kaStoreCodeSet, Set<String> kaNameSet) {
        if (CollectionUtils.isEmpty(kaStoreCodeSet) || CollectionUtils.isEmpty(this.systemIdSet)) {
            return;
        }
        List storeEntities = this.kmsDirectStoreMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsDirectStoreEntity::getStoreCode, kaStoreCodeSet)).in(KmsDirectStoreEntity::getDirectId, this.systemIdSet)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        if (CollectionUtils.isEmpty((Collection)storeEntities)) {
            return;
        }
        storeEntities.forEach(x -> {
            if (this.spareDirectStoreMap.containsKey(x.getDirectId())) {
                this.spareDirectStoreMap.get(x.getDirectId()).put(x.getStoreCode(), (KmsDirectStoreEntity)((Object)x));
            } else {
                HashMap map = Maps.newHashMap();
                map.put(x.getStoreCode(), x);
                this.spareDirectStoreMap.put(x.getDirectId(), map);
            }
        });
    }

    private void spareDirectSystemData(Set<String> kaNameSet) {
        if (CollectionUtils.isEmpty(kaNameSet)) {
            return;
        }
        List kmsDirectSystemEntities = this.kmsDirectSystemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsDirectSystemEntity::getDirectName, kaNameSet)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        if (CollectionUtils.isEmpty((Collection)kmsDirectSystemEntities)) {
            return;
        }
        this.spareDirectSystemMap = kmsDirectSystemEntities.stream().collect(Collectors.toMap(KmsDirectSystemEntity::getDirectName, Function.identity()));
    }

    private void checkGoods(List<KmsAcceptanceFormImportVo> data) {
        HashSet goodsCodeSet = Sets.newHashSet();
        HashSet kaGoodsCodeSet = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getGoodsCode())) {
                x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u4ea7\u54c1\u3011\u4fe1\u606f\u672a\u586b\u5199\u3001");
            } else {
                goodsCodeSet.add(x.getGoodsCode());
            }
            if (StringUtils.isBlank((CharSequence)x.getKaGoodsCode()) && StringUtils.isNotBlank((CharSequence)x.getGoodsBarCode())) {
                x.appendErrorValidateMsg("\u3010\u5546\u8d85\u4ea7\u54c1\u3011\u4fe1\u606f\u672a\u586b\u5199,\uff08\u7f16\u7801\u6216\u8005\u56fd\u9645\u6761\u5f62\u7801\uff09\u3001");
            }
            if (StringUtils.isNotBlank((CharSequence)x.getKaGoodsCode())) {
                kaGoodsCodeSet.add(x.getKaGoodsCode());
            }
            if (StringUtils.isBlank((CharSequence)x.getAcceptanceAmount())) {
                x.appendErrorValidateMsg("\u3010\u9a8c\u6536\u91d1\u989d\u5c0f\u8bb0\uff08\u542b\u7a0e\uff09\u3011\u672a\u586b\u5199\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getAcceptanceAmountNot())) {
                x.appendErrorValidateMsg("\u3010\u9a8c\u6536\u91d1\u989d\u5c0f\u8ba1\uff08\u4e0d\u542b\u7a0e\uff09\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getSpecification())) {
                x.appendErrorValidateMsg("\u3010\u4ea7\u54c1\u89c4\u683c\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getOrderQuantity())) {
                x.appendErrorValidateMsg("\u3010\u8ba2\u8d27\u6570\u91cf\u3011\u672a\u586b\u5199\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getCurUnit())) {
                x.appendErrorValidateMsg("\u3010\u5355\u4f4d\u3011\u672a\u586b\u5199\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getCurUnitAcceptanceQuantity())) {
                x.appendErrorValidateMsg("\u3010\u9a8c\u6536\u6570\u91cf\u3011\u672a\u586b\u5199\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getCurCompanyUnit())) {
                x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u5355\u4f4d\u3011\u672a\u586b\u5199\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getCurCompanyUnitQuantity())) {
                x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u5355\u4f4d\u6570\u91cf\u3011\u672a\u586b\u5199\u3001");
            }
        });
        this.checkAndConvert(data, goodsCodeSet, kaGoodsCodeSet);
    }

    private void checkAndConvert(List<KmsAcceptanceFormImportVo> data, Set<String> goodsCodeSet, Set<String> kaGoodsCodeSet) {
        KmsTenantryDirectProductReqVo reqVo = new KmsTenantryDirectProductReqVo();
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setKaProductCodes((List)Lists.newArrayList(kaGoodsCodeSet));
        reqVo.setProductCodes((List)Lists.newArrayList(goodsCodeSet));
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTenantryDirectProductEntity> productEntities = this.kmsTenantryDirectProductMapper.selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(productEntities)) {
            data.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getKaGoodsCode())) {
                    x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u4ea7\u54c1\u548c\u5546\u8d85\u4ea7\u54c1\u6682\u65e0\u5173\u8054\u3011\u3001");
                }
            });
            return;
        }
        HashMap map = Maps.newHashMap();
        productEntities.forEach(x -> {
            if (map.containsKey(x.getBsDirectSystemId())) {
                ((List)((Map)map.get(x.getBsDirectSystemId())).get(x.getKaProductCode() + x.getProductCode())).add(x);
            } else {
                HashMap entityMap = Maps.newHashMap();
                entityMap.put(x.getKaProductCode() + x.getProductCode(), Lists.newArrayList((Object[])new KmsTenantryDirectProductEntity[]{x}));
                map.put(x.getBsDirectSystemId(), entityMap);
            }
        });
        data.forEach(x -> {
            if (map.containsKey(x.getBsDirectSystemId())) {
                if (((Map)map.get(x.getBsDirectSystemId())).containsKey(x.getKaGoodsCode() + x.getGoodsCode())) {
                    KmsTenantryDirectProductEntity entity = (KmsTenantryDirectProductEntity)((Object)((Object)((List)((Map)map.get(x.getBsDirectSystemId())).get(x.getKaGoodsCode() + x.getGoodsCode())).get(0)));
                    x.setGoodsRelatedId(entity.getId());
                    x.setGoodsName(entity.getProductName());
                    x.setKaGoodsName(x.getGoodsName());
                } else {
                    x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u4ea7\u54c1\u548c\u5546\u8d85\u4ea7\u54c1\u6682\u65e0\u5173\u8054\u3011\u3001");
                }
            } else {
                x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u4ea7\u54c1\u548c\u5546\u8d85\u4ea7\u54c1\u6682\u65e0\u5173\u8054\u3011\u3001");
            }
        });
    }
}

