/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.config.OperatorInterceptor;
import com.biz.crm.data.FeeDruidParam;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(value={"com.biz.crm.fee.**.mapper*"}, sqlSessionTemplateRef="feeSqlSessionTemplate")
public class FeeDruidConfig {
    private static final Logger log = LoggerFactory.getLogger(FeeDruidConfig.class);
    @Resource
    private FeeDruidParam feeDruidParam;

    @Bean(value={"feeDataSource"})
    public DataSource feeDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.feeDruidParam.getDbUrl());
        datasource.setUsername(this.feeDruidParam.getUsername());
        datasource.setPassword(this.feeDruidParam.getPassword());
        datasource.setDriverClassName(this.feeDruidParam.getDriverClassName());
        datasource.setInitialSize(this.feeDruidParam.getInitialSize());
        datasource.setMinIdle(this.feeDruidParam.getMinIdle());
        datasource.setMaxActive(this.feeDruidParam.getMaxActive());
        datasource.setMaxWait((long)this.feeDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis((long)this.feeDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis((long)this.feeDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis((long)this.feeDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(this.feeDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(this.feeDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(this.feeDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(this.feeDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(this.feeDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.feeDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(this.feeDruidParam.getFilters());
        }
        catch (Exception e) {
            log.error("druid configuration initialization filter", (Throwable)e);
        }
        datasource.setConnectionProperties(this.feeDruidParam.getConnectionProperties());
        return datasource;
    }

    @Bean
    public SqlSessionFactory feeSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(this.feeDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/fee/**/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new OperatorInterceptor());
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }

    @Bean(name={"feeTransactionManager"})
    @Primary
    public DataSourceTransactionManager feeTransactionManager() {
        return new DataSourceTransactionManager(this.feeDataSource());
    }

    @Primary
    @Bean(name={"feeSqlSessionTemplate"})
    public SqlSessionTemplate feeSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(this.feeSqlSessionFactory());
    }
}

