/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.tpm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.excel.vo.tpm.FeeBudgetImportVo;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.tpm.feebudget.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.tpm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.tpm.feebudget.model.TpmBudgetSubjectsEntity;
import com.biz.crm.tpm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.tpm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.tpm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FeeBudgetServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(FeeBudgetServiceHelper.class);
    @Resource
    private TpmFeeBudgetMapper mapper;
    @Resource
    private TpmFeeBudgetDetailsMapper detailsMapper;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Resource
    private TpmFeeBudgetControlMapper controlMapper;
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Resource
    private MdmOrgMapper orgMapper;
    @Resource
    private MdmProductLevelMapper levelMapper;
    @Resource
    private TpmBudgetSubjectsMapper subjectsMapper;

    public Map<String, MdmProductEntity> getProductMap(Set<String> codes) {
        Map<Object, Object> productMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(codes)) {
            LambdaQueryWrapper productWrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmProductEntity::getProductCode, codes)).select(new SFunction[]{MdmProductEntity::getProductCode, MdmProductEntity::getProductName, CrmBaseEntity::getEnableStatus, MdmProductEntity::getIsShelf, MdmProductEntity::getProductLevelCode});
            productMap = this.mdmProductMapper.selectList((Wrapper)productWrapper).stream().filter(x -> x != null && !org.springframework.util.StringUtils.isEmpty((Object)x.getProductCode())).collect(Collectors.toMap(MdmProductEntity::getProductCode, Function.identity()));
        }
        return productMap;
    }

    public Map<String, MdmProductLevelEntity> getProductLevelMap(Set<String> codes) {
        Map<Object, Object> productLevelMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(codes)) {
            LambdaQueryWrapper productLevelWrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmProductLevelEntity::getProductLevelCode, codes)).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName, CrmBaseEntity::getEnableStatus});
            productLevelMap = this.levelMapper.selectList((Wrapper)productLevelWrapper).stream().collect(Collectors.toMap(MdmProductLevelEntity::getProductLevelCode, Function.identity()));
        }
        return productLevelMap;
    }

    public Map<String, TpmBudgetSubjectsEntity> getSubjectMap(Set<String> codes) {
        Map<Object, Object> subjectMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(codes)) {
            LambdaQueryWrapper subjectWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, codes);
            subjectMap = this.subjectsMapper.selectList((Wrapper)subjectWrapper).stream().filter(x -> x != null && !org.springframework.util.StringUtils.isEmpty((Object)x.getBudgetSubjectsCode())).collect(Collectors.toMap(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, Function.identity()));
        }
        return subjectMap;
    }

    public Map<String, MdmOrgEntity> getOrgMap(Set<String> codes) {
        Map<Object, Object> orgMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(codes)) {
            LambdaQueryWrapper subjectWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmOrgEntity::getOrgCode, codes);
            orgMap = this.orgMapper.selectList((Wrapper)subjectWrapper).stream().filter(x -> x != null && !org.springframework.util.StringUtils.isEmpty((Object)x.getOrgCode())).collect(Collectors.toMap(MdmOrgEntity::getOrgCode, Function.identity()));
        }
        return orgMap;
    }

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("fiscal_year");
        dictCodes.add("fiscal_month");
        dictCodes.add("fiscal_quater");
        dictCodes.add("enable_status");
        dictCodes.add("channel");
        dictCodes.add("fee_budget_type");
        dictCodes.add("control_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public String getErrorMsg(TpmFeeBudgetReqVo reqVo) {
        StringBuffer msg = new StringBuffer("\u5df2\u5b58\u5728,");
        msg.append(" \u5e74\u4efd:").append(reqVo.getBudgetYear());
        msg.append(",\u6708\u4efd:").append(Optional.ofNullable(reqVo.getBudgetMonth()).orElse(""));
        msg.append(",\u5ba2\u6237\u7f16\u7801:").append(reqVo.getCustomerCode());
        msg.append(",\u9884\u7b97\u79d1\u76ee\u7f16\u7801:").append(reqVo.getBudgetSubjectsCode());
        msg.append(",\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801:").append(reqVo.getProductLevelCode());
        msg.append(",\u4ea7\u54c1\u7f16\u7801:").append(reqVo.getProductCode());
        msg.append(",\u7ec4\u7ec7\u7f16\u7801:").append(reqVo.getOrgCode());
        msg.append(",\u6e20\u9053:").append(reqVo.getChannel());
        msg.append(",\u95e8\u5e97\u7f16\u7801:").append(reqVo.getTerminalCode());
        msg.append(",\u7684\u8d39\u7528\u9884\u7b97\u6570\u636e");
        return msg.toString();
    }

    public void checkDataExist(FeeBudgetImportVo reqVo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TpmFeeBudgetEntity::getBudgetYear, (Object)reqVo.getBudgetYear());
        queryWrapper.eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getBudgetMonth()), TpmFeeBudgetEntity::getBudgetMonth, (Object)reqVo.getBudgetMonth());
        queryWrapper.eq(TpmFeeBudgetEntity::getBudgetSubjectsCode, (Object)reqVo.getBudgetSubjectsCode());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getProductLevelCode())) {
            queryWrapper.eq(TpmFeeBudgetEntity::getProductLevelCode, (Object)reqVo.getProductLevelCode());
        } else {
            queryWrapper.isNull(TpmFeeBudgetEntity::getProductLevelCode);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getProductCode())) {
            queryWrapper.eq(TpmFeeBudgetEntity::getProductCode, (Object)reqVo.getProductCode());
        } else {
            queryWrapper.isNull(TpmFeeBudgetEntity::getProductCode);
        }
        queryWrapper.eq(TpmFeeBudgetEntity::getOrgCode, (Object)reqVo.getOrgCode());
        queryWrapper.eq(CrmExtEntity::getExt1, (Object)reqVo.getProjectNumber());
        Integer count = this.mapper.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            reqVo.appendErrorSaveMsg("\u5f53\u524d\u7ef4\u5ea6\u6570\u636e\u5df2\u7ecf\u5b58\u5728,\u4e0d\u80fd\u6267\u884c\u5bfc\u5165\u64cd\u4f5c;");
        }
    }

    public TpmFeeBudgetDetailsEntity transformDetail(TpmFeeBudgetEntity entity) {
        TpmFeeBudgetDetailsEntity detailsEntity = new TpmFeeBudgetDetailsEntity();
        CrmBeanUtil.copyProperties((Object)((Object)entity), (Object)((Object)detailsEntity));
        detailsEntity.setId(null);
        detailsEntity.setBusinessCode(detailsEntity.getFeeBudgetCode());
        FeeBudgetDetailTypeEnum detailTypeEnum = null;
        BigDecimal afterAmount = BigDecimal.ZERO;
        BigDecimal beforAmount = BigDecimal.ZERO;
        BigDecimal feeAmount = BigDecimal.ZERO;
        detailTypeEnum = FeeBudgetDetailTypeEnum.INIT;
        beforAmount = BigDecimal.ZERO;
        afterAmount = entity.getInitAmount();
        feeAmount = entity.getInitAmount();
        detailsEntity.setBusinessRemarks("\u671f\u521d\u5bfc\u5165");
        detailsEntity.setFeeBudgetDetailType(detailTypeEnum.getCode());
        detailsEntity.setFeeBudgetDetailTypeName(detailTypeEnum.getDes());
        detailsEntity.setMonth(entity.getBudgetMonth());
        detailsEntity.setYear(entity.getBudgetYear());
        detailsEntity.setAfterAmount(afterAmount);
        detailsEntity.setFeeAmount(feeAmount);
        detailsEntity.setBeforAmount(beforAmount);
        return detailsEntity;
    }

    public void createOrUpdateSaveDetail(TpmFeeBudgetEntity entity) {
        TpmFeeBudgetDetailsEntity detailsEntity = this.transformDetail(entity);
        this.detailsMapper.insert((Object)detailsEntity);
    }

    public void changeCheck(TpmFeeBudgetReqVo reqVo) {
        AssertUtils.isNotNull((Object)reqVo.getChangeAmount(), (String)"\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((reqVo.getChangeAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u53d8\u66f4\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        AssertUtils.isNotEmpty((String)reqVo.getFeeBudgetDetailType(), (String)"\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.ADDITIONAL.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType()) || org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.CUT_OUT.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType()) ? 1 : 0) != 0, (String)"\u8d39\u7528\u9884\u7b97\u53d8\u66f4\u53ea\u80fd\u9009\u62e9\u8ffd\u52a0\u6216\u8005\u524a\u51cf");
        TpmBudgetSubjectsEntity subjectsEntity = (TpmBudgetSubjectsEntity)((Object)this.budgetSubjectsMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)reqVo.getBudgetSubjectsCode())));
        reqVo.setBudgetSubjectsControlType(subjectsEntity.getControlType());
    }

    public String createFeeBudget(OperateBudgetControlReqVo reqVo) {
        TpmFeeBudgetEntity entity = reqVo.getEntity();
        TpmFeeBudgetReqVo budgetReqVo = reqVo.getReqVo();
        TpmFeeBudgetControlEntity newControl = this.saveNewControl(entity);
        return newControl.getId();
    }

    public String replaceFeeBudgetCodes(String originCodes, String replaceCode) {
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)replaceCode, (CharSequence)originCodes)) {
            return null;
        }
        if (originCodes.endsWith(replaceCode)) {
            return originCodes.replaceAll(replaceCode, "");
        }
        return originCodes.replaceAll(replaceCode + ",", "");
    }

    public TpmFeeBudgetControlEntity saveNewControl(TpmFeeBudgetEntity entity) {
        TpmFeeBudgetControlEntity newControl = new TpmFeeBudgetControlEntity();
        CrmBeanUtil.copyProperties((Object)((Object)entity), (Object)((Object)newControl));
        newControl.setFeeBudgetCodes(entity.getFeeBudgetCode());
        String selectKey = entity.getBudgetYear() + entity.getBudgetQuater() + entity.getBudgetMonth();
        newControl.setCanUseAmount(entity.getCanUseAmount());
        newControl.setSelectKey(selectKey);
        super.setPublicParamsNull((CrmBaseEntity)newControl);
        this.controlMapper.insert((Object)newControl);
        return newControl;
    }

    public void updateControl(TpmFeeBudgetControlEntity controlEntity, BigDecimal oldAmount, BigDecimal newAmount) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)controlEntity.getFeeBudgetCodes())) {
            this.controlMapper.deleteById((Serializable)((Object)controlEntity.getId()));
        } else {
            controlEntity.setCanUseAmount(Optional.ofNullable(controlEntity.getCanUseAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(newAmount).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(oldAmount).orElse(BigDecimal.ZERO)));
            this.controlMapper.updateById((Object)controlEntity);
        }
    }

    public String saveFeeBudgetControlData(OperateBudgetControlReqVo reqVo) {
        String controlId;
        switch (reqVo.getTypeEnum()) {
            case NEW: {
                controlId = this.createFeeBudget(reqVo);
                break;
            }
            default: {
                throw new BusinessException("\u5c1a\u672a\u5b9a\u4e49\u7684\u8d39\u7528\u7ef4\u5ea6\u64cd\u4f5c\u7c7b\u578b");
            }
        }
        return controlId;
    }

    public String getSelectKey(TpmFeeBudgetReqVo reqVo) {
        String controlType = reqVo.getBudgetSubjectsControlType();
        StringBuffer selectKey = new StringBuffer();
        selectKey.append(reqVo.getBudgetYear());
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.YEAR.getCode(), (CharSequence)controlType)) {
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.QUATER.getCode(), (CharSequence)controlType)) {
                selectKey.append("-").append(reqVo.getBudgetQuater());
            } else {
                selectKey.append("-").append(reqVo.getBudgetQuater()).append("-").append(reqVo.getBudgetMonth());
            }
        }
        return selectKey.toString();
    }

    public Map<String, Object> convertDataToMap(Set<String> feeBudgetControls, Object obj) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)obj));
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(feeBudgetControls)) {
            feeBudgetControls.stream().forEach(o -> {
                String s = StringUtils.camelCaseName((String)o);
                Object x = jsonObject.get((Object)s);
                if (Objects.isNull(x)) {
                    map.put(o, null);
                } else {
                    map.put(o, x);
                }
            });
        }
        return map;
    }

    public TpmFeeBudgetControlEntity findFeeBudgetControlByParams(Map<String, Object> map) {
        QueryWrapper wrapper = new QueryWrapper();
        AssertUtils.isTrue((boolean)MapUtils.isNotEmpty(map), (String)"\u67e5\u8be2\u8d39\u7528\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (String s : map.keySet()) {
            Object o = map.get(s);
            if (Objects.isNull(o)) {
                wrapper.isNull((Object)s);
                continue;
            }
            wrapper.eq((Object)s, o);
        }
        List entities = this.controlMapper.selectList((Wrapper)wrapper);
        AssertUtils.isTrue((CollectionUtils.size((Object)entities) <= 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u63a7\u5236\u7ef4\u5ea6\u7684\u6570\u636e\u5b58\u5728\u591a\u6761,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return CollectionUtils.isEmpty((Collection)entities) ? null : (TpmFeeBudgetControlEntity)((Object)entities.get(0));
    }

    public Set<String> getFeeBudgetControls(String feeBudgetType, String controlType) {
        List childrenList = DictUtil.getChildrenList((String)"fee_budget_type", (String)feeBudgetType);
        AssertUtils.isNotEmpty((Collection)childrenList, (String)"\u5f53\u524d\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u672a\u914d\u7f6e\u63a7\u5236\u7ef4\u5ea6");
        HashSet set = Sets.newHashSet();
        childrenList.forEach(o -> {
            Map extendMap = o.getExtendMap();
            AssertUtils.isNotEmpty((Map)extendMap, (String)"\u5f53\u524d\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u63a7\u5236\u7ef4\u5ea6\u672a\u8bbe\u7f6e\u5c5e\u6027\u5b57\u6bb5");
            String s = (String)Lists.newArrayList(extendMap.values()).get(0);
            AssertUtils.isTrue((!set.contains(s) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u63a7\u5236\u7ef4\u5ea6\u8bbe\u7f6e\u7684\u5c5e\u6027\u503c\u91cd\u590d");
            set.add(s);
        });
        return set;
    }

    public String getUniqueKey(FeeBudgetImportVo o) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(o.getBudgetYear()).append(o.getBudgetMonth()).append(o.getProjectNumber()).append(o.getBudgetSubjectsCode()).append(o.getOrgCode());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)o.getProductLevelCode())) {
            buffer.append(o.getProductLevelCode());
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)o.getProductCode())) {
            buffer.append(o.getProductCode());
        }
        return buffer.toString();
    }
}

