/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.tenantrydirectaccount;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectaccount.KmsTenantryDirectAccountImportVo;
import com.biz.crm.kms.config.KmsConfig;
import com.biz.crm.kms.tenantrydirectaccount.entity.KmsTenantryDirectAccountEntity;
import com.biz.crm.kms.tenantrydirectaccount.mapper.KmsTenantryDirectAccountMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.util.AesEncoder;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTenantryDirectAccountValidator")
public class KmsTenantryDirectAccountValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTenantryDirectAccountMapper, KmsTenantryDirectAccountEntity, KmsTenantryDirectAccountImportVo>
implements ExcelImportValidator<KmsTenantryDirectAccountImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectAccountValidator.class);
    @Resource
    private KmsTenantryDirectAccountMapper accountMapper;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper customerOrgMapper;
    @Resource
    private KmsConfig kmsConfig;
    private static final Integer MAX_PASS_LENGTH = 32;

    @Override
    public void validate(List<KmsTenantryDirectAccountImportVo> data, DefaultImportContext context) {
        ConcurrentHashMap map = ThreadLocalUtil.get();
        map.put("functionCode", "kms_customer_account_table");
        map.put("menuCode", "CRM20210414000001467");
        ThreadLocalUtil.setUser((UserRedis)UserUtils.getUser());
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet deduplicationLoginAcc = Sets.newHashSet();
        HashSet deduplicationCode = Sets.newHashSet();
        HashMap dataMap = Maps.newHashMap();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getLoginAcc())) {
                x.appendErrorValidateMsg("\u3010\u8d26\u53f7\u6ca1\u6709\u586b\u5199\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getLoginPass())) {
                x.appendErrorValidateMsg("\u3010\u767b\u5f55\u5bc6\u7801\u6ca1\u6709\u586b\u5199\u3011\u3001");
            } else {
                x.setLoginPass(new AesEncoder(this.kmsConfig.getEncryptAesKey()).encode((CharSequence)x.getLoginPass()));
            }
            if (deduplicationLoginAcc.contains(x.getLoginAcc())) {
                x.appendErrorValidateMsg("\u3010\u767b\u5f55\u8d26\u53f7\u91cd\u590d\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u76f8\u5173\u4fe1\u606f\u672a\u586b\u5199\u3011\u3001");
            }
            deduplicationCode.add(x.getBsDirectSystemCode());
            dataMap.put(x.getLoginAcc(), x.getBsDirectSystemCode());
            deduplicationLoginAcc.add(x.getLoginAcc());
        });
        if (CollectionUtils.isEmpty((Collection)deduplicationCode)) {
            return;
        }
        List customerOrgEntities = this.customerOrgMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, (Collection)deduplicationCode)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getCreateOrgCode, (Object)UserUtils.getUser().getOrgcode()));
        if (CollectionUtils.isEmpty((Collection)customerOrgEntities)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u3010" + x.getBsDirectSystemCode() + "\u3011\u884c\u7684\u76f4\u8425\u4f53\u7cfb\u4e0d\u5728\u7ef4\u62a4\u4e2d"));
            return;
        }
        if (CollectionUtils.isEmpty((Collection)deduplicationLoginAcc)) {
            return;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getCreateOrgCode, (Object)UserUtils.getUser().getOrgcode());
        List entityList = this.accountMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            Map customerOrgEntityMap = customerOrgEntities.stream().collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
            Set loginAccByDb = entityList.stream().map(KmsTenantryDirectAccountEntity::getLoginAcc).collect(Collectors.toSet());
            data.forEach(x -> {
                if (loginAccByDb.contains(x.getLoginAcc())) {
                    x.appendErrorValidateMsg("\u3010" + x.getLoginAcc() + "\u3011\u7684\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
                }
                if (customerOrgEntityMap.containsKey(x.getBsDirectSystemCode())) {
                    x.setBsDirectSystemId(((KmsTenantryDirectCustomerOrgEntity)((Object)((Object)customerOrgEntityMap.get(x.getBsDirectSystemCode())))).getBsDirectSystemId());
                    x.setBsDirectSystemName(((KmsTenantryDirectCustomerOrgEntity)((Object)((Object)customerOrgEntityMap.get(x.getBsDirectSystemCode())))).getBsDirectSystemName());
                } else {
                    x.appendErrorValidateMsg("\u3010" + x.getBsDirectSystemCode() + "\u3011\u7684\u76f4\u8425\u4f53\u7cfb\u4e0d\u5728\u7ef4\u62a4\u4e2d");
                }
            });
        }
    }
}

