/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.bpmrole;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.bpmrole.MdmBpmRoleImportVo;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmBpmRoleImportValidator")
public class MdmBpmRoleImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmBpmRoleMapper, MdmBpmRoleEntity, MdmBpmRoleImportVo>
implements ExcelImportValidator<MdmBpmRoleImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmBpmRoleImportValidator.class);
    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;

    @Override
    public void validate(List<MdmBpmRoleImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validateRequired(data);
    }

    protected void validateRequired(List<MdmBpmRoleImportVo> originList) {
        HashSet roleCodeSet = new HashSet(16);
        Set paramBpmRoleCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getBpmRoleCode())).map(MdmBpmRoleImportVo::getBpmRoleCode).collect(Collectors.toSet());
        if (!paramBpmRoleCodeSet.isEmpty()) {
            QueryWrapper codeQueryWrapper = new QueryWrapper();
            codeQueryWrapper.in((Object)"bpm_role_code", paramBpmRoleCodeSet);
            List paramBpmRoleCodeEntityList = this.mdmBpmRoleMapper.selectList((Wrapper)codeQueryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)paramBpmRoleCodeEntityList)) {
                roleCodeSet.addAll(paramBpmRoleCodeEntityList.stream().map(MdmBpmRoleEntity::getBpmRoleCode).collect(Collectors.toSet()));
            }
        }
        HashSet roleNameSet = new HashSet(16);
        Set paramNameCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getBpmRoleName())).map(MdmBpmRoleImportVo::getBpmRoleName).collect(Collectors.toSet());
        if (!paramNameCodeSet.isEmpty()) {
            QueryWrapper nameQueryWrapper = new QueryWrapper();
            nameQueryWrapper.in((Object)"bpm_role_name", paramNameCodeSet);
            List paramBpmRoleNameEntityList = this.mdmBpmRoleMapper.selectList((Wrapper)nameQueryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)paramBpmRoleNameEntityList)) {
                roleNameSet.addAll(paramBpmRoleNameEntityList.stream().map(MdmBpmRoleEntity::getBpmRoleName).collect(Collectors.toSet()));
            }
        }
        HashMap<String, Integer> codeIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> nameIndexMap = new HashMap<String, Integer>(16);
        for (MdmBpmRoleImportVo item2 : originList) {
            if (StringUtils.isNotEmpty((String)item2.getBpmRoleCode())) {
                if (roleCodeSet.contains(item2.getBpmRoleCode())) {
                    item2.appendErrorValidateMsg("\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff1b");
                } else if (codeIndexMap.containsKey(item2.getBpmRoleCode())) {
                    item2.appendErrorValidateMsg("\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u4e0e\u7b2c[" + codeIndexMap.get(item2.getBpmRoleCode()) + "]\u884c\u91cd\u590d\uff1b");
                } else {
                    codeIndexMap.put(item2.getBpmRoleCode(), item2.getRowIndex());
                }
            }
            if (StringUtils.isEmpty((String)item2.getBpmRoleName())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u540d\u79f0\uff1b");
                continue;
            }
            if (roleNameSet.contains(item2.getBpmRoleName())) {
                item2.appendErrorValidateMsg("\u6d41\u7a0b\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff1b");
                continue;
            }
            if (nameIndexMap.containsKey(item2.getBpmRoleName())) {
                item2.appendErrorValidateMsg("\u6d41\u7a0b\u89d2\u8272\u540d\u79f0\u4e0e\u7b2c[" + nameIndexMap.get(item2.getBpmRoleName()) + "]\u884c\u91cd\u590d\uff1b");
                continue;
            }
            nameIndexMap.put(item2.getBpmRoleName(), item2.getRowIndex());
        }
    }
}

