/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.user;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmCustomerUserImportVo;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.entity.MdmUserRelCustomerEntity;
import com.biz.crm.mdm.user.entity.MdmUserRelRoleEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.mdm.user.mapper.MdmUserRelCustomerMapper;
import com.biz.crm.mdm.user.mapper.MdmUserRelRoleMapper;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="mdmCustomerUserImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmCustomerUserImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmUserMapper, MdmUserEntity, MdmCustomerUserImportVo>
implements ExcelImportSaver<MdmCustomerUserImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerUserImportSaver.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmUserRelCustomerMapper mdmUserRelCustomerMapper;
    @Resource
    private MdmUserRelRoleMapper mdmUserRelRoleMapper;

    @Override
    public void save(List<MdmCustomerUserImportVo> data, DefaultImportContext context) {
        log.info("\u5bfc\u5165\u7528\u6237");
        if (data == null || data.size() == 0) {
            return;
        }
        ArrayList<MdmUserEntity> userEntityList = new ArrayList<MdmUserEntity>();
        ArrayList<MdmUserRelCustomerEntity> userRelCustomerEntityList = new ArrayList<MdmUserRelCustomerEntity>();
        ArrayList<MdmUserRelRoleEntity> userRelRoleEntityList = new ArrayList<MdmUserRelRoleEntity>();
        for (MdmCustomerUserImportVo item : data) {
            if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) continue;
            MdmUserEntity copy = (MdmUserEntity)((Object)CrmBeanUtil.copy((Object)((Object)item), MdmUserEntity.class));
            copy.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)item.getUserPassword()));
            copy.setUserType(UserTypeEnum.CUSTOMER.getCode());
            copy.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
            copy.setStartTime(item.getStartTime() + " 00:00:00");
            copy.setEndTime(item.getEndTime() + " 23:59:59");
            copy.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
            userEntityList.add(copy);
            if (StringUtils.isNotEmpty((String)item.getRoleCode())) {
                for (String roleCode : item.getRoleCode().split(",")) {
                    MdmUserRelRoleEntity userRelRole = new MdmUserRelRoleEntity();
                    userRelRole.setUserName(item.getUserName());
                    userRelRole.setRoleCode(roleCode);
                    userRelRoleEntityList.add(userRelRole);
                }
            }
            if (!StringUtils.isNotEmpty((String)item.getCustomerCode())) continue;
            for (String customerCode : item.getCustomerCode().split(",")) {
                MdmUserRelCustomerEntity userRelCustomer = new MdmUserRelCustomerEntity();
                userRelCustomer.setUserName(item.getUserName());
                userRelCustomer.setCustomerCode(customerCode);
                userRelCustomer.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                userRelCustomerEntityList.add(userRelCustomer);
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(userEntityList)) {
            List userGroup = Lists.partition(userEntityList, (int)50);
            for (List item : userGroup) {
                this.saveBatch(item);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(userRelCustomerEntityList)) {
                userRelCustomerEntityList.forEach(x -> this.mdmUserRelCustomerMapper.insert(x));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(userRelRoleEntityList)) {
                userRelRoleEntityList.forEach(x -> this.mdmUserRelRoleMapper.insert(x));
            }
        }
    }
}

