/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.user;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmUserImportVo;
import com.biz.crm.mdm.position.entity.MdmPositionBpmRoleEntity;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.entity.MdmPositionRoleEntity;
import com.biz.crm.mdm.position.entity.MdmPositionUserEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionBpmRoleMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionRoleMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionUserMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.constant.PositionOperationEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionBpmRoleRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component(value="mdmUserImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmUserImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmUserMapper, MdmUserEntity, MdmUserImportVo>
implements ExcelImportSaver<MdmUserImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmUserImportSaver.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmPositionUserMapper mdmPositionUserMapper;
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmPositionRoleMapper mdmPositionRoleMapper;
    @Resource
    private MdmPositionBpmRoleMapper mdmPositionBpmRoleMapper;
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Autowired
    private WebsocketUtil websocketUtil;
    @Resource
    private RocketMQProducer rocketMQProducer;

    @Override
    public void save(List<MdmUserImportVo> data, DefaultImportContext context) {
        log.info("\u5bfc\u5165\u7528\u6237");
        if (data == null || data.size() == 0) {
            return;
        }
        String sid = context.getImportParamVo().getWebSocketClientId();
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u51c6\u5907\u4fdd\u5b58\u6570\u636e");
        List collect = data.stream().filter(x -> AbstractImportVo.ProcessTypeEnum.SUCCESS == x.getProcessType()).collect(Collectors.toList());
        int userSize = collect.size();
        if (userSize == 0) {
            return;
        }
        List userCodeList = CodeUtil.generateCodeList((String)CodeRuleEnum.MDM_USER_CODE.getCode(), (int)userSize);
        for (int i = 0; i < userSize; ++i) {
            ((MdmUserImportVo)((Object)collect.get(i))).setUserCode((String)userCodeList.get(i));
        }
        List<MdmUserImportVo> newPositionList = collect.stream().filter(x -> PositionOperationEnum.NEW.getCode().equals(x.getOperationType())).collect(Collectors.toList());
        if (newPositionList.size() > 0) {
            int newPositionSize = newPositionList.size();
            List positionCodeList = CodeUtil.generateCodeList((String)CodeRuleEnum.MDM_POSITION_CODE.getCode(), (int)newPositionSize);
            for (int i = 0; i < newPositionSize; ++i) {
                ((MdmUserImportVo)((Object)newPositionList.get(i))).setPrimaryPositionCode((String)positionCodeList.get(i));
            }
            this.generatePositionName(newPositionList);
        }
        Map<String, MdmUserImportVo> userNamePositionMap = collect.stream().collect(Collectors.toMap(MdmUserImportVo::getUserName, v -> v));
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u4e0a\u7ea7\u8d26\u53f7\u9884\u52a0\u8f7d\u6570\u636e");
        HashMap<String, MdmUserEntity> parentUserNameCheckMap = new HashMap<String, MdmUserEntity>(16);
        HashMap<String, MdmPositionEntity> parentUserNamePrimaryPositionMap = new HashMap<String, MdmPositionEntity>(16);
        Set paramParentUserNameSet = collect.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentUserName())).map(MdmUserImportVo::getParentUserName).collect(Collectors.toSet());
        if (!paramParentUserNameSet.isEmpty()) {
            ArrayList list = new ArrayList(paramParentUserNameSet);
            List lists = Lists.partition(list, (int)500);
            for (List item2 : lists) {
                QueryWrapper userNameQuery = new QueryWrapper();
                userNameQuery.in((Object)"user_name", (Collection)item2);
                userNameQuery.select(new String[]{"user_name", "user_type", "enable_status"});
                List userNameQueryEntityList = this.mdmUserMapper.selectList((Wrapper)userNameQuery);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)userNameQueryEntityList)) continue;
                parentUserNameCheckMap.putAll(userNameQueryEntityList.stream().collect(Collectors.toMap(MdmUserEntity::getUserName, v -> v)));
                QueryWrapper positionUserQuery = new QueryWrapper();
                positionUserQuery.eq((Object)"primary_flag", (Object)YesNoEnum.yesNoEnum.ONE.getValue());
                positionUserQuery.in((Object)"user_name", (Collection)userNameQueryEntityList.stream().map(MdmUserEntity::getUserName).collect(Collectors.toSet()));
                positionUserQuery.select(new String[]{"user_name", "position_code"});
                List positionUserEntityList = this.mdmPositionUserMapper.selectList((Wrapper)positionUserQuery);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)positionUserEntityList)) continue;
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"position_code", (Collection)positionUserEntityList.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toSet()));
                queryWrapper.select(new String[]{"position_code", "position_name", "org_code", "enable_status"});
                Map<String, MdmPositionEntity> parentPositionMap = this.mdmPositionMapper.selectList((Wrapper)queryWrapper).stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
                if (parentPositionMap.isEmpty()) continue;
                parentUserNamePrimaryPositionMap.putAll(positionUserEntityList.stream().filter(x -> parentPositionMap.containsKey(x.getPositionCode())).collect(Collectors.toMap(MdmPositionUserEntity::getUserName, v -> (MdmPositionEntity)((Object)((Object)parentPositionMap.get(v.getPositionCode()))))));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u4e0a\u7ea7\u8d26\u53f7\u9884\u52a0\u8f7d\u6570\u636e===>" + paramParentUserNameSet.size());
        ArrayList<MdmUserEntity> userEntityList = new ArrayList<MdmUserEntity>();
        ArrayList<String[]> positionEntityList = new ArrayList<String[]>();
        ArrayList<MdmPositionUserEntity> positionRelUserEntityList = new ArrayList<MdmPositionUserEntity>();
        ArrayList positionRelRoleEntityList = new ArrayList();
        ArrayList positionRelBpmRoleEntityList = new ArrayList();
        for (MdmUserImportVo item3 : collect) {
            MdmUserEntity copy = (MdmUserEntity)((Object)CrmBeanUtil.copy((Object)((Object)item3), MdmUserEntity.class));
            copy.setStartTime(item3.getStartTime() + " 00:00:00");
            copy.setEndTime(item3.getEndTime() + " 23:59:59");
            copy.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)item3.getUserPassword()));
            copy.setUserType(UserTypeEnum.USER.getCode());
            copy.setUserCode(item3.getUserCode());
            copy.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
            userEntityList.add(copy);
            MdmPositionUserEntity mdmPositionUserEntity = new MdmPositionUserEntity();
            mdmPositionUserEntity.setUserName(item3.getUserName());
            mdmPositionUserEntity.setCurrentFlag(YesNoEnum.yesNoEnum.ONE.getValue());
            mdmPositionUserEntity.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
            mdmPositionUserEntity.setPositionCode(item3.getPrimaryPositionCode());
            positionRelUserEntityList.add(mdmPositionUserEntity);
            if (PositionOperationEnum.NEW.getCode().equals(item3.getOperationType())) {
                String[] position = new MdmPositionEntity();
                position.setPositionCode(item3.getPrimaryPositionCode());
                position.setPositionName(item3.getPositionName());
                position.setPositionLevelCode(item3.getPositionLevelCode());
                position.setOrgCode(item3.getOrgCode());
                position.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                position.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                position.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                position.setLevelNum(Integer.valueOf(1));
                if (StringUtils.isNotEmpty((String)item3.getParentUserName())) {
                    if (parentUserNameCheckMap.containsKey(item3.getParentUserName())) {
                        position.setParentCode(((MdmPositionEntity)((Object)parentUserNamePrimaryPositionMap.get(item3.getParentUserName()))).getPositionCode());
                    } else {
                        MdmUserImportVo mdmUserImportVo = userNamePositionMap.get(item3.getParentUserName());
                        if (mdmUserImportVo != null) {
                            position.setParentCode(mdmUserImportVo.getPrimaryPositionCode());
                        }
                    }
                }
                if (StringUtils.isNotEmpty((String)item3.getRoleCode())) {
                    positionRelRoleEntityList.addAll(Arrays.stream(item3.getRoleCode().split(",")).map(x -> {
                        MdmPositionRoleEntity positionRoleEntity = new MdmPositionRoleEntity();
                        positionRoleEntity.setPositionCode(item3.getPrimaryPositionCode());
                        positionRoleEntity.setRoleCode((String)x);
                        return positionRoleEntity;
                    }).collect(Collectors.toList()));
                }
                if (StringUtils.isNotEmpty((String)item3.getBpmRoleCode())) {
                    positionRelBpmRoleEntityList.addAll(Arrays.stream(item3.getBpmRoleCode().split(",")).map(x -> {
                        MdmPositionBpmRoleEntity positionBpmRoleEntity = new MdmPositionBpmRoleEntity();
                        positionBpmRoleEntity.setPositionCode(item3.getPrimaryPositionCode());
                        positionBpmRoleEntity.setBpmRoleCode((String)x);
                        return positionBpmRoleEntity;
                    }).collect(Collectors.toList()));
                }
                positionEntityList.add(position);
                continue;
            }
            if (!StringUtils.isNotEmpty((String)item3.getOtherPositionCodes())) continue;
            for (String positionCode : item3.getOtherPositionCodes().split(",")) {
                MdmPositionUserEntity otherRel = new MdmPositionUserEntity();
                otherRel.setUserName(item3.getUserName());
                otherRel.setPositionCode(positionCode);
                otherRel.setPrimaryFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                otherRel.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                positionRelUserEntityList.add(otherRel);
            }
        }
        this.websocketUtil.sendMsg(sid, "\u6570\u636e\u51c6\u5907\u5b8c\u6210\u5373\u5c06==>\u4fdd\u5b58\u6570\u636e");
        if (CollectionUtil.listNotEmptyNotSizeZero(userEntityList)) {
            if (CollectionUtil.listNotEmptyNotSizeZero(positionRelUserEntityList)) {
                Set pos = positionRelUserEntityList.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toSet());
                ArrayList list = new ArrayList(pos);
                List lists = Lists.partition(list, (int)500);
                for (List item4 : lists) {
                    QueryWrapper positionRelUserDelete = new QueryWrapper();
                    positionRelUserDelete.in((Object)"position_code", (Collection)item4);
                    this.mdmPositionUserMapper.delete((Wrapper)positionRelUserDelete);
                }
            }
            List userGroup = Lists.partition(userEntityList, (int)200);
            int countSave = 1;
            for (List list : userGroup) {
                this.websocketUtil.sendMsg(sid, "\u6b63\u5728\u4fdd\u5b58\u7528\u6237\u6570\u636e\u8bf7\u7b49\u5f85==>" + countSave * 200);
                this.saveBatch(list);
            }
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u5f00\u59cb\u4fdd\u5b58\u804c\u4f4d");
            if (CollectionUtil.listNotEmptyNotSizeZero(positionEntityList)) {
                for (MdmPositionEntity mdmPositionEntity : positionEntityList) {
                    this.mdmPositionMapper.insert((Object)mdmPositionEntity);
                }
                this.sendPositionAdd(CrmBeanUtil.copyList(positionEntityList, MdmPositionRespVo.class));
            }
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u7ed3\u675f\u4fdd\u5b58\u804c\u4f4d===>" + positionEntityList.size());
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u5f00\u59cb\u4fdd\u5b58\u804c\u4f4d\u5173\u8054\u89d2\u8272");
            if (CollectionUtil.listNotEmptyNotSizeZero(positionRelRoleEntityList)) {
                for (MdmPositionRoleEntity mdmPositionRoleEntity : positionRelRoleEntityList) {
                    this.mdmPositionRoleMapper.insert((Object)mdmPositionRoleEntity);
                }
            }
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u7ed3\u675f\u4fdd\u5b58\u804c\u4f4d\u5173\u8054\u89d2\u8272===>" + positionRelRoleEntityList.size());
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u5f00\u59cb\u4fdd\u5b58\u804c\u4f4d\u5173\u8054\u6d41\u7a0b\u89d2\u8272");
            if (CollectionUtil.listNotEmptyNotSizeZero(positionRelBpmRoleEntityList)) {
                for (MdmPositionBpmRoleEntity mdmPositionBpmRoleEntity : positionRelBpmRoleEntityList) {
                    this.mdmPositionBpmRoleMapper.insert((Object)mdmPositionBpmRoleEntity);
                }
                this.sendPositionRelBpmRoleAdd(CrmBeanUtil.copyList(positionRelBpmRoleEntityList, MdmPositionBpmRoleRespVo.class));
            }
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u7ed3\u675f\u4fdd\u5b58\u804c\u4f4d\u5173\u8054\u6d41\u7a0b\u89d2\u8272===>" + positionRelBpmRoleEntityList.size());
            this.websocketUtil.sendMsg(sid, "\u6b63\u5728\u4fdd\u5b58\u804c\u4f4d\u4e0e\u7528\u6237\u5173\u7cfb\u6570\u636e\u8bf7\u7b49\u5f85");
            for (MdmPositionUserEntity mdmPositionUserEntity : positionRelUserEntityList) {
                this.mdmPositionUserMapper.insert((Object)mdmPositionUserEntity);
            }
            this.websocketUtil.sendMsg(sid, "\u4fdd\u5b58\u804c\u4f4d\u4e0e\u7528\u6237\u5173\u7cfb\u6570\u636e\u7ed3\u675f==>\u5bfc\u5165\u5373\u5c06\u7ed3\u675f");
            PositionUtil.deleteAllCache();
            this.resetRuleCode(sid);
        }
    }

    public void generatePositionName(List<MdmUserImportVo> collect) {
        List emptyPositionNameList;
        if (collect != null && collect.size() > 0 && !(emptyPositionNameList = collect.stream().filter(x -> StringUtils.isEmpty((String)x.getPositionName())).collect(Collectors.toList())).isEmpty()) {
            Set<String> existNameSet = collect.stream().filter(x -> StringUtils.isNotEmpty((String)x.getPositionName())).map(MdmUserImportVo::getPositionName).collect(Collectors.toSet());
            Map<String, List<MdmUserImportVo>> groupByPositionLevelCode = emptyPositionNameList.stream().collect(Collectors.groupingBy(MdmUserImportVo::getPositionLevelCode));
            for (Map.Entry<String, List<MdmUserImportVo>> entry : groupByPositionLevelCode.entrySet()) {
                this.generatePositionNameGroupByPositionLevel(entry.getKey(), entry.getValue(), existNameSet);
            }
        }
    }

    public void generatePositionNameGroupByPositionLevel(String positionLevelCode, List<MdmUserImportVo> collect, Set<String> generateNameSet) {
        Assert.hasText((String)positionLevelCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"position_level_code", (Object)positionLevelCode);
        MdmPositionLevelEntity positionLevel = (MdmPositionLevelEntity)((Object)this.mdmPositionLevelMapper.selectOne((Wrapper)wrapper));
        Assert.notNull((Object)((Object)positionLevel), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7ea7\u522b");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(positionLevel.getEnableStatus()), (String)"\u8be5\u804c\u4f4d\u7ea7\u522b\u5df2\u505c\u7528");
        Integer suffixSequence = positionLevel.getSuffixSequence();
        if (suffixSequence == null) {
            suffixSequence = 0;
        }
        HashSet positionNameSet = new HashSet(16);
        QueryWrapper positionQuery = new QueryWrapper();
        positionQuery.like((Object)"position_name", (Object)positionLevel.getPositionLevelName());
        positionQuery.select(new String[]{"position_name"});
        List positionList = this.mdmPositionMapper.selectList((Wrapper)positionQuery);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionList)) {
            positionNameSet.addAll(positionList.stream().map(MdmPositionEntity::getPositionName).collect(Collectors.toSet()));
        }
        for (MdmUserImportVo item : collect) {
            suffixSequence = suffixSequence + 1;
            String positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
            while (positionNameSet.contains(positionName) || generateNameSet.contains(positionName)) {
                suffixSequence = suffixSequence + 1;
                positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
            }
            item.setPositionName(positionName);
            generateNameSet.add(positionName);
        }
        positionLevel.setSuffixSequence(suffixSequence);
        this.mdmPositionLevelMapper.updateById((Object)positionLevel);
    }

    private void resetRuleCode(String sid) {
        long l = System.currentTimeMillis();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u5f00\u59cb-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u5f00\u59cb");
        this.mdmPositionMapper.copyIdToRuleCode();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f");
        this.mdmPositionMapper.setNullNotExistParentCode();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        wrapper.and(x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"parent_code", (Object)"")).or()).isNull((Object)"parent_code");
        });
        List list = this.mdmPositionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getPositionCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
            }
        }
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f16\u7801\u91cd\u65b0\u751f\u6210\u6210\u529f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u7f16\u7801\u91cd\u65b0\u751f\u6210\u6210\u529f");
        PositionUtil.deleteAllCache();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f13\u5b58\u6e05\u9664\u6210\u529f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u7f13\u5b58\u6e05\u9664\u6210\u529f");
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7ed3\u675f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u7ed3\u675f");
    }

    private void updateCurAndChildren(String positionCode, String curCode, int levelNum) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum);
        this.mdmPositionMapper.update(null, (Wrapper)updateWrapper);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(MdmPositionEntity::getParentCode, (Object)positionCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode});
        List list = this.mdmPositionMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getPositionCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }

    protected void sendPositionAdd(List<MdmPositionRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("POSITION_ADD_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }

    protected void sendPositionRelBpmRoleAdd(List<MdmPositionBpmRoleRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u5173\u8054\u6d41\u7a0b\u89d2\u8272\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("POSITION_REL_BPM_ROLE_ADD_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u5173\u8054\u6d41\u7a0b\u89d2\u8272\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }
}

