/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.dms.order;

import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.mdm.availablelist.AvailableListFeign;
import com.biz.crm.nebular.dms.order.OrderUpdateImportVo;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.util.CollectionUtil;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;

@Component(value="orderUpdateValidator")
public class OrderUpdateValidator
implements ExcelImportValidator<OrderUpdateImportVo> {
    private static final String NUMBER_REGEX = "[+-]?\\d+(\\.\\d+)?";
    @Resource
    private AvailableListFeign availableListFeign;

    @Override
    public void validate(List<OrderUpdateImportVo> data, DefaultImportContext context) {
        data.forEach(li -> {
            this.validate(li.getCusCode(), (OrderUpdateImportVo)li, "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validate(li.getCusName(), (OrderUpdateImportVo)li, "\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            this.validate(li.getOrderCode(), (OrderUpdateImportVo)li, "\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validate(li.getDetailId(), (OrderUpdateImportVo)li, "\u8ba2\u5355\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
            li.setOrderTypeCode(this.getOrderTypeCodeByName(li.getOrderTypeName()));
            this.validate(li.getProductCode(), (OrderUpdateImportVo)li, "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validate(li.getCount(), (OrderUpdateImportVo)li, "\u8d2d\u4e70\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            this.validate(li.getProductType(), (OrderUpdateImportVo)li, "\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateProductType(li.getProductType(), (OrderUpdateImportVo)li, "\u5546\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e");
            this.validatePattern(li.getCount(), (OrderUpdateImportVo)li, NUMBER_REGEX, "\u8d2d\u4e70\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
        });
        Map<String, List<OrderUpdateImportVo>> orderMap = data.stream().collect(Collectors.groupingBy(OrderUpdateImportVo::getOrderCode));
        orderMap.forEach((k, v) -> {
            Set<String> productCodes = v.stream().collect(Collectors.groupingBy(OrderUpdateImportVo::getProductCode)).keySet();
            this.validateAndSetPrice((List<OrderUpdateImportVo>)v, (String)k, productCodes);
        });
    }

    private void validateProductType(String productType, OrderUpdateImportVo li, String msg) {
        if (OrderEunm.LineTypeEnum.getByCode((String)productType) == null) {
            li.appendErrorValidateMsg(msg);
        }
    }

    private void validateAndSetPrice(List<OrderUpdateImportVo> orderList, String cusCode, Set<String> productCodes) {
        Map result = (Map)this.availableListFeign.findGoodsByCusAndGoodsCodes((List)Lists.newArrayList(productCodes), cusCode).getResult();
        if (!CollectionUtil.mapNotEmpty((Map)result)) {
            result = Maps.newHashMap();
        }
        for (OrderUpdateImportVo order : orderList) {
            if (Objects.isNull(result.get(order.getProductCode()))) {
                order.appendErrorValidateMsg("\u5ba2\u6237".concat(order.getCusCode()).concat("-\u5546\u54c1").concat(order.getProductCode()).concat("\u4e0d\u53ef\u8d2d\uff0c\u8bf7\u5148\u7ef4\u62a4\u53ef\u8d2d\u6e05\u5355"));
                continue;
            }
            if (((CusAvailablelistVo)result.get(order.getProductCode())).getPrice() == null) {
                order.appendErrorValidateMsg("\u5ba2\u6237".concat(order.getCusCode()).concat("-\u5546\u54c1").concat(order.getProductCode()).concat("\u4ef7\u683c\u4e0d\u53ef\u7528\uff0c\u8bf7\u5148\u7ef4\u62a4\u4ef7\u683c"));
                continue;
            }
            order.setPrice(((CusAvailablelistVo)result.get(order.getProductCode())).getPrice());
            order.setAmount(new BigDecimal(order.getCount()).multiply(order.getPrice()));
        }
    }

    private String getOrderTypeCodeByName(String name) {
        OrderEunm.TYPE[] types;
        for (OrderEunm.TYPE type : types = OrderEunm.TYPE.values()) {
            if (!Objects.equals(type.getValue(), name)) continue;
            return type.getCode();
        }
        return null;
    }

    private void validatePattern(String value, OrderUpdateImportVo li, String regex, String msg) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            li.appendErrorValidateMsg(msg);
        }
    }

    private void validate(Object value, OrderUpdateImportVo li, String msg) {
        if (Objects.isNull(value) || Objects.equals("", value)) {
            li.appendErrorValidateMsg(msg);
        }
    }
}

