/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.terminal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalContactImportVo;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmTerminalContactImportValidator")
public class MdmTerminalContactImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmTerminalMapper, MdmTerminalEntity, MdmTerminalContactImportVo>
implements ExcelImportValidator<MdmTerminalContactImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalContactImportValidator.class);
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;

    @Override
    public void validate(List<MdmTerminalContactImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validTerminalCode(data);
        this.initialsEmptyContactMain(data);
    }

    protected void initialsEmptyContactMain(List<MdmTerminalContactImportVo> data) {
        for (MdmTerminalContactImportVo mdmTerminalContactImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmTerminalContactImportVo.getContactMain())) continue;
            mdmTerminalContactImportVo.setContactMain(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
    }

    protected void validTerminalCode(List<MdmTerminalContactImportVo> data) {
        List dbTerminalCodeList;
        for (MdmTerminalContactImportVo mdmTerminalContactImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmTerminalContactImportVo.getTerminalCode())) continue;
            mdmTerminalContactImportVo.appendErrorValidateMsg("\u884c\u53f7\uff1a" + mdmTerminalContactImportVo.getRowIndex() + "\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        List mdmTerminalEntities = this.mdmTerminalMapper.selectList((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{MdmTerminalEntity::getTerminalCode}));
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalEntities) && !CollectionUtils.isEmpty(dbTerminalCodeList = mdmTerminalEntities.stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getTerminalCode())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()))) {
            for (MdmTerminalContactImportVo mdmTerminalContactImportVo : data) {
                if (dbTerminalCodeList.contains(mdmTerminalContactImportVo.getTerminalCode())) continue;
                mdmTerminalContactImportVo.appendErrorValidateMsg("\u884c\u53f7\uff1a" + mdmTerminalContactImportVo.getRowIndex() + "\u7ec8\u7aef\u7f16\u7801\u4e0d\u5b58\u5728;");
            }
        }
    }
}

