/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.materialGroup;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.materialGroup.MdmMaterialGroupImportVo;
import com.biz.crm.mdm.materialGroup.entity.MdmMaterialGroupEntity;
import com.biz.crm.mdm.materialGroup.entity.MdmMaterialGroupRelEntity;
import com.biz.crm.mdm.materialGroup.mapper.MdmMaterialGroupMapper;
import com.biz.crm.mdm.materialGroup.mapper.MdmMaterialGroupRelMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmMaterialGroupImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmMaterialGroupImportSaver<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmMaterialGroupMapper, MdmMaterialGroupEntity>
implements ExcelImportSaver<MdmMaterialGroupImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmMaterialGroupImportSaver.class);
    @Resource
    private MdmMaterialGroupRelMapper mdmMaterialGroupRelMapper;

    @Override
    public void save(List<MdmMaterialGroupImportVo> data, DefaultImportContext context) {
        log.info("\u7269\u6599\u7ec4\u5bfc\u5165:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            List materials = Lists.partition(data, (int)50);
            for (List material : materials) {
                material.forEach(item -> {
                    String materialCode = item.getMaterialCode();
                    List<String> materialCodeList = Arrays.asList(materialCode.split(","));
                    MdmMaterialGroupEntity groupEntity = (MdmMaterialGroupEntity)((Object)((Object)CrmBeanUtil.copy((Object)item, MdmMaterialGroupEntity.class)));
                    groupEntity.setMaterialNum(materialCodeList == null ? 0 : materialCodeList.size());
                    this.save((Object)groupEntity);
                    materialCodeList.forEach(itemMaterial -> {
                        MdmMaterialGroupRelEntity relEntity = new MdmMaterialGroupRelEntity();
                        relEntity.setMaterialCode((String)itemMaterial);
                        relEntity.setMaterialGroupCode(item.getMaterialGroupCode());
                        this.mdmMaterialGroupRelMapper.insert((Object)relEntity);
                    });
                });
            }
        }
    }
}

