/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.tenantrydirectstore;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectstore.KmsTenantryDirectStoreImportVo;
import com.biz.crm.kms.confadmin.entity.KmsDirectStoreAreaEntity;
import com.biz.crm.kms.confadmin.entity.KmsDirectStoreEntity;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreAreaMapper;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.kms.tenantrydirectstore.entity.KmsTenantryDirectStoreEntity;
import com.biz.crm.kms.tenantrydirectstore.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTenantryDirectStoreValidator")
public class KmsTenantryDirectStoreValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTenantryDirectStoreMapper, KmsTenantryDirectStoreEntity, KmsTenantryDirectStoreImportVo>
implements ExcelImportValidator<KmsTenantryDirectStoreImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectStoreValidator.class);
    private Set<String> bsSystemIdsForExist = Sets.newHashSet();
    private Set<String> terminalCodesForExist = Sets.newHashSet();
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private KmsDirectStoreAreaMapper kmsDirectStoreAreaMapper;
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;

    @Override
    public void validate(List<KmsTenantryDirectStoreImportVo> data, DefaultImportContext context) {
        ConcurrentHashMap map = ThreadLocalUtil.get();
        map.put("functionCode", "kms_direct_stores_table");
        map.put("menuCode", "CRM20210419000001471");
        ThreadLocalUtil.setUser((UserRedis)UserUtils.getUser());
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        ArrayList needRemoveData = Lists.newArrayList();
        HashSet deduplicationTerminalCode = Sets.newHashSet();
        HashSet deduplicationDirectCode = Sets.newHashSet();
        HashSet deduplicationStrings = Sets.newHashSet();
        HashMap areaMap = Maps.newHashMap();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u672a\u586b\u5199\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getStoreCode())) {
                x.appendErrorValidateMsg("\u3010\u5173\u8054\u5ba2\u6237\u95e8\u5e97\u7f16\u7801\u672a\u586b\u5199\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getTerminalCode())) {
                x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u95e8\u5e97\u7f16\u7801\u672a\u586b\u5199\u3011\u3001");
            }
            if (x.getTimeOfDay() == null) {
                x.setTimeOfDay(0);
            }
            if (StringUtils.isNotBlank((CharSequence)x.getStoreCode()) && StringUtils.isNotBlank((CharSequence)x.getTerminalCode()) && StringUtils.isNotBlank((CharSequence)x.getBsDirectSystemCode())) {
                if (deduplicationStrings.contains(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode() + x.getAreaCode())) {
                    x.appendErrorValidateMsg("\u3010\u91cd\u590d\u7684excel\u884c\u6570\u636e\u3011\u3001");
                }
                deduplicationStrings.add(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode() + x.getAreaCode());
                deduplicationDirectCode.add(x.getBsDirectSystemCode());
                deduplicationTerminalCode.add(x.getTerminalCode());
            }
        });
        if (CollectionUtils.isEmpty((Collection)deduplicationStrings)) {
            return;
        }
        this.checkDirectCusOrgAndTerminal(data, deduplicationTerminalCode, deduplicationDirectCode);
        this.checkDuplicationByDb(deduplicationStrings, data);
    }

    private void checkDuplicationByDb(Set<String> deduplicationStrings, List<KmsTenantryDirectStoreImportVo> data) {
        KmsTenantryDirectStoreReqVo storeReqVo = new KmsTenantryDirectStoreReqVo();
        storeReqVo.setBsDirectSystemIdList((List)Lists.newArrayList(this.bsSystemIdsForExist));
        storeReqVo.setTerminalCodes((List)Lists.newArrayList(this.terminalCodesForExist));
        storeReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectStoreEntity> entities = this.kmsTenantryDirectStoreMapper.selectListByCompetence(storeReqVo);
        HashSet duplicationStringsByDb = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getBsDirectSystemId()) && StringUtils.isNotBlank((CharSequence)x.getStoreId()) && StringUtils.isNotBlank((CharSequence)x.getTerminalCode())) {
                    duplicationStringsByDb.add(x.getBsDirectSystemId() + x.getStoreId() + x.getTerminalCode());
                }
            });
            data.forEach(x -> {
                if (duplicationStringsByDb.contains(x.getBsDirectSystemId() + x.getStoreId() + x.getTerminalCode())) {
                    x.appendErrorValidateMsg("\u8be5\u6570\u636e\u5df2\u5b58\u5728");
                }
            });
        }
    }

    private void checkDirectCusOrgAndTerminal(List<KmsTenantryDirectStoreImportVo> data, Set<String> deduplicationTerminalCode, Set<String> deduplicationDirectCode) {
        KmsTenantryDirectCustomerOrgReqVo customerOrgReqVo = new KmsTenantryDirectCustomerOrgReqVo();
        customerOrgReqVo.setBsDirectSystemCodeList(deduplicationDirectCode);
        customerOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        customerOrgReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTenantryDirectCustomerOrgEntity> customerOrgEntities = this.kmsTenantryDirectCustomerOrgMapper.selectListForExcel(customerOrgReqVo);
        if (CollectionUtils.isEmpty(customerOrgEntities)) {
            for (KmsTenantryDirectStoreImportVo item : data) {
                item.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3011\u3001");
            }
            return;
        }
        Map customerOrgEntityMap = customerOrgEntities.stream().collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
        List terminalVos = this.mdmTerminalMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).in(MdmTerminalEntity::getTerminalCode, deduplicationTerminalCode));
        Map<Object, Object> terminalMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)terminalVos)) {
            terminalMap = terminalVos.stream().collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, Function.identity()));
        }
        HashMap finalTerminalVoMap = terminalMap;
        data.forEach(x -> {
            if (!customerOrgEntityMap.containsKey(x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("\u3010" + x.getBsDirectSystemCode() + "\u3011\u7684\u76f4\u8425\u4f53\u7cfb\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
            } else {
                KmsTenantryDirectCustomerOrgEntity customerOrgEntity = (KmsTenantryDirectCustomerOrgEntity)((Object)((Object)customerOrgEntityMap.get(x.getBsDirectSystemCode())));
                x.setBsDirectSystemId(customerOrgEntity.getBsDirectSystemId());
                x.setBsDirectSystemName(customerOrgEntity.getBsDirectSystemName());
                x.setDirectId(customerOrgEntity.getDirectId());
                this.bsSystemIdsForExist.add(x.getBsDirectSystemId());
            }
            if (!finalTerminalVoMap.containsKey(x.getTerminalCode())) {
                x.appendErrorValidateMsg("\u3010" + x.getTerminalCode() + "\u3011\u7684\u4f01\u4e1a\u95e8\u5e97\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
            } else {
                x.setTerminalName(((MdmTerminalEntity)((Object)((Object)finalTerminalVoMap.get(x.getTerminalCode())))).getTerminalName());
                this.terminalCodesForExist.add(x.getTerminalCode());
            }
            List areaEntities = this.kmsDirectStoreAreaMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(KmsDirectStoreAreaEntity::getDirectId, (Object)x.getDirectId()));
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(KmsDirectStoreEntity::getStoreCode, (Object)x.getStoreCode())).eq(KmsDirectStoreEntity::getDirectId, (Object)x.getDirectId())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode());
            if (StringUtils.isNotBlank((CharSequence)x.getAreaCode())) {
                if (CollectionUtils.isNotEmpty((Collection)areaEntities)) {
                    Map<String, String> stringStringMap = areaEntities.stream().collect(Collectors.toMap(KmsDirectStoreAreaEntity::getDsAreaCode, BaseIdEntity::getId));
                    if (stringStringMap.containsKey(x.getAreaCode())) {
                        x.setAreaId(stringStringMap.get(x.getAreaCode()));
                        wrapper.eq(KmsDirectStoreEntity::getAreaId, (Object)x.getAreaId());
                        List entities = this.kmsDirectStoreMapper.selectList((Wrapper)wrapper);
                        if (CollectionUtils.isEmpty((Collection)entities)) {
                            x.appendErrorValidateMsg("\u76f4\u8425\u4f53\u7cfb\u3010" + x.getBsDirectSystemCode() + "\u3001" + x.getStoreCode() + "\u3011\u7684\u5ba2\u6237\u95e8\u5e97\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
                        } else {
                            x.setStoreName(((KmsDirectStoreEntity)((Object)((Object)entities.get(0)))).getStoreName());
                            x.setStoreId(((KmsDirectStoreEntity)((Object)((Object)entities.get(0)))).getId());
                        }
                    } else {
                        x.appendErrorValidateMsg("\u3010\u5546\u8d85\u533a\u57df\u4e0d\u53ef\u7528\u3011\u3001");
                    }
                } else {
                    x.appendErrorValidateMsg("\u3010\u5546\u8d85\u533a\u57df\u4e0d\u53ef\u7528\u3011\u3001");
                }
            }
            if (StringUtils.isBlank((CharSequence)x.getAreaCode())) {
                List entities = this.kmsDirectStoreMapper.selectList((Wrapper)wrapper);
                if (CollectionUtils.isEmpty((Collection)entities)) {
                    x.appendErrorValidateMsg("\u76f4\u8425\u4f53\u7cfb\u3010" + x.getBsDirectSystemCode() + "\u3001" + x.getStoreCode() + "\u3011\u7684\u5ba2\u6237\u95e8\u5e97\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
                } else {
                    x.setStoreName(((KmsDirectStoreEntity)((Object)((Object)entities.get(0)))).getStoreName());
                    x.setStoreId(((KmsDirectStoreEntity)((Object)((Object)entities.get(0)))).getId());
                }
            }
        });
    }
}

