/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.material;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.material.MdmMaterialImportVo;
import com.biz.crm.mdm.material.entity.MdmMaterialEntity;
import com.biz.crm.mdm.material.mapper.MdmMaterialMapper;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmMaterialImportValidator")
public class MdmMaterialImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmMaterialMapper, MdmMaterialEntity, MdmMaterialImportVo>
implements ExcelImportValidator<MdmMaterialImportVo> {
    @Resource
    private MdmMaterialMapper mdmMaterialMapper;
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;
    private Pattern pattern = Pattern.compile("^(\\+)?\\d+(\\.\\d+)?$");

    @Override
    public void validate(List<MdmMaterialImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.checkMaterialIsNull(data);
        this.checkMaterialCode(data);
        this.checkProductLevelCode(data);
        this.checkMaterialType(data);
        this.checkMaterialBaseUnit(data);
        this.checkMaterialStandardUnit(data);
        this.checkMaterialSaleUnit(data);
        this.checkNumber(data);
        this.checkSaleCompany(data);
    }

    protected void checkMaterialIsNull(List<MdmMaterialImportVo> data) {
        if (CollectionUtil.listNotEmptyNotSizeZero(data)) {
            data.forEach(m -> {
                if (StringUtils.isEmpty((String)m.getMaterialName())) {
                    m.appendErrorValidateMsg("\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
                if (StringUtils.isEmpty((String)m.getProductLevelCode())) {
                    m.appendErrorValidateMsg("\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
                if (StringUtils.isEmpty((String)m.getMaterialTypeName())) {
                    m.appendErrorValidateMsg("\u7269\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
                if (StringUtils.isEmpty((String)m.getBaseUnitName())) {
                    m.appendErrorValidateMsg("\u57fa\u672c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
                if (StringUtils.isEmpty((String)m.getUnitConversion())) {
                    m.appendErrorValidateMsg("\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
            });
        }
    }

    protected void checkMaterialCode(List<MdmMaterialImportVo> data) {
        Set collect = data.stream().filter(item -> StringUtils.isNotEmpty((String)item.getMaterialCode())).map(MdmMaterialImportVo::getMaterialCode).collect(Collectors.toSet());
        if (collect.isEmpty()) {
            return;
        }
        HashSet materialSet = new HashSet();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmMaterialEntity::getMaterialCode});
        wrapper.in(MdmMaterialEntity::getMaterialCode, collect);
        Set materialCodeSet = this.mdmMaterialMapper.selectList((Wrapper)wrapper).stream().map(MdmMaterialEntity::getMaterialCode).collect(Collectors.toSet());
        HashMap<String, Integer> codeIndexMap = new HashMap<String, Integer>(16);
        for (MdmMaterialImportVo item2 : data) {
            if (StringUtils.isEmpty((String)item2.getMaterialCode())) continue;
            if (materialCodeSet.contains(item2.getMaterialCode())) {
                item2.appendErrorValidateMsg("\u7269\u6599\u7f16\u7801\u5df2\u5b58\u5728\uff1b");
                continue;
            }
            if (codeIndexMap.containsKey(item2.getMaterialCode())) {
                item2.appendErrorValidateMsg("\u7269\u6599\u7f16\u7801\u4e0e\u7b2c" + item2.getMaterialCode() + "\u884c\u91cd\u590d\uff1b");
                continue;
            }
            codeIndexMap.put(item2.getMaterialCode(), item2.getRowIndex());
        }
    }

    protected void checkProductLevelCode(List<MdmMaterialImportVo> data) {
        HashMap productMap = new HashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero(data)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode});
            List mdmProductLevelEntities = this.mdmProductLevelMapper.selectList((Wrapper)wrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)mdmProductLevelEntities)) {
                mdmProductLevelEntities.stream().filter(m -> StringUtils.isNotEmpty((String)m.getProductLevelCode())).forEach(m -> {
                    String cfr_ignored_0 = productMap.put(m.getProductLevelCode(), null);
                });
            }
            for (MdmMaterialImportVo datum : data) {
                if (productMap.containsKey(datum.getProductLevelCode())) continue;
                datum.appendErrorValidateMsg("\u5f53\u524d\u5c42\u7ea7\u7f16\u7801" + datum.getProductLevelCode() + "\u4e0d\u5b58\u5728\uff1b");
            }
        }
    }

    protected void checkMaterialType(List<MdmMaterialImportVo> vos) {
        Map map = DictUtil.dictMap((String)"material_type");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmMaterialImportVo materialImportVo : vos) {
            String materialTypeName = materialImportVo.getMaterialTypeName();
            if (org.springframework.util.StringUtils.isEmpty((Object)materialTypeName)) continue;
            if (!channelMap.containsKey(materialTypeName)) {
                materialImportVo.appendErrorValidateMsg("\u884c\u53f7:" + materialImportVo.getRowIndex() + "\u7269\u6599\u7c7b\u578b:" + materialTypeName + "\u4e0d\u5b58\u5728;");
                continue;
            }
            materialImportVo.setMaterialType((String)channelMap.get(materialTypeName));
        }
    }

    protected void checkSaleCompany(List<MdmMaterialImportVo> vos) {
        Map map = DictUtil.dictMap((String)"sale_company");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmMaterialImportVo materialImportVo : vos) {
            String saleCompanyName = materialImportVo.getSaleCompanyName();
            if (org.springframework.util.StringUtils.isEmpty((Object)saleCompanyName)) continue;
            if (!channelMap.containsKey(saleCompanyName)) {
                materialImportVo.appendErrorValidateMsg("\u884c\u53f7:" + materialImportVo.getRowIndex() + "\u9500\u552e\u516c\u53f8:" + saleCompanyName + "\u4e0d\u5b58\u5728;");
                continue;
            }
            materialImportVo.setSaleCompany((String)channelMap.get(saleCompanyName));
        }
    }

    protected void checkMaterialBaseUnit(List<MdmMaterialImportVo> vos) {
        Map map = DictUtil.dictMap((String)"material_base_unit");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmMaterialImportVo materialImportVo : vos) {
            String baseUnitName = materialImportVo.getBaseUnitName();
            if (org.springframework.util.StringUtils.isEmpty((Object)baseUnitName)) continue;
            if (!channelMap.containsKey(baseUnitName)) {
                materialImportVo.appendErrorValidateMsg("\u884c\u53f7:" + materialImportVo.getRowIndex() + "\u7269\u6599\u57fa\u672c\u5355\u4f4d:" + baseUnitName + "\u4e0d\u5b58\u5728;");
                continue;
            }
            materialImportVo.setBaseUnit((String)channelMap.get(baseUnitName));
        }
    }

    protected void checkMaterialSaleUnit(List<MdmMaterialImportVo> vos) {
        Map map = DictUtil.dictMap((String)"material_sale_unit");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmMaterialImportVo materialImportVo : vos) {
            String saleUnitName = materialImportVo.getSaleUnitName();
            if (org.springframework.util.StringUtils.isEmpty((Object)saleUnitName)) continue;
            if (!channelMap.containsKey(saleUnitName)) {
                materialImportVo.appendErrorValidateMsg("\u884c\u53f7:" + materialImportVo.getRowIndex() + "\u7269\u6599\u9500\u552e\u5355\u4f4d:" + saleUnitName + "\u4e0d\u5b58\u5728;");
                continue;
            }
            materialImportVo.setSaleUnit((String)channelMap.get(saleUnitName));
        }
    }

    protected void checkNumber(List<MdmMaterialImportVo> vos) {
        if (CollectionUtil.listNotEmptyNotSizeZero(vos)) {
            vos.stream().filter(m -> StringUtils.isNotEmpty((String)m.getCostPrice()) && StringUtils.isNotEmpty((String)m.getUnitConversion())).forEach(m -> {
                if (!this.pattern.matcher(m.getCostPrice()).matches()) {
                    m.appendErrorValidateMsg("\u6210\u672c\u4ef7(\u5143) \u6570\u5b57\u683c\u5f0f\u9519\u8bef");
                }
                if (!this.pattern.matcher(m.getUnitConversion()).matches()) {
                    m.appendErrorValidateMsg("\u5355\u4f4d\u6362\u7b97\u7cfb\u6570 \u6570\u5b57\u683c\u5f0f\u9519\u8bef");
                }
            });
        }
    }

    protected void checkMaterialStandardUnit(List<MdmMaterialImportVo> vos) {
        Map map = DictUtil.dictMap((String)"material_standard_unit");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmMaterialImportVo materialImportVo : vos) {
            String standardUnitName = materialImportVo.getStandardUnitName();
            if (org.springframework.util.StringUtils.isEmpty((Object)standardUnitName)) continue;
            if (!channelMap.containsKey(standardUnitName)) {
                materialImportVo.appendErrorValidateMsg("\u884c\u53f7:" + materialImportVo.getRowIndex() + "\u7269\u6599\u6807\u51c6\u5355\u4f4d:" + standardUnitName + "\u4e0d\u5b58\u5728;");
                continue;
            }
            materialImportVo.setStandardUnit((String)channelMap.get(standardUnitName));
        }
    }
}

