/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.materialGroup;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.materialGroup.MdmMaterialGroupImportVo;
import com.biz.crm.mdm.material.entity.MdmMaterialEntity;
import com.biz.crm.mdm.material.mapper.MdmMaterialMapper;
import com.biz.crm.mdm.materialGroup.entity.MdmMaterialGroupEntity;
import com.biz.crm.mdm.materialGroup.mapper.MdmMaterialGroupMapper;
import com.biz.crm.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmMaterialGroupImportValidator")
public class MdmMaterialGroupImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmMaterialGroupMapper, MdmMaterialGroupEntity, MdmMaterialGroupImportVo>
implements ExcelImportValidator<MdmMaterialGroupImportVo> {
    @Resource
    private MdmMaterialGroupMapper mdmMaterialGroupMapper;
    @Resource
    private MdmMaterialMapper mdmMaterialMapper;

    @Override
    public void validate(List<MdmMaterialGroupImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Set collect = data.stream().filter(itemGroup -> StringUtils.isNotEmpty((String)itemGroup.getMaterialGroupCode())).map(MdmMaterialGroupImportVo::getMaterialGroupCode).collect(Collectors.toSet());
        if (collect.isEmpty()) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmMaterialGroupEntity::getMaterialGroupCode});
        ((LambdaQueryWrapper)wrapper.in(MdmMaterialGroupEntity::getMaterialGroupCode, collect)).eq(CrmBaseEntity::getEnableStatus, (Object)"009");
        Set materialCodeSet = this.mdmMaterialGroupMapper.selectList((Wrapper)wrapper).stream().map(MdmMaterialGroupEntity::getMaterialGroupCode).collect(Collectors.toSet());
        data.forEach(item -> {
            if (StringUtils.isEmpty((String)item.getMaterialGroupCode())) {
                item.appendErrorValidateMsg("\u7269\u6599\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            if (StringUtils.isEmpty((String)item.getMaterialGroupName())) {
                item.appendErrorValidateMsg("\u7269\u6599\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            if (StringUtils.isEmpty((String)item.getMaterialCode())) {
                item.appendErrorValidateMsg("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            HashMap<String, Integer> codeIndexMap = new HashMap<String, Integer>(16);
            if (materialCodeSet.contains(item.getMaterialCode())) {
                item.appendErrorValidateMsg("\u7269\u6599\u7ec4\u7f16\u7801" + item.getMaterialCode() + "\u5df2\u5b58\u5728\uff1b");
            } else if (codeIndexMap.containsKey(item.getMaterialCode())) {
                item.appendErrorValidateMsg("\u7269\u6599\u7ec4\u7f16\u7801" + item.getMaterialCode() + "\u548c\u7b2c" + codeIndexMap.get(item.getMaterialCode()) + "\u884c\u7269\u6599\u7ec4\u7f16\u7801\u91cd\u590d\uff1b");
            } else {
                codeIndexMap.put(item.getMaterialCode(), item.getRowIndex());
            }
            String materialCode = item.getMaterialCode();
            List<String> materialCodeList = Arrays.asList(materialCode.split(","));
            materialCodeList.forEach(itemCode -> {
                List mdmMaterialEntities = this.mdmMaterialMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MdmMaterialEntity.class).eq(MdmMaterialEntity::getMaterialCode, itemCode)).eq(CrmBaseEntity::getEnableStatus, (Object)"009"));
                if (CollectionUtils.isEmpty((Collection)mdmMaterialEntities)) {
                    item.appendErrorValidateMsg("\u7cfb\u7edf\u4e0d\u5b58\u5728\u6b64\u7269\u6599\u4fe1\u606f" + itemCode);
                }
            });
        });
    }
}

