/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.service.impl;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.ExportHelper;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.controller.req.ExportParamVo;
import com.biz.crm.excel.service.IExcelService;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.excel.util.ExportTaskThread;
import com.biz.crm.mdm.columnconfig.MdmColumnConfigFeign;
import com.biz.crm.mdm.tableconfig.MdmFunctionSubFeign;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"ExcelServiceImpl"})
public class ExcelServiceImpl
implements IExcelService {
    private static final Logger log = LoggerFactory.getLogger(ExcelServiceImpl.class);
    @Value(value="${excel.export.downloadUrl}")
    private String EXCEL_DOWNLOAD_URL;
    @Resource
    private ExportHelper exportHelper;
    @Resource
    private MdmFunctionSubFeign mdmFunctionSubFeign;
    @Resource
    private MdmColumnConfigFeign mdmColumnConfigFeign;
    private static final Integer PAGE_SIZE = 200;
    private static final Integer CORE_POOL_SIZE = 10;
    private static final Integer MAXIMUM_POOL_SIZE = 20;
    private static final Integer KEEP_ALIVE_TIME = 20;
    private static final Integer SIZE = 30;
    private static final BlockingQueue<Runnable> QUEUE = new LinkedBlockingQueue<Runnable>(SIZE);
    public static ThreadPoolExecutor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, KEEP_ALIVE_TIME.intValue(), TimeUnit.SECONDS, QUEUE);

    @Override
    public void repeatedWriteExport(HashMap<String, Object> requestParamMap) {
        ExportParamVo exportParam = (ExportParamVo)JsonPropertyUtil.toObject(requestParamMap, ExportParamVo.class);
        this.checkExportParamVo(exportParam);
        DefaultExportContext exportContext = this.buildExportContext(exportParam);
        exportContext.setRequestParamMap(requestParamMap);
        exportContext.setPageDataAdviser(new PageDataAdviser(PAGE_SIZE.intValue()));
        int threadSize = QUEUE.size();
        if (threadSize == SIZE) {
            try {
                QUEUE.put(() -> this.exportHelper.sendWebsocketMsgMQ("\u5f53\u524d\u5bfc\u51fa\u4eba\u6570\u592a\u591a,\u6b63\u5728\u6392\u961f\u5904\u7406,\u8bf7\u7a0d\u540e\u5230\u4e0b\u8f7d\u4e2d\u5fc3\u67e5\u770b", exportContext));
            }
            catch (InterruptedException e) {
                log.warn("\u521b\u5efa\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25", (Throwable)e);
                throw new BusinessException("\u521b\u5efa\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            }
        }
        THREAD_POOL_EXECUTOR.execute(new ExportTaskThread(exportContext, this.EXCEL_DOWNLOAD_URL));
    }

    private DefaultExportContext buildExportContext(ExportParamVo exportParam) {
        ExportHeadExtend headExtend = this.getExportExtendProcessor(exportParam.getFunctionCode());
        DefaultExportContext exportContext = new DefaultExportContext();
        exportContext.setExportParam(exportParam);
        exportContext.setHeadExtend(headExtend);
        exportContext.setLoginUserToken(UserUtils.getToken());
        this.loadFunctionName(exportContext);
        this.loadExcelHeadConfig(exportContext);
        return exportContext;
    }

    private void loadExcelHeadConfig(DefaultExportContext exportContext) {
        ExportParamVo exportParam = exportContext.getExportParam();
        LinkedHashMap map = Maps.newLinkedHashMap();
        MdmColumnConfigReqVo mdmColumnConfigReqVo = new MdmColumnConfigReqVo();
        mdmColumnConfigReqVo.setParentCode(exportParam.getParentCode());
        mdmColumnConfigReqVo.setFunctionCode(exportParam.getFunctionCode());
        Result result = this.mdmColumnConfigFeign.columnSelect(mdmColumnConfigReqVo);
        ApiResultUtil.checkResult((Result)result);
        List mdmColumnExportRespVos = (List)result.getResult();
        if (null != mdmColumnExportRespVos) {
            for (MdmColumnExportRespVo data : mdmColumnExportRespVos) {
                String field = data.getField();
                if (YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString().equals(data.getColumnExport()) || "checkTypecheckbox".equals(field)) continue;
                if (StringUtils.isEmpty((CharSequence)field) || StringUtils.isEmpty((CharSequence)data.getTitle())) {
                    throw new BusinessException("\u5217\u8868\u5b57\u6bb5\u914d\u7f6e\u9519\u8bef\uff0c\u5c5e\u6027/\u5217\u5934\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                map.put(field, data);
            }
        }
        exportContext.setHeadMap(map);
    }

    private void loadFunctionName(DefaultExportContext exportContext) {
        final ExportParamVo exportParam = exportContext.getExportParam();
        MdmFunctionSubReqVo mdmFunctionSubReqVo = new MdmFunctionSubReqVo(){
            {
                this.setParentCode(exportParam.getParentCode());
                this.setFunctionCode(exportParam.getFunctionCode());
            }
        };
        String functionName = ((MdmFunctionSubRespVo)ApiResultUtil.objResult((Result)this.mdmFunctionSubFeign.functionSubSearch(mdmFunctionSubReqVo), (boolean)true)).getFunctionName();
        if (StringUtils.isBlank((CharSequence)functionName)) {
            throw new BusinessException("\u83b7\u53d6\u529f\u80fd\u540d\u79f0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        exportContext.setFunctionName(functionName);
    }

    private void checkExportParamVo(ExportParamVo exportParam) {
        if (StringUtils.isBlank((CharSequence)exportParam.getSid())) {
            throw new BusinessException("websocket\u8fde\u63a5id\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)exportParam.getFunctionCode())) {
            throw new BusinessException("\u5217\u8868\u529f\u80fd\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)exportParam.getParentCode())) {
            throw new BusinessException("\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)exportParam.getRequestUrl())) {
            throw new BusinessException("\u6570\u636e\u5217\u8868\u63a5\u53e3\u8bf7\u6c42\u8def\u5f84");
        }
    }

    private ExportHeadExtend getExportExtendProcessor(String functionCode) {
        if (StringUtils.isBlank((CharSequence)functionCode)) {
            return null;
        }
        String beanName = functionCode + "ExportHeadExtend";
        if (SpringApplicationContextUtil.getApplicationContext().containsBean(beanName)) {
            try {
                ExportHeadExtend exportHeadExtend = (ExportHeadExtend)SpringApplicationContextUtil.getApplicationContext().getBean(beanName, ExportHeadExtend.class);
                return exportHeadExtend;
            }
            catch (Exception e) {
                log.warn("\u8bb2\u9053\u7406\u4e0d\u5e94\u8be5\u8dd1\u8fd9\u91cc\u6765\u7684", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

