/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.excel.component.ExportHelper;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.controller.req.ExportParamVo;
import com.biz.crm.excel.service.impl.ExcelServiceImpl;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.excel.util.ExcelImportUtil;
import com.biz.crm.mdm.columnconfig.MdmColumnConfigFeign;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.Result;
import com.biz.crm.util.ResultUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class ExcelExportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportUtil.class);
    @Value(value="${excel.export.basdir}")
    private String EXCEL_EXPORT_BASDIR;
    @Value(value="${excel.export.url}")
    private String URL;
    @Value(value="${excel.export.uploadUrl}")
    private String UPLOAD_URL;
    private static final Integer PAGE_SIZE = 100;
    private static final Integer PAGE_NUM = 1;
    private static UserWebSocketHandler userWebSocketHandler = new UserWebSocketHandler();
    @Resource
    private RestTemplateUtils restTemplateUtils;
    @Autowired
    private ExcelServiceImpl excelService;
    @Resource
    private MdmColumnConfigFeign mdmColumnConfigFeign;
    @Resource
    private ExportHelper exportHelper;

    private void againWrite(DefaultExportContext exportContext, List<?> data, ExcelWriter excelWriter) {
        excelWriter.write(data, exportContext.getWriteSheet());
        this.exportHelper.sendWebsocketMsgMQ("\u5df2\u5199\u5165\u4e34\u65f6\u6587\u4ef6\uff1a" + exportContext.getWrittenNo() + "/" + exportContext.getPageTotal() + "\u6761\u6570\u636e", exportContext);
    }

    private List<List<String>> resolveHeadMap(Map<String, MdmColumnExportRespVo> map) {
        ArrayList listList = Lists.newArrayList();
        for (Map.Entry<String, MdmColumnExportRespVo> m : map.entrySet()) {
            ArrayList<String> headList = new ArrayList<String>();
            headList.add(m.getValue().getTitle());
            listList.add(headList);
        }
        return listList;
    }

    private Result getPageData(DefaultExportContext exportContext) {
        try {
            ExportParamVo exportParam = exportContext.getExportParam();
            String requestUrl = exportParam.getRequestUrl();
            HashMap<String, Object> requestParamMap = exportContext.getRequestParamMap();
            PageDataAdviser pageDataAdviser = exportContext.getPageDataAdviser();
            Integer pageNum = pageDataAdviser.nextPage();
            requestParamMap.put("pageNum", pageNum);
            requestParamMap.put("pageSize", pageDataAdviser.getPageSize());
            requestUrl = this.URL + requestUrl;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.set("loginUserToken", exportContext.getLoginUserToken());
            headers.set("menuCode", exportParam.getParentCode());
            headers.set("functionCode", exportParam.getFunctionCode());
            if (log.isInfoEnabled()) {
                log.info("\u5bfc\u51fa\u4efb\u52a1 [" + exportContext.getTaskCode() + "]\u5c1d\u8bd5\u8bfb\u53d6\u5217\u8868\u6570\u636e:[\u7b2c" + pageNum + "\u9875,\u6bcf\u9875" + pageDataAdviser.getPageSize() + "\u6761\u6570\u636e], params=" + JsonPropertyUtil.toJsonString(requestParamMap));
            }
            ResponseEntity response = RestTemplateUtils.postForEntity((String)requestUrl, (HttpHeaders)headers, requestParamMap, Result.class);
            Result result = (Result)response.getBody();
            ApiResultUtil.checkResult((Result)result);
            return result;
        }
        catch (Exception e) {
            String msg = "\u5bfc\u51fa\u4efb\u52a1 [" + exportContext.getTaskCode() + "]\u8bfb\u53d6\u5217\u8868\u6570\u636e\u4fe1\u606f\u5931\u8d25";
            log.error(msg, (Throwable)e);
            this.exportHelper.processException(exportContext, msg);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadVo repeatedWrite(DefaultExportContext exportContext) {
        Result result = this.getPageData(exportContext);
        PageResult pageResult = (PageResult)JsonPropertyUtil.toObject((String)JsonPropertyUtil.toJsonStringNotEmptyVal((Object)result.getResult()), PageResult.class);
        Long pageTotal = pageResult.getCount();
        exportContext.setPageTotal(pageTotal);
        this.exportHelper.sendWebsocketMsgMQ("\u9884\u8ba1\u5199\u5165\u6570\u636e\u603b\u6761\u6570\uff1a" + pageTotal, exportContext);
        this.verificationDataCount(exportContext, pageTotal);
        this.headExtend(exportContext, pageResult);
        List<List<Object>> dataList = this.resolveBizData(exportContext, pageResult);
        File file = this.tempFile(exportContext);
        ExcelWriter excelWriter = null;
        try {
            List<List<String>> headList = this.resolveHeadMap(exportContext.getHeadMap());
            excelWriter = ((ExcelWriterBuilder)EasyExcel.write((File)file).head(headList)).build();
            exportContext.addWrittenNo(dataList.size());
            this.againWrite(exportContext, dataList, excelWriter);
            this.againGetPageData(exportContext, excelWriter);
            this.exportHelper.sendWebsocketMsgMQ("\u5df2\u5b8c\u6210\u5168\u90e8\u6570\u636e\u5199\u5165,\u603b\u5171\u5199\u5165\u6570\u636e\uff1a" + exportContext.getPageTotal() + "\u6761", exportContext);
        }
        finally {
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
        this.exportHelper.sendWebsocketMsgMQ("\u6b63\u5728\u5c1d\u8bd5\u4e0a\u4f20\u6587\u4ef6\uff0c\u8bf7\u7a0d\u540e.......", exportContext);
        try {
            List uploadVos = ResultUtil.listResultFromJsonStr((String)this.uploadFile(file.getPath(), exportContext.getLoginUserToken()), UploadVo.class, (boolean)true);
            return (UploadVo)uploadVos.get(0);
        }
        catch (Exception e) {
            String msg = "\u5bfc\u51fa\u4efb\u52a1 [" + exportContext.getTaskCode() + "]\u4e0a\u4f20\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25";
            log.warn(msg, (Throwable)e);
            this.exportHelper.processException(exportContext, msg);
            return null;
        }
    }

    private File tempFile(DefaultExportContext exportContext) {
        try {
            this.exportHelper.sendWebsocketMsgMQ("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6,\u51c6\u5907\u5199\u5165\u6570\u636e\uff1a[" + exportContext.getExcelFileName() + "]", exportContext);
            return File.createTempFile(exportContext.getExcelFileName(), ExcelTypeEnum.XLSX.getValue());
        }
        catch (IOException e) {
            log.warn("\u5bfc\u51fa\u4efb\u52a1 [" + exportContext.getTaskCode() + "]\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u5bfc\u51fa\u4efb\u52a1 [" + exportContext.getTaskCode() + "]\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }

    private List<Map> headValueExtend(DefaultExportContext exportContext, List<Map> dataMaps) {
        ExportHeadExtend headExtend = exportContext.getHeadExtend();
        if (null == headExtend) {
            return dataMaps;
        }
        List<Map> dataMapsTemp = headExtend.getHeadsValue(exportContext, dataMaps);
        dataMaps = dataMapsTemp == null ? dataMaps : dataMapsTemp;
        return dataMaps;
    }

    private List<List<Object>> resolveBizData(DefaultExportContext exportContext, PageResult pageResult) {
        List<Map> dataMaps = pageResult.getData();
        Integer sumFirst = exportContext.getHeadVariableSum();
        dataMaps = this.headValueExtend(exportContext, dataMaps);
        Integer sumExtend = exportContext.getHeadVariableSum();
        if (sumExtend != 0 && sumExtend > sumFirst) {
            this.headExtend(exportContext, pageResult);
        }
        LinkedHashMap<String, MdmColumnExportRespVo> headMap = exportContext.getHeadMap();
        ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
        for (Map data : dataMaps) {
            ArrayList<String> dataRow = new ArrayList<String>();
            for (Map.Entry head : headMap.entrySet()) {
                String valAsDict;
                String column = (String)head.getKey();
                String dictCode = ((MdmColumnExportRespVo)head.getValue()).getDictCode();
                String val = null;
                Object dataValue = data.get(column);
                if (dataValue instanceof String || dataValue instanceof Number) {
                    val = (String)data.get(column);
                } else {
                    log.warn("\u63a5\u53e3\u8fd4\u56de\u7c7b\u578b\u4e0d\u5408\u89c4\u8303 funciontCode=[{}],\u5b57\u6bb5=[{}]", (Object)exportContext.getExportParam().getFunctionCode(), (Object)column);
                }
                if (StringUtils.isNotEmpty((String)val) && StringUtils.isNotEmpty((String)dictCode) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(valAsDict = DictUtil.dictValue((String)dictCode, (String)val)))) {
                    val = valAsDict;
                }
                dataRow.add(val);
            }
            dataList.add(dataRow);
        }
        return dataList;
    }

    private void againGetPageData(DefaultExportContext exportContext, ExcelWriter excelWriter) {
        PageDataAdviser pageDataAdviser = exportContext.getPageDataAdviser();
        while (pageDataAdviser.hasNext(exportContext.getPageTotal())) {
            Result result = this.getPageData(exportContext);
            PageResult pageResult = (PageResult)JsonPropertyUtil.toObject((String)JsonPropertyUtil.toJsonString((Object)result.getResult()), PageResult.class);
            List<List<Object>> dataList = this.resolveBizData(exportContext, pageResult);
            exportContext.addWrittenNo(dataList.size());
            this.againWrite(exportContext, dataList, excelWriter);
        }
    }

    public String uploadFile(String urlFile, String token) {
        String requestUrl = this.URL + this.UPLOAD_URL;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set("loginUserToken", token);
        String[] fileUrls = urlFile.split(",");
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        for (int i = 0; i < fileUrls.length; ++i) {
            form.add((Object)"file", (Object)new FileSystemResource(fileUrls[i]));
        }
        HttpEntity httpEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        String result = RestTemplateUtils.postForObject((String)requestUrl, (HttpEntity)httpEntity);
        return result;
    }

    public String createExcelFile(String excelFileName, Class classObj, ExcelTypeEnum excelTypeEnum, List<?> data, Set<String> excludeColumnFiledNames) {
        if (null == classObj || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)excelFileName)) {
            throw new BusinessException("\u7c7b\u8def\u5f84\u3001\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == excelTypeEnum) {
            excelTypeEnum = ExcelTypeEnum.XLSX;
        }
        File file = ExcelImportUtil.writeFile(excelFileName, classObj, excelTypeEnum, data, excludeColumnFiledNames);
        return this.uploadFile(file.getPath(), UserUtils.getToken());
    }

    private void verificationDataCount(DefaultExportContext exportContext, Long pageTotal) {
        if (pageTotal == 0L) {
            this.exportHelper.processException(exportContext, "\u5bfc\u51fa\u603b\u6761\u6570\u4e3a0");
        }
    }

    private void headExtend(DefaultExportContext exportContext, PageResult pageResult) {
        ExportHeadExtend headExtend = exportContext.getHeadExtend();
        if (null == headExtend) {
            return;
        }
        ExportHeadExtend.ExportHeadExtendParam headExtendParam = new ExportHeadExtend.ExportHeadExtendParam();
        headExtendParam.setDataRow((Map)pageResult.getData().get(0));
        headExtendParam.setHeadVariableSum(exportContext.getHeadVariableSum());
        List<MdmColumnExportRespVo> heads = headExtend.getHeads(headExtendParam);
        if (null == heads) {
            return;
        }
        LinkedHashMap<String, MdmColumnExportRespVo> headMap = exportContext.getHeadMap();
        for (MdmColumnExportRespVo head : heads) {
            if (null == head) continue;
            if (StringUtils.isEmpty((String)head.getField()) || StringUtils.isEmpty((String)head.getTitle())) {
                String msg = "\u6269\u5c55\u5217\u5934\u6570\u636e\u9519\u8bef\uff0c\u5c5e\u6027/\u5217\u5934\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5217\u5934\u6269\u5c55\u7c7b\u5b9e\u4f8b[" + exportContext.getFunctionName() + "]";
                this.exportHelper.delTask(msg, exportContext);
                throw new BusinessException(msg);
            }
            headMap.put(head.getField(), head);
        }
    }
}

