/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.dms.order;

import com.biz.crm.dms.order.DmsOrderFeign;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderImportVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.util.CommonConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;

@Component(value="dmsOrderSaver")
public class DmsOrderSaver
implements ExcelImportSaver<OrderImportVo> {
    private static final String DEFAULT_PICK_TYPE = "0";
    private static final String DEFAULT_ORDER_RESOURCE = "10";
    private static final int SAVE_COUNT = 20;
    @Resource
    private DmsOrderFeign dmsOrderFeign;

    @Override
    public void save(List<OrderImportVo> list, DefaultImportContext defaultImportContext) {
        Map<String, List<OrderImportVo>> orderMap = list.stream().collect(Collectors.groupingBy(li -> String.join((CharSequence)",", li.getCusCode(), li.getPickAddressCode(), li.getOrderTypeCode(), li.getPickDate())));
        ArrayList orderVos = Lists.newArrayList();
        orderMap.forEach((k, v) -> {
            OrderVo order = this.buildOrderHead((String)k, (OrderImportVo)v.get(0));
            List<OrderDetailVo> details = this.buildOrderDetails((List<OrderImportVo>)v);
            ArrayList orderGroupItemVos = Lists.newArrayList();
            details.forEach(detail -> {
                OrderGroupItemVo groupItemVo = new OrderGroupItemVo();
                groupItemVo.setNormalList((List)Lists.newArrayList((Object[])new OrderDetailVo[]{detail}));
                groupItemVo.setGiftList((List)Lists.newArrayList());
                groupItemVo.setBackList((List)Lists.newArrayList());
                orderGroupItemVos.add(groupItemVo);
            });
            order.setGroupItemVos((List)orderGroupItemVos);
            orderVos.add(order);
            ArrayList vos = Lists.newArrayList();
            for (int i = 1; i <= orderVos.size(); ++i) {
                vos.add(orderVos.get(i - 1));
                if (i % 20 != 0 && i != orderVos.size()) continue;
                vos.clear();
            }
        });
    }

    private List<OrderDetailVo> buildOrderDetails(List<OrderImportVo> orderImportVos) {
        ArrayList details = Lists.newArrayList();
        int i = 0;
        for (OrderImportVo o : orderImportVos) {
            OrderDetailVo detail = new OrderDetailVo();
            detail.setProductCode(o.getProductCode());
            detail.setProductName(o.getProductName());
            detail.setProductNum(new BigDecimal(o.getCount()));
            detail.setLineNo(String.valueOf(i));
            detail.setPrice(o.getPrice());
            detail.setAmount(o.getAmount());
            details.add(detail);
            ++i;
        }
        return details;
    }

    private OrderVo buildOrderHead(String k, OrderImportVo orderImportVo) {
        OrderVo order = new OrderVo();
        String[] ks = k.split(",");
        order.setCusCode(ks[0]);
        order.setCusName(orderImportVo.getCusName());
        order.setPickAdress(ks[1]);
        order.setType(ks[2]);
        order.setPickType(DEFAULT_PICK_TYPE);
        order.setFromType(DEFAULT_ORDER_RESOURCE);
        order.setGiveDate(ks[3]);
        order.setRemarks(orderImportVo.getRemark());
        order.setTemporaryFlag(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        return order;
    }
}

