/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.kms.acceptance;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.acceptanceform.KmsAcceptanceFormImportVo;
import com.biz.crm.kms.form.acceptanceform.entity.KmsAcceptanceFormDetailDwEntity;
import com.biz.crm.kms.form.acceptanceform.entity.KmsAcceptanceGoodsDetailDwEntity;
import com.biz.crm.kms.form.acceptanceform.entity.KmsDataAuthEntity;
import com.biz.crm.kms.form.acceptanceform.mapper.KmsAcceptanceFormDetailDwMapper;
import com.biz.crm.kms.form.acceptanceform.mapper.KmsAcceptanceGoodsDetailDwMapper;
import com.biz.crm.kms.form.acceptanceform.mapper.KmsDataAuthMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="kmsAcceptanceFormImportSave")
@Transactional(value="kmsTransactionManager")
public class KmsAcceptanceFormImportSave<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<KmsAcceptanceFormDetailDwMapper, KmsAcceptanceFormDetailDwEntity, KmsAcceptanceFormImportVo>
implements ExcelImportSaver<KmsAcceptanceFormImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsAcceptanceFormImportSave.class);
    @Resource
    private KmsAcceptanceGoodsDetailDwMapper detailDwMapper;
    @Resource
    private KmsDataAuthMapper dataAuthMapper;
    @Resource
    private KmsAcceptanceFormDetailDwMapper kmsAcceptanceFormDetailDwMapper;

    @Override
    public void save(List<KmsAcceptanceFormImportVo> data, DefaultImportContext context) {
        log.info("\u6570\u636e\u4fdd\u5b58:{}", data);
        Map<String, List<KmsAcceptanceFormImportVo>> dataMap = data.stream().collect(Collectors.groupingBy(KmsAcceptanceFormImportVo::getKaOrderNumber));
        ArrayList checkList = Lists.newArrayList();
        ArrayList saveDataAuthEntities = Lists.newArrayList();
        ArrayList saveDetailDwEntities = Lists.newArrayList();
        dataMap.keySet().forEach(x -> {
            ArrayList dataAuthEntities = Lists.newArrayList();
            ArrayList detailDwEntities = Lists.newArrayList();
            AtomicReference<Integer> num = new AtomicReference<Integer>(1);
            ((List)dataMap.get(x)).forEach(y -> {
                if (y.getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS) {
                    CrmExtTenEntity entity;
                    if (CollectionUtils.isEmpty((Collection)dataAuthEntities)) {
                        entity = new KmsDataAuthEntity();
                        entity.setRespDataId(StringUtils.replaceAll((String)UUID.randomUUID().toString(), (String)"-", (String)""));
                        entity.setBsDirectSystemId(y.getBsDirectSystemId());
                        dataAuthEntities.add(entity);
                    }
                    if (CollectionUtils.isEmpty((Collection)detailDwEntities)) {
                        entity = (KmsAcceptanceFormDetailDwEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)y, KmsAcceptanceFormDetailDwEntity.class))));
                        entity.setOrderNumber(CodeUtil.createOneCode((String)"acceptance_form"));
                        entity.setId(entity.getOrderNumber());
                        entity.setRawDataId(((KmsDataAuthEntity)((Object)((Object)((Object)dataAuthEntities.get(0))))).getRespDataId());
                        entity.setKaCode(null);
                        entity.setTransStatus("0");
                        detailDwEntities.add(entity);
                    }
                    KmsAcceptanceGoodsDetailDwEntity goodsDetailDwEntity = (KmsAcceptanceGoodsDetailDwEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)y, KmsAcceptanceGoodsDetailDwEntity.class))));
                    goodsDetailDwEntity.setOrderNumber(((KmsAcceptanceFormDetailDwEntity)((Object)((Object)((Object)detailDwEntities.get(0))))).getOrderNumber());
                    goodsDetailDwEntity.setItemIndex((Integer)num.get());
                    goodsDetailDwEntity.setTransStatus("0");
                    goodsDetailDwEntity.setId(null);
                    saveDetailDwEntities.add(goodsDetailDwEntity);
                    num.getAndSet((Integer)num.get() + 1);
                }
            });
            checkList.addAll(detailDwEntities);
            saveDataAuthEntities.addAll(dataAuthEntities);
        });
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            Set searchKey = checkList.stream().map(KmsAcceptanceFormDetailDwEntity::getKaOrderNumber).collect(Collectors.toSet());
            List entities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(KmsAcceptanceFormDetailDwEntity::getKaOrderNumber, searchKey)).list();
            List goodsDetailDwEntities = this.detailDwMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(KmsAcceptanceGoodsDetailDwEntity::getKaOrderNumber, searchKey));
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                Map<Object, Object> goodMapByDb = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)goodsDetailDwEntities)) {
                    goodMapByDb = goodsDetailDwEntities.stream().collect(Collectors.groupingBy(KmsAcceptanceGoodsDetailDwEntity::getKaOrderNumber));
                }
                Map<String, List<KmsAcceptanceFormDetailDwEntity>> notOnlyKey = entities.stream().collect(Collectors.groupingBy(KmsAcceptanceFormDetailDwEntity::getKaOrderNumber));
                Map authEntityMap = saveDataAuthEntities.stream().collect(Collectors.toMap(KmsDataAuthEntity::getRespDataId, Function.identity()));
                Map<String, List<KmsAcceptanceGoodsDetailDwEntity>> goodsListMap = saveDetailDwEntities.stream().collect(Collectors.groupingBy(KmsAcceptanceGoodsDetailDwEntity::getKaOrderNumber));
                for (int i = 0; i < checkList.size(); ++i) {
                    if (!notOnlyKey.containsKey(((KmsAcceptanceFormDetailDwEntity)((Object)checkList.get(i))).getKaOrderNumber())) continue;
                    KmsAcceptanceFormDetailDwEntity entity = notOnlyKey.get(((KmsAcceptanceFormDetailDwEntity)((Object)checkList.get(i))).getKaOrderNumber()).get(0);
                    KmsAcceptanceFormDetailDwEntity nowEntity = (KmsAcceptanceFormDetailDwEntity)((Object)checkList.get(i));
                    if (authEntityMap.containsKey(nowEntity.getRawDataId())) {
                        saveDataAuthEntities.remove(authEntityMap.get(nowEntity.getRawDataId()));
                    }
                    List goodsDwEntities = (List)goodMapByDb.get(nowEntity.getKaOrderNumber());
                    if (goodsListMap.containsKey(entity.getKaOrderNumber())) {
                        Optional<KmsAcceptanceGoodsDetailDwEntity> optional = goodsDwEntities.stream().max(Comparator.comparingInt(KmsAcceptanceGoodsDetailDwEntity::getItemIndex));
                        AtomicReference<Integer> num = new AtomicReference<Integer>(optional.orElse(new KmsAcceptanceGoodsDetailDwEntity()).getItemIndex());
                        num.getAndSet(num.get() + 1);
                        goodsListMap.get(entity.getKaOrderNumber()).forEach(x -> {
                            x.setOrderNumber(entity.getOrderNumber());
                            x.setItemIndex((Integer)num.get());
                            num.getAndSet((Integer)num.get() + 1);
                        });
                    }
                    checkList.remove((Object)nowEntity);
                }
            }
            saveDataAuthEntities.forEach(x -> this.dataAuthMapper.insert(x));
            this.saveBatch(checkList);
            saveDetailDwEntities.forEach(x -> this.detailDwMapper.insert(x));
        }
    }
}

