/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.tpm;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.component.saver.tpm.FeeBudgetServiceHelper;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.tpm.FeeBudgetImportVo;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.tpm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.tpm.feebudget.model.TpmBudgetSubjectsEntity;
import com.biz.crm.tpm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="tpmFeeBudgetImportSavor")
public class TpmFeeBudgetImportSavor<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<TpmFeeBudgetMapper, TpmFeeBudgetEntity, FeeBudgetImportVo>
implements ExcelImportSaver<FeeBudgetImportVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmFeeBudgetImportSavor.class);
    @Autowired
    private FeeBudgetServiceHelper helper;
    @Resource
    private TpmFeeBudgetMapper mapper;
    @Resource
    private TpmFeeBudgetDetailsMapper detailsMapper;
    @Resource
    private TpmFeeBudgetControlMapper controlMapper;

    @Override
    @Transactional(rollbackFor={Exception.class}, value="tpmTransactionManager")
    public void save(List<FeeBudgetImportVo> data, DefaultImportContext context) {
        if (!CollectionUtils.isEmpty(data)) {
            HashSet budgetSubjectsCodes = Sets.newHashSet();
            HashSet productCodes = Sets.newHashSet();
            HashSet productLevelCodes = Sets.newHashSet();
            HashSet orgCodes = Sets.newHashSet();
            HashMap uniqueKeyMap = Maps.newHashMap();
            data.stream().forEach(o -> {
                o.setFeeBudgetType(FeeBudgetTypeEnum.DEPARTMENT.getCode());
                if (StringUtils.isEmpty((Object)o.getBudgetYear())) {
                    o.appendErrorSaveMsg("\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                try {
                    Integer n = Integer.valueOf(o.getBudgetYear());
                }
                catch (NumberFormatException e) {
                    o.appendErrorSaveMsg("\u5e74\u4efd\u503c\u9519\u8bef;");
                }
                if (StringUtils.isEmpty((Object)o.getBudgetMonth())) {
                    o.appendErrorSaveMsg("\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                try {
                    Integer month = Integer.valueOf(o.getBudgetMonth());
                    if (month > 12 || month < 1) {
                        o.appendErrorSaveMsg("\u6708\u4efd\u503c\u9519\u8bef;");
                    }
                    int quaterByMonth = DateUtil.getQuaterByMonth((int)month);
                    o.setBudgetQuater(String.valueOf(quaterByMonth));
                }
                catch (NumberFormatException e) {
                    o.appendErrorSaveMsg("\u6708\u4efd\u503c\u9519\u8bef;");
                }
                if (StringUtils.isEmpty((Object)o.getProjectNumber())) {
                    o.appendErrorSaveMsg("\u4e13\u6848\u53f7\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                if (StringUtils.isEmpty((Object)o.getOrgCode())) {
                    o.appendErrorSaveMsg("\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                if (StringUtils.isEmpty((Object)o.getBudgetSubjectsCode())) {
                    o.appendErrorSaveMsg("\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                budgetSubjectsCodes.add(o.getBudgetSubjectsCode());
                if (StringUtils.isEmpty((Object)o.getOrgCode())) {
                    o.appendErrorSaveMsg("\u4f01\u4e1a\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                orgCodes.add(o.getOrgCode());
                if (!StringUtils.isEmpty((Object)o.getProductCode())) {
                    productCodes.add(o.getProductCode());
                }
                if (!StringUtils.isEmpty((Object)o.getProductLevelCode())) {
                    productLevelCodes.add(o.getProductLevelCode());
                }
                if (StringUtils.isEmpty((Object)o.getInitAmount())) {
                    o.appendErrorSaveMsg("\u9884\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                try {
                    BigDecimal initAmount = new BigDecimal(o.getInitAmount());
                    if (initAmount.compareTo(BigDecimal.ZERO) != 1) {
                        o.appendErrorSaveMsg("\u9884\u7b97\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6;");
                    }
                }
                catch (Exception e) {
                    o.appendErrorSaveMsg("\u9884\u7b97\u91d1\u989d\u503c\u9519\u8bef;");
                }
                String uniqueKey = this.helper.getUniqueKey((FeeBudgetImportVo)((Object)o));
                if (uniqueKeyMap.containsKey(uniqueKey)) {
                    o.appendErrorSaveMsg("\u8868\u683c\u5b58\u5728\u91cd\u590d\u7ef4\u5ea6\u7684\u6570\u636e,\u91cd\u590d\u884c\u53f7=" + uniqueKeyMap.get(uniqueKey) + ";");
                }
                uniqueKeyMap.put(uniqueKey, o.getRowIndex());
            });
            Map<String, MdmProductEntity> productMap = this.helper.getProductMap(productCodes);
            Map<String, MdmOrgEntity> orgMap = this.helper.getOrgMap(orgCodes);
            Map<String, MdmProductLevelEntity> productLevelMap = this.helper.getProductLevelMap(productLevelCodes);
            Map<String, TpmBudgetSubjectsEntity> subjectMap = this.helper.getSubjectMap(budgetSubjectsCodes);
            ArrayList saveList = Lists.newArrayList();
            data.stream().forEach(o -> {
                MdmOrgEntity mdmOrgEntity = (MdmOrgEntity)((Object)((Object)orgMap.get(o.getOrgCode())));
                if (Objects.isNull((Object)mdmOrgEntity)) {
                    o.appendErrorSaveMsg("\u4f01\u4e1a\u7ec4\u7ec7\u7f16\u7801\u9519\u8bef;");
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)CrmEnableStatusEnum.DISABLE.getCode(), (CharSequence)o.getOrgCode())) {
                    o.appendErrorSaveMsg("\u4f01\u4e1a\u7ec4\u7ec7\u7f16\u7801\u5c1a\u672a\u542f\u7528;");
                } else {
                    o.setOrgName(mdmOrgEntity.getOrgName());
                }
                TpmBudgetSubjectsEntity tpmBudgetSubjectsEntity = (TpmBudgetSubjectsEntity)((Object)((Object)subjectMap.get(o.getBudgetSubjectsCode())));
                if (Objects.isNull((Object)tpmBudgetSubjectsEntity)) {
                    o.appendErrorSaveMsg("\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u9519\u8bef;");
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)CrmEnableStatusEnum.DISABLE.getCode(), (CharSequence)tpmBudgetSubjectsEntity.getEnableStatus())) {
                    o.appendErrorSaveMsg("\u9884\u7b97\u79d1\u76ee\u5c1a\u672a\u542f\u7528;");
                }
                if (!StringUtils.isEmpty((Object)o.getProductCode())) {
                    MdmProductEntity productEntity = (MdmProductEntity)((Object)((Object)productMap.get(o.getProductCode())));
                    if (Objects.isNull((Object)productEntity)) {
                        o.appendErrorSaveMsg("\u5546\u54c1\u7f16\u7801\u9519\u8bef;");
                    } else {
                        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)CrmEnableStatusEnum.DISABLE.getCode(), (CharSequence)productEntity.getEnableStatus())) {
                            o.appendErrorSaveMsg("\u5546\u54c1\u7f16\u7801\u672a\u542f\u7528;");
                        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)productEntity.getIsShelf())) {
                            o.appendErrorSaveMsg("\u5546\u54c1\u7f16\u7801\u672a\u4e0a\u67b6;");
                        } else {
                            o.setProductName(productEntity.getProductName());
                        }
                        if (!StringUtils.isEmpty((Object)o.getProductLevelCode()) && !org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getProductLevelCode(), (CharSequence)productEntity.getProductLevelCode())) {
                            o.appendErrorSaveMsg("\u5546\u54c1\u4e0e\u5546\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb;");
                        }
                    }
                }
                if (!StringUtils.isEmpty((Object)o.getProductLevelCode())) {
                    MdmProductLevelEntity levelEntity = (MdmProductLevelEntity)((Object)((Object)productLevelMap.get(o.getProductLevelCode())));
                    if (Objects.isNull((Object)levelEntity)) {
                        o.appendErrorSaveMsg("\u5546\u54c1\u5c42\u7ea7\u7f16\u7801\u9519\u8bef;");
                    } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)CrmEnableStatusEnum.DISABLE.getCode(), (CharSequence)levelEntity.getEnableStatus())) {
                        o.appendErrorSaveMsg("\u5546\u54c1\u5c42\u7ea7\u672a\u542f\u7528;");
                    } else {
                        o.setProductLevelName(levelEntity.getProductLevelName());
                    }
                }
                if (Objects.equals(AbstractImportVo.ProcessTypeEnum.SUCCESS, o.getProcessType())) {
                    this.helper.checkDataExist((FeeBudgetImportVo)((Object)o));
                }
                if (Objects.equals(AbstractImportVo.ProcessTypeEnum.SUCCESS, o.getProcessType())) {
                    TpmFeeBudgetEntity copy = (TpmFeeBudgetEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, TpmFeeBudgetEntity.class)));
                    copy.setInitAmount(new BigDecimal(o.getInitAmount()));
                    copy.setExt1(o.getProjectNumber());
                    saveList.add(copy);
                }
            });
            if (CollectionUtil.listNotEmptyNotSizeZero((List)saveList)) {
                saveList.forEach(o -> {
                    o.setFeeBudgetCode(CodeUtil.createOneCode((String)"tpm_fee_budget"));
                    o.setCanUseAmount(o.getInitAmount());
                    o.setUsedAmount(BigDecimal.ZERO);
                    o.setAfterAdjustAmount(o.getInitAmount());
                    o.setAdjustTotalAmount(BigDecimal.ZERO);
                    this.helper.createOrUpdateSaveDetail((TpmFeeBudgetEntity)((Object)o));
                    OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().entity((TpmFeeBudgetEntity)((Object)o)).typeEnum(FeeBudgetControlOperateTypeEnum.NEW).build();
                    String controlId = this.helper.saveFeeBudgetControlData(controlReqVo);
                    o.setControlId(controlId);
                    this.mapper.insert(o);
                });
            }
        }
    }
}

