/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.acceptanceform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.acceptanceform.KmsAcceptanceFormImportVo;
import com.biz.crm.kms.confadmin.entity.KmsDirectStoreEntity;
import com.biz.crm.kms.confadmin.entity.KmsDirectSystemEntity;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.kms.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.kms.form.acceptanceform.entity.KmsAcceptanceFormDetailDwEntity;
import com.biz.crm.kms.form.acceptanceform.entity.KmsAcceptanceGoodsDetailDwEntity;
import com.biz.crm.kms.form.acceptanceform.mapper.KmsAcceptanceFormDetailDwMapper;
import com.biz.crm.kms.form.acceptanceform.mapper.KmsAcceptanceGoodsDetailDwMapper;
import com.biz.crm.kms.kaproduct.entity.KmsTenantryDirectProductEntity;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="kmsAcceptanceFormValidator")
public class KmsAcceptanceFormValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsAcceptanceFormDetailDwMapper, KmsAcceptanceFormDetailDwEntity, KmsAcceptanceFormImportVo>
implements ExcelImportValidator<KmsAcceptanceFormImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsAcceptanceFormValidator.class);
    @Value(value="${kms.config.tenantry-id:}")
    private String tenantryId;
    private Set<String> kaOrderNumberSet = Sets.newHashSet();
    @Resource
    private KmsDirectSystemMapper kmsDirectSystemMapper;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private KmsAcceptanceFormDetailDwMapper acceptanceFormDetailDwMapper;
    @Resource
    private KmsAcceptanceGoodsDetailDwMapper acceptanceGoodsDetailDwMapper;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    @Override
    public void validate(List<KmsAcceptanceFormImportVo> data, DefaultImportContext context) {
        ConcurrentHashMap map = ThreadLocalUtil.get();
        map.put("functionCode", "acceptance_order_list");
        map.put("menuCode", "CRM20210528000001877");
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validateSystem(data);
        this.validateKaStore(data);
        this.validateKaGoods(data);
        this.validateNotEmpty(data);
        this.convertData(data);
        this.checkKaOrderNumberExist(data);
    }

    private void checkKaOrderNumberExist(List<KmsAcceptanceFormImportVo> data) {
        if (CollectionUtils.isEmpty(this.kaOrderNumberSet)) {
            return;
        }
        List respVos = this.acceptanceGoodsDetailDwMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(KmsAcceptanceGoodsDetailDwEntity::getKaOrderNumber, this.kaOrderNumberSet));
        if (CollectionUtils.isEmpty((Collection)respVos)) {
            return;
        }
        Set onlyKey = respVos.stream().map(o -> o.getKaOrderNumber() + o.getKaGoodsCode()).collect(Collectors.toSet());
        data.forEach(x -> {
            if (onlyKey.contains(x.getKaOrderNumber() + x.getKaGoodsCode())) {
                x.appendErrorValidateMsg("\u8be5\u5355\u636e\u5df2\u5b58\u5728");
            }
        });
    }

    private void convertData(List<KmsAcceptanceFormImportVo> data) {
        data.forEach(x -> {
            x.setTenantryId(this.tenantryId);
            x.setInvoicesSource("\u5bfc\u5165");
        });
    }

    private void validateNotEmpty(List<KmsAcceptanceFormImportVo> data) {
        HashSet kaOrderNumber = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getKaOrderNumber())) {
                x.appendErrorValidateMsg("\u3010\u5ba2\u6237\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            } else {
                kaOrderNumber.add(x.getKaOrderNumber());
            }
            if (StringUtils.isBlank((CharSequence)x.getSpecification())) {
                x.appendErrorValidateMsg("\u3010\u4ea7\u54c1\u89c4\u683c\u3011\u672a\u586b\u5199\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getCurUnitAcceptanceQuantity())) {
                x.appendErrorValidateMsg("\u3010\u9a8c\u6536\u6570\u91cf\u3011\u672a\u586b\u5199\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getAcceptanceAmount())) {
                x.appendErrorValidateMsg("\u3010\u9a8c\u6536\u5355\u4ef7\u3011\u672a\u586b\u5199\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getAcceptanceDate())) {
                x.appendErrorValidateMsg("\u3010\u9a8c\u6536\u65e5\u671f\u3011\u672a\u586b\u5199\u3001");
            } else if (x.getAcceptanceDate().length() > 8) {
                x.appendErrorValidateMsg("\u9a8c\u6536\u65e5\u671f\u4e0d\u6b63\u786e");
            } else {
                StringBuffer stringBuffer = new StringBuffer(x.getAcceptanceDate());
                stringBuffer.insert(4, "-");
                stringBuffer.insert(7, "-");
                x.setAcceptanceDate(stringBuffer.toString());
            }
            if (StringUtils.isBlank((CharSequence)x.getFinalAcceptanceAmount())) {
                x.appendErrorValidateMsg("\u3010\u9a8c\u6536\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\u3011\u672a\u586b\u5199\u3001");
            }
        });
        this.kaOrderNumberSet = kaOrderNumber;
    }

    private void validateKaGoods(List<KmsAcceptanceFormImportVo> data) {
        HashSet goodCodeSet = Sets.newHashSet();
        HashSet kaCodeSet = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getKaGoodsCode())) {
                x.appendErrorValidateMsg("\u3010\u5ba2\u6237\u4ea7\u54c1\u7f16\u7801\u548c\u540d\u79f0\u3011\u672a\u5b8c\u6574\u586b\u5199\u3001");
            } else {
                goodCodeSet.add(x.getKaGoodsCode());
            }
            kaCodeSet.add(x.getKaCode());
        });
        if (CollectionUtils.isEmpty((Collection)goodCodeSet)) {
            return;
        }
        KmsTenantryDirectCustomerOrgReqVo customerOrgReqVo = new KmsTenantryDirectCustomerOrgReqVo();
        customerOrgReqVo.setDirectIdList((List)Lists.newArrayList((Iterable)kaCodeSet));
        customerOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        customerOrgReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTenantryDirectCustomerOrgEntity> customerOrgEntities = this.kmsTenantryDirectCustomerOrgMapper.selectListForExcel(customerOrgReqVo);
        if (CollectionUtils.isEmpty(customerOrgEntities)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u3010\u5ba2\u6237\u4ea7\u54c1\u4e0d\u5728\u7ef4\u62a4\u4e2d\uff08\u672a\u627e\u5230\u76f4\u8425\u4f53\u7cfb\uff09\u3011\u3001"));
            return;
        }
        Map<String, List<KmsTenantryDirectCustomerOrgEntity>> customerOrgEntityMap = customerOrgEntities.stream().collect(Collectors.groupingBy(KmsTenantryDirectCustomerOrgEntity::getDirectId));
        Map<String, List<KmsTenantryDirectCustomerOrgEntity>> cusOrgMap = customerOrgEntities.stream().collect(Collectors.groupingBy(KmsTenantryDirectCustomerOrgEntity::getDirectId));
        data.forEach(x -> {
            if (!cusOrgMap.containsKey(x.getKaCode())) {
                x.appendErrorValidateMsg("\u5546\u8d85\u3010" + x.getKaName() + "\u3011\u6ca1\u6709\u7ef4\u62a4\u4e2d\u7684\u76f4\u8425\u4f53\u7cfb");
            } else {
                x.setBsDirectSystemId(((KmsTenantryDirectCustomerOrgEntity)((Object)((Object)((List)cusOrgMap.get(x.getKaCode())).get(0)))).getId());
            }
        });
        KmsTenantryDirectProductReqVo productReqVo = new KmsTenantryDirectProductReqVo();
        productReqVo.setKaProductCodes((List)Lists.newArrayList((Iterable)goodCodeSet));
        productReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        productReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectProductEntity> productEntities = this.kmsTenantryDirectProductMapper.selectListForExcel(productReqVo);
        if (CollectionUtils.isEmpty(productEntities)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u3010\u5ba2\u6237\u4ea7\u54c1\u4e0d\u5728\u7ef4\u62a4\u4e2d\uff08\u672a\u627e\u5230\u4ea7\u54c1\uff09\u3011\u3001"));
            return;
        }
        HashMap productEntityMap = Maps.newHashMap();
        productEntities.forEach(x -> productEntityMap.put(x.getBsDirectSystemId() + x.getKaProductCode(), x));
        data.forEach(y -> {
            if (StringUtils.isNotBlank((CharSequence)y.getKaName()) && StringUtils.isNotBlank((CharSequence)y.getKaGoodsCode()) && StringUtils.isNotBlank((CharSequence)y.getKaGoodsName())) {
                if (customerOrgEntityMap.containsKey(y.getKaCode())) {
                    y.setBsDirectSystemId(((KmsTenantryDirectCustomerOrgEntity)((Object)((Object)((List)customerOrgEntityMap.get(y.getKaCode())).get(0)))).getBsDirectSystemId());
                    if (!productEntityMap.containsKey(y.getBsDirectSystemId() + y.getKaGoodsCode())) {
                        y.appendErrorValidateMsg("\u3010\u5ba2\u6237\u4ea7\u54c1\u4e0d\u5728\u7ef4\u62a4\u4e2d\uff08\u76f4\u8425\u4f53\u7cfb\u4e0b\u6ca1\u6709\u8be5\u4ea7\u54c1\uff09\u3011\u3001");
                    }
                } else {
                    log.info(y.getKaName() + "\u4e0b\u6ca1\u6709\u7ef4\u62a4\u4e2d\u76f4\u8425\u4f53\u7cfb\uff08\u76f4\u8425\u4f53\u7cfb\u4e0d\u5bf9\u5e94)");
                    y.appendErrorValidateMsg("\u3010\u6ca1\u6709\u7ef4\u62a4\u4e2d\u76f4\u8425\u4f53\u7cfb\uff08\u65e0\u6cd5\u68c0\u9a8c\u4ea7\u54c1\uff09\u3011\u3001");
                }
            }
        });
    }

    private void validateKaStore(List<KmsAcceptanceFormImportVo> data) {
        HashSet storeCodeSet = Sets.newHashSet();
        HashSet storeNameSet = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getKaStoreCode()) || StringUtils.isBlank((CharSequence)x.getKaStoreName())) {
                x.appendErrorValidateMsg("\u3010\u5546\u8d85\u95e8\u5e97\u7f16\u7801\u6216\u540d\u79f0\u3011\u672a\u586b\u5199\u3001");
            } else {
                storeCodeSet.add(x.getKaStoreCode());
                storeNameSet.add(x.getKaStoreName());
            }
        });
        if (CollectionUtils.isEmpty((Collection)storeCodeSet) || CollectionUtils.isEmpty((Collection)storeNameSet)) {
            return;
        }
        List storeEntities = this.kmsDirectStoreMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsDirectStoreEntity::getStoreCode, (Collection)storeCodeSet)).in(KmsDirectStoreEntity::getStoreName, (Collection)storeNameSet)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        if (CollectionUtils.isEmpty((Collection)storeEntities)) {
            return;
        }
        HashMap storeEntityMap = Maps.newHashMap();
        HashMap storeListMap = Maps.newHashMap();
        storeEntities.forEach(x -> {
            String keyForList = x.getDirectId() + x.getStoreCode();
            String key = x.getDirectId() + x.getStoreCode() + x.getStoreName();
            storeEntityMap.put(key, x);
            if (storeListMap.containsKey(keyForList)) {
                ((List)storeListMap.get(keyForList)).add(x);
            } else {
                storeListMap.put(keyForList, Lists.newArrayList((Object[])new KmsDirectStoreEntity[]{x}));
            }
        });
        data.forEach(x -> {
            if (StringUtils.isNotBlank((CharSequence)x.getKaCode()) && StringUtils.isNotBlank((CharSequence)x.getKaStoreCode()) && StringUtils.isNotBlank((CharSequence)x.getKaStoreName())) {
                String key = x.getKaCode() + x.getKaStoreCode() + x.getKaStoreName();
                String keyForList = x.getKaCode() + x.getKaStoreCode();
                if (!storeEntityMap.containsKey(key)) {
                    if (storeListMap.containsKey(keyForList)) {
                        x.appendErrorValidateMsg("\u3010\u5546\u8d85\u95e8\u5e97\u540d\u79f0\u3011\u586b\u5199\u9519\u8bef\u3001");
                    } else {
                        x.appendErrorValidateMsg("\u3010\u5546\u8d85\u95e8\u5e97\u3011\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
                    }
                }
            }
        });
    }

    private void validateSystem(List<KmsAcceptanceFormImportVo> data) {
        HashSet systemNames = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getKaName())) {
                x.appendErrorValidateMsg("\u3010\u5546\u8d85\u7cfb\u7edf\u3011\u672a\u586b\u5199\u3001");
            }
            if (StringUtils.isNotBlank((CharSequence)x.getKaName())) {
                systemNames.add(x.getKaName());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)systemNames)) {
            List entities = this.kmsDirectSystemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsDirectSystemEntity::getDirectName, (Collection)systemNames)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
            if (CollectionUtils.isEmpty((Collection)entities)) {
                return;
            }
            Map systemEntityMap = entities.stream().collect(Collectors.toMap(KmsDirectSystemEntity::getDirectName, Function.identity()));
            HashSet directIds = Sets.newHashSet();
            data.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getKaName())) {
                    if (systemEntityMap.containsKey(x.getKaName())) {
                        x.setKaCode(((KmsDirectSystemEntity)((Object)((Object)systemEntityMap.get(x.getKaName())))).getId());
                        directIds.add(x.getKaCode());
                    } else {
                        x.appendErrorValidateMsg("\u3010\u5546\u8d85\u7cfb\u7edf(" + x.getKaName() + "\uff09\u3011\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
                    }
                }
            });
        }
    }
}

