/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.user;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmTerminalUserImportVo;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmTerminalUserImportValidator")
public class MdmTerminalUserImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmTerminalMapper, MdmTerminalEntity, MdmTerminalUserImportVo>
implements ExcelImportValidator<MdmTerminalUserImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalUserImportValidator.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;
    private final String PHONE_REGEX = "[1][\\d]{10}";

    @Override
    public void validate(List<MdmTerminalUserImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.verify(data, context);
    }

    protected void verify(List<MdmTerminalUserImportVo> originList, DefaultImportContext context) {
        Map<Object, Object> userNameCheckMap = new HashMap(16);
        Set paramUserNameSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getUserName())).map(MdmTerminalUserImportVo::getUserName).collect(Collectors.toSet());
        if (!paramUserNameSet.isEmpty()) {
            QueryWrapper userNameQuery = new QueryWrapper();
            userNameQuery.in((Object)"user_name", paramUserNameSet);
            userNameQuery.select(new String[]{"user_name", "del_flag"});
            List userNameQueryEntityList = this.mdmUserMapper.selectList((Wrapper)userNameQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)userNameQueryEntityList)) {
                userNameCheckMap = userNameQueryEntityList.stream().collect(Collectors.toMap(MdmUserEntity::getUserName, v -> v));
            }
        }
        HashSet existPhoneSet = new HashSet(16);
        Set paramPhoneSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getEmail())).map(MdmTerminalUserImportVo::getUserPhone).collect(Collectors.toSet());
        if (!paramPhoneSet.isEmpty()) {
            ArrayList list = new ArrayList(paramPhoneSet);
            List lists = Lists.partition(list, (int)500);
            for (List item2 : lists) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"user_phone", (Collection)item2);
                queryWrapper.select(new String[]{"user_phone"});
                List entityList = this.mdmUserMapper.selectList((Wrapper)queryWrapper);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) continue;
                existPhoneSet.addAll(entityList.stream().map(MdmUserEntity::getUserPhone).collect(Collectors.toList()));
            }
        }
        HashSet existEmailSet = new HashSet(16);
        Set paramEmailSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getEmail())).map(MdmTerminalUserImportVo::getEmail).collect(Collectors.toSet());
        if (!paramEmailSet.isEmpty()) {
            ArrayList list = new ArrayList(paramEmailSet);
            List lists = Lists.partition(list, (int)500);
            for (List item3 : lists) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"email", (Collection)item3);
                queryWrapper.select(new String[]{"email"});
                List entityList = this.mdmUserMapper.selectList((Wrapper)queryWrapper);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) continue;
                existEmailSet.addAll(entityList.stream().map(MdmUserEntity::getEmail).collect(Collectors.toList()));
            }
        }
        Map genderValueCodeMap = DictUtil.dictRevertMap((String)"gender");
        HashMap<String, String> roleCodeNameMap = new HashMap<String, String>(16);
        Set paramRoleCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getRoleCode())).map(MdmTerminalUserImportVo::getRoleCode).collect(Collectors.toSet());
        if (!paramRoleCodeSet.isEmpty()) {
            QueryWrapper roleQuery = new QueryWrapper();
            roleQuery.in((Object)"role_code", paramRoleCodeSet);
            List roleCodeQueryEntityList = this.mdmRoleMapper.selectList((Wrapper)roleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)roleCodeQueryEntityList)) {
                roleCodeNameMap.putAll(roleCodeQueryEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName)));
            }
        }
        HashSet terminalCodeSet = new HashSet(16);
        Set paramTerminalCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getTerminalCodeName())).map(MdmTerminalUserImportVo::getTerminalCodeName).collect(Collectors.toSet());
        if (!paramTerminalCodeSet.isEmpty()) {
            ArrayList list = new ArrayList(paramTerminalCodeSet);
            List lists = Lists.partition(list, (int)500);
            for (List strings : lists) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"terminal_code", (Collection)strings);
                queryWrapper.select(new String[]{"terminal_code"});
                List mdmTerminalEntityList = this.mdmTerminalMapper.selectList((Wrapper)queryWrapper);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalEntityList)) continue;
                terminalCodeSet.addAll(mdmTerminalEntityList.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
            }
        }
        HashMap<String, Integer> userNameIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> phoneIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> emailIndexMap = new HashMap<String, Integer>(16);
        for (MdmTerminalUserImportVo item4 : originList) {
            if (StringUtils.isEmpty((String)item4.getUserName())) {
                item4.appendErrorValidateMsg("\u7f3a\u5931\u8d26\u53f7\uff1b");
            } else {
                if (userNameIndexMap.containsKey(item4.getUserName())) {
                    item4.appendErrorValidateMsg("\u8d26\u53f7\u4e0e\u7b2c" + userNameIndexMap.get(item4.getUserName()) + "\u884c\u91cd\u590d\uff1b");
                } else {
                    userNameIndexMap.put(item4.getUserName(), item4.getRowIndex());
                }
                if (userNameCheckMap.containsKey(item4.getUserName())) {
                    MdmUserEntity mdmUserEntity = (MdmUserEntity)((Object)userNameCheckMap.get(item4.getUserName()));
                    if (CrmDelFlagEnum.NORMAL.getCode().equals(mdmUserEntity.getDelFlag())) {
                        item4.appendErrorValidateMsg("\u8d26\u53f7\u5df2\u5b58\u5728\uff1b");
                    } else {
                        item4.appendErrorValidateMsg("\u8d26\u53f7\u5df2\u5b58\u5728\uff08\u903b\u8f91\u5220\u9664\uff09\uff1b");
                    }
                }
            }
            if (StringUtils.isEmpty((String)item4.getFullName())) {
                item4.appendErrorValidateMsg("\u7f3a\u5931\u7528\u6237\u540d\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item4.getGenderName())) {
                if (!genderValueCodeMap.containsKey(item4.getGenderName())) {
                    item4.appendErrorValidateMsg("\u6027\u522b\u65e0\u6548\uff1b");
                } else {
                    item4.setGender((String)genderValueCodeMap.get(item4.getGenderName()));
                }
            }
            if (StringUtils.isEmpty((String)item4.getUserPassword())) {
                item4.appendErrorValidateMsg("\u7f3a\u5931\u5bc6\u7801\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item4.getUserPhone())) {
                if (!item4.getUserPhone().matches("[1][\\d]{10}")) {
                    item4.appendErrorValidateMsg("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
                } else if (phoneIndexMap.containsKey(item4.getUserPhone())) {
                    item4.appendErrorValidateMsg("\u8054\u7cfb\u7535\u8bdd[" + item4.getUserPhone() + "]\u5728\u7b2c" + phoneIndexMap.get(item4.getUserPhone()) + "\u884c\u5df2\u5b58\u5728\uff1b");
                } else if (existPhoneSet.contains(item4.getUserPhone())) {
                    item4.appendErrorValidateMsg("\u8054\u7cfb\u7535\u8bdd[" + item4.getUserPhone() + "]\u5df2\u5b58\u5728\uff1b");
                } else {
                    phoneIndexMap.put(item4.getUserPhone(), item4.getRowIndex());
                }
            }
            if (StringUtils.isNotEmpty((String)item4.getEmail())) {
                if (item4.getEmail().length() - item4.getEmail().replace("@", "").length() != 1) {
                    item4.appendErrorValidateMsg("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
                } else if (emailIndexMap.containsKey(item4.getEmail())) {
                    item4.appendErrorValidateMsg("\u90ae\u7bb1[" + item4.getEmail() + "]\u5728\u7b2c" + emailIndexMap.get(item4.getEmail()) + "\u884c\u5df2\u5b58\u5728\uff1b");
                } else if (existEmailSet.contains(item4.getEmail())) {
                    item4.appendErrorValidateMsg("\u90ae\u7bb1[" + item4.getEmail() + "]\u5df2\u5b58\u5728\uff1b");
                } else {
                    emailIndexMap.put(item4.getEmail(), item4.getRowIndex());
                }
            }
            if (StringUtils.isEmpty((String)item4.getStartTime())) {
                item4.appendErrorValidateMsg("\u7f3a\u5931\u751f\u6548\u65f6\u95f4\uff1b");
            } else if (!this.verifyDateFormat(item4.getStartTime(), "yyyy-MM-dd")) {
                item4.appendErrorValidateMsg("\u751f\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b");
            }
            if (StringUtils.isEmpty((String)item4.getEndTime())) {
                item4.appendErrorValidateMsg("\u7f3a\u5931\u5931\u6548\u65f6\u95f4\uff1b");
            } else if (!this.verifyDateFormat(item4.getEndTime(), "yyyy-MM-dd")) {
                item4.appendErrorValidateMsg("\u5931\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item4.getRoleCode()) && !roleCodeNameMap.containsKey(item4.getRoleCode())) {
                item4.appendErrorValidateMsg("\u6743\u9650\u89d2\u8272\u7f16\u7801\u65e0\u6548\uff1b");
            }
            if (!StringUtils.isNotEmpty((String)item4.getTerminalCodeName()) || terminalCodeSet.contains(item4.getTerminalCodeName())) continue;
            item4.appendErrorValidateMsg("\u5173\u8054\u7ec8\u7aef\u4e0d\u5b58\u5728\uff1b");
        }
    }

    private boolean verifyDateFormat(String dataStr, String formatStr) {
        boolean flag = false;
        if (StringUtils.isNotEmpty((String)dataStr) && StringUtils.isNotEmpty((String)formatStr)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                Date parse = sdf.parse(dataStr);
                String dateFormatStr = sdf.format(parse);
                if (dataStr.equals(dateFormatStr)) {
                    flag = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }
}

