package com.biz.crm.capital;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Description: 资金池流水表
 * @Author: zhangyuzhu
 * @Date: 2021/5/19 17:15
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_capital_flow")
@CrmTable(name = "dms_capital_flow")
public class CapitalFlowEntity extends CrmExtEntity<CapitalFlowEntity> {

    /**
     * 资金池编码
     */
    @CrmColumn(name = "capital_code", length = 64)
    private String capitalCode;

    /**
     * 流水号
     */
    @CrmColumn(name = "flow_no", length = 64)
    private String flowNo;

    /**
     * 客户编码
     */
    @CrmColumn(name = "cus_code", length = 64)
    private String cusCode;

    /**
     * 客户sap编码
     */
    @CrmColumn(name = "cus_sap_code", length = 64)
    private String cusSapCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "cus_name", length = 100)
    private String cusName;

    /**
     * 客户组织编码
     */
    @CrmColumn(name = "cus_org_code", length = 64)
    private String cusOrgCode;

    /**
     * 客户组织名称
     */
    @CrmColumn(name = "cus_org_name", length = 128)
    private String cusOrgName;

    /**
     * 客户所属公司编码
     */
    @CrmColumn(name = "company_code", length = 64)
    private String companyCode ;

    /**
     * 客户所属公司名称
     */
    @CrmColumn(name = "company_name", length = 128)
    private String companyName;


    /**
     * 调整原因（字典）
     */
    @CrmColumn(name = "adjust_reson", length = 24)
    private String adjustReson;

    /**
     * 调整类型（字典）
     */
    @CrmColumn(name = "adjust_type", length = 24)
    private String adjustType;

    /**
     * 单据类型（字典）
     */
    @CrmColumn(name = "bill_type", length = 32)
    private String billType;

    /**
     * 单据号
     */
    @CrmColumn(name = "bill_No", length = 64)
    private String billNo;

    /**
     * 操作金额
     */
    @CrmColumn(name = "adjust_money",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal adjustMoney;

    //---瞬时数据

    /**
     * 授信总额
     */
    @CrmColumn(name = "credit_total",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal creditTotal;

    /**
     * 授信已经使用额
     */
    @CrmColumn(name = "credit_used_total",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal creditUsedTotal;

    /**
     * 授信总余额
     */
    @CrmColumn(name = "credit_surplus_total",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal creditSurplusTotal;

    /**
     * 授信冻结额
     */
    @CrmColumn(name = "credit_froze_money",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal creditFrozeMoney;

    /**
     * 授信可用额
     */
    @CrmColumn(name = "credit_able_total",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal creditAbleTotal;


    //--------资金
    /**
     * 资金已使用额
     */
    @CrmColumn(name = "capital_used_total",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal capitalUsedTotal;

    /**
     * 资金总余额
     */
    @CrmColumn(name = "capital_surplus_total",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal capitalSurplusTotal;

    /**
     * 资金冻结额
     */
    @CrmColumn(name = "capital_froze_money",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal capitalFrozeMoney;

    /**
     * 资金可用余额
     */
    @CrmColumn(name = "capital_able_total",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal capitalAbleTotal;

    /**
     * 冻结总额
     */
    @CrmColumn(name = "froze_money",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal frozeMoney;
}
