package com.biz.crm.pool.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 费用池明细操作记录表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("fee_pool_detail_log")
@CrmTable(name = "fee_pool_detail_log", tableNote = "费用池明细操作记录表", indexes = {
        @Index(name = "i_f_log_pool_code", columnList = "pool_code"),
        @Index(name = "i_f_log_pool_detail_code", columnList = "pool_detail_code"),
        @Index(name = "i_f_log_operation_code", columnList = "operation_code")
})
public class FeePoolDetailLogEntity extends CrmBaseEntity<FeePoolDetailLogEntity> {

    @CrmColumn(name = "pool_code", nullable = false, length = 32, note = "费用池编号")
    private String poolCode;

    @CrmColumn(name = "pool_detail_code", nullable = false, length = 32, note = "费用池明细编号")
    private String poolDetailCode;

    @CrmColumn(name = "operation_code", nullable = false, length = 32, note = "操作记录编号")
    private String operationCode;

    @CrmColumn(name = "operation_type", nullable = false, length = 8, note = "操作类型")
    private String operationType;

    @CrmColumn(name = "from_code", length = 128, note = "来源编号")
    private String fromCode;

    @CrmColumn(name = "from_desc", length = 128, note = "来源描述")
    private String fromDesc;

    @CrmColumn(name = "operation_date_time", nullable = false, length = 19, note = "操作时间 yyyy-MM-dd HH:mm:ss")
    private String operationDateTime;

    @CrmColumn(name = "operation_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "操作金额（数量）（含正负）")
    private BigDecimal operationAmount;

    @CrmColumn(name = "product_code", length = 32, note = "操作相关的商品（或产品层级）编码")
    private String productCode;

    @CrmColumn(name = "product_name", length = 128, note = "操作相关的商品（或产品层级）名称")
    private String productName;

}
