package com.biz.crm.pool.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 费用池附件表
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("fee_pool_file")
@CrmTable(name = "fee_pool_file", tableNote = "费用池附件表", indexes = {
        @Index(name = "i_f_file_pool_code", columnList = "pool_code"),
        @Index(name = "i_f_file_operation_code", columnList = "operation_code")
})
public class FeePoolFileEntity extends CrmBaseEntity<FeePoolFileEntity> {

    @CrmColumn(name = "pool_code", nullable = false, length = 32, note = "费用池编号")
    private String poolCode;

    @CrmColumn(name = "operation_code", nullable = false, length = 32, note = "操作记录编号")
    private String operationCode;

    @CrmColumn(name = "file_name", nullable = false, length = 255, note = "文件名称")
    private String fileName;

    @CrmColumn(name = "url", nullable = false, length = 500, note = "文件路径")
    private String url;

}
