/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.Result;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/feePoolController"})
@Api(tags={"\u901a\u7528-\u8d39\u7528\u6c60\u4e3b\u8868"})
@CrmGlobalLog
public class FeePoolController {
    private static final Logger log = LoggerFactory.getLogger(FeePoolController.class);
    @Resource
    private FeePoolService feePoolService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public Result<PageResult<FeePoolRespVo>> pageList(@RequestBody FeePoolReqVo reqVo) {
        PageResult<FeePoolRespVo> result = this.feePoolService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7\u8d39\u7528\u6c60\u7f16\u53f7\u67e5\u8be2\u8d39\u7528\u6c60", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="poolCode", value="\u8d39\u7528\u6c60\u7f16\u53f7", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryByPoolCode"})
    public Result<FeePoolRespVo> queryByPoolCode(@RequestParam(value="poolCode", required=true) String poolCode) {
        return Result.ok((Object)this.feePoolService.queryByPoolCode(poolCode));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u8d39\u7528\u6c60", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryById"})
    public Result<FeePoolRespVo> queryById(@RequestParam(value="id", required=true) String id) {
        return Result.ok((Object)this.feePoolService.queryById(id));
    }

    @ApiOperation(value="\u83b7\u53d6\u8d39\u7528\u6c60\u660e\u7ec6\u5217\u8868\u7b5b\u9009\u64cd\u4f5c\u7c7b\u578b\u4e0b\u62c9\u6846\u9009\u9879", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="queryType", value="\u7c7b\u578b\uff1a2\uff1a\u8d39\u7528\u6c60\u4e3b\u8868\u884c\u8c03\u6574\u53ef\u9009\u9879\uff0c3\uff1a\u8d39\u7528\u6c60\u4e3b\u8868\u4e0a\u7684\u660e\u7ec6\u8868\u7b5b\u9009\u6761\u4ef6\uff0c4\uff1a\u8d39\u7528\u6c60\u4e3b\u8868\u4e0a\u7684\u64cd\u4f5c\u8bb0\u5f55\u7b5b\u9009\u6761\u4ef6\uff0c5\uff1a\u8d39\u7528\u6c60\u4e3b\u8868\u4e0b\u7684\u660e\u7ec6\u8868\u7684\u64cd\u4f5c\u65e5\u5fd7\u7b5b\u9009\u6761\u4ef6\uff0c6\uff1a\u72ec\u7acb\u660e\u7ec6\u8868\u7b5b\u9009\u4e0b\u62c9\u6846\uff0c7\uff1a\u72ec\u7acb\u660e\u7ec6\u8868\u8c03\u6574\u53ef\u9009\u9879", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/getOperationTypeSelectList"})
    public Result<List<FeeSelectOptionVo>> getOperationTypeSelectList(@RequestParam(value="queryType", required=true) String queryType) {
        String extendByQueryType = FeePoolOperationTypeExtendEnum.getExtendByQueryType((String)queryType);
        Assert.notNull((Object)extendByQueryType, (String)"\u65e0\u6548\u7684\u7b5b\u9009\u7c7b\u578b");
        return Result.ok((Object)FeePoolConfigUtil.getOperationTypeSelectList((String)extendByQueryType));
    }
}

