/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolFileReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationPageReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolFileRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.pool.mapper.FeePoolOperationMapper;
import com.biz.crm.pool.model.FeePoolOperationEntity;
import com.biz.crm.pool.service.FeePoolFileService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolOperationServiceExpandImpl"})
public class FeePoolOperationServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolOperationMapper, FeePoolOperationEntity>
implements FeePoolOperationService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolOperationServiceImpl.class);
    @Resource
    private FeePoolOperationMapper feePoolOperationMapper;
    @Resource
    private FeePoolFileService feePoolFileService;

    @Override
    public PageResult<FeePoolOperationPageRespVo> findFeePoolOperationPageList(FeePoolOperationPageReqVo reqVo) {
        List<String> collect;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolOperationPageRespVo> list = this.feePoolOperationMapper.findFeePoolOperationPageList((Page<FeePoolOperationPageRespVo>)page, reqVo, collect = FeePoolConfigUtil.getAllOperationTypeSelectList().stream().map(FeeSelectOptionVo::getValue).collect(Collectors.toList()));
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Map<String, List<FeePoolFileRespVo>> map = this.feePoolFileService.getFeePoolFileListGroupByOperationCodeList(list.stream().map(FeePoolOperationPageRespVo::getOperationCode).collect(Collectors.toList()));
            list.forEach(item -> {
                if (map.containsKey(item.getOperationCode())) {
                    item.setFileList((List)map.get(item.getOperationCode()));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String savePoolOperation(String poolCode, String operationType, String fromCode, String fromDesc, String remarks, BigDecimal operationAmount, BigDecimal amountWeight, List<FeePoolFileReqVo> fileList) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((operationAmount != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u64cd\u4f5c\u91d1\u989d");
        Assert.isTrue((operationAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        Assert.isTrue((amountWeight != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u91d1\u989d\u6743\u91cd");
        FeePoolOperationEntity entity = new FeePoolOperationEntity();
        entity.setOperationCode(CodeUtil.getCodeDefault());
        entity.setPoolCode(poolCode);
        entity.setOperationType(operationType);
        entity.setFromCode(fromCode);
        entity.setFromDesc(fromDesc);
        entity.setRemarks(remarks);
        entity.setOperationAmount(operationAmount);
        entity.setAmountWeight(amountWeight);
        this.save((Object)entity);
        this.feePoolFileService.savePoolFileList(poolCode, entity.getOperationCode(), fileList);
        return entity.getOperationCode();
    }
}

