/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolServiceExpandImpl"})
public class FeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolMapper, FeePoolEntity>
implements FeePoolService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;

    @Override
    public PageResult<FeePoolRespVo> findList(FeePoolReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolRespVo> list = this.feePoolMapper.findList((Page<FeePoolRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public FeePoolRespVo queryByPoolCode(String poolCode) {
        FeePoolEntity one;
        if (StringUtils.isNotEmpty((String)poolCode) && (one = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one())) != null) {
            return (FeePoolRespVo)CrmBeanUtil.copy((Object)((Object)one), FeePoolRespVo.class);
        }
        return null;
    }

    @Override
    public FeePoolRespVo queryById(String id) {
        FeePoolEntity one;
        if (StringUtils.isNotEmpty((String)id) && (one = (FeePoolEntity)((Object)this.getById((Serializable)((Object)id)))) != null) {
            return (FeePoolRespVo)CrmBeanUtil.copy((Object)((Object)one), FeePoolRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTotalAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.notNull((Object)((Object)pool), (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        pool.setTotalAmount(pool.getTotalAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById((Object)pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUseAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528\u91d1\u989d");
        pool.setUseAmount(pool.getUseAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
        this.updateById((Object)pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractUseAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.isTrue((pool.getUseAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u56de\u9000\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528\u91d1\u989d");
        pool.setUseAmount(pool.getUseAmount().subtract(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById((Object)pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addFreezeAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.notNull((Object)((Object)pool), (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u53ef\u4f7f\u7528\u91d1\u989d");
        pool.setFreezeAmount(pool.getFreezeAmount().add(amount));
        pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
        this.updateById((Object)pool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractFreezeAmount(String poolCode, BigDecimal amount) {
        Assert.hasText((String)poolCode, (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((amount != null ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((amount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)poolCode)).one());
        Assert.notNull((Object)((Object)pool), (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7f16\u53f7");
        Assert.isTrue((pool.getFreezeAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u89e3\u51bb\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u51bb\u7ed3\u91d1\u989d");
        pool.setFreezeAmount(pool.getFreezeAmount().subtract(amount));
        pool.setUsableAmount(pool.getUsableAmount().add(amount));
        this.updateById((Object)pool);
    }
}

