/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.mdm.pricesetting.MdmPriceSettingFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsProductGroupReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseBackItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseBackReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOperationReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductGroupRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolGoodsProductRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolOperationRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pool.mapper.FeePoolMapper;
import com.biz.crm.pool.model.FeePoolDetailEntity;
import com.biz.crm.pool.model.FeePoolDetailLogEntity;
import com.biz.crm.pool.model.FeePoolEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolDetailService;
import com.biz.crm.pool.service.FeePoolGoodsService;
import com.biz.crm.pool.service.FeePoolOperationService;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"FeePoolGoodsServiceExpandImpl"})
public class FeePoolGoodsServiceImpl
implements FeePoolGoodsService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolGoodsServiceImpl.class);
    @Resource
    private FeePoolMapper feePoolMapper;
    @Resource
    private FeePoolService feePoolService;
    @Resource
    private FeePoolOperationService feePoolOperationService;
    @Resource
    private FeePoolDetailService feePoolDetailService;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private MdmPriceSettingFeign mdmPriceSettingFeign;

    @Override
    public PageResult<FeePoolRespVo> findList(FeePoolReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolService.findList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailRespVo> findFeePoolDetailPageList(FeePoolDetailReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolDetailRespVo> findFeePoolDetailAccountList(FeePoolDetailReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolDetailService.findFeePoolDetailPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationRespVo> findFeePoolOperationPageList(FeePoolOperationReqVo reqVo) {
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        return this.feePoolOperationService.findFeePoolOperationPageList(reqVo);
    }

    @Override
    public PageResult<FeePoolOperationRespVo> findFeePoolUseList(FeePoolOperationReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        reqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        List<String> collect = FeePoolConfigUtil.getOperationTypeSelectList((String)FeePoolOperationTypeExtendEnum.SHOW_DETAIL_USE.getValue()).stream().map(FeeSelectOptionVo::getValue).collect(Collectors.toList());
        return this.feePoolOperationService.findList(reqVo, collect);
    }

    @Override
    public PageResult<FeePoolGoodsProductGroupRespVo> findGoodsPoolProductList(FeePoolGoodsProductGroupReqVo reqVo) {
        Set collect;
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolGoodsProductGroupRespVo> list = this.feePoolMapper.findFeePoolGoodsProductGroupList((Page<FeePoolGoodsProductGroupRespVo>)page, reqVo, FeePoolTypeEnum.GOODS.getValue());
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && !(collect = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getGoodsProductCode())).map(FeePoolGoodsProductGroupRespVo::getGoodsProductCode).collect(Collectors.toSet())).isEmpty()) {
            List result;
            Result listResult = this.mdmProductFeign.queryBatchByProductCodeList(new ArrayList(collect));
            if (listResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)(result = (List)listResult.getResult()))) {
                Map<String, MdmProductRespVo> productMap = result.stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
                Map saleUnitMap = DictUtil.dictMap((String)"product_sale_unit");
                list.forEach(item -> {
                    if (StringUtils.isNotEmpty((String)item.getGoodsProductCode()) && productMap.containsKey(item.getGoodsProductCode())) {
                        MdmProductRespVo product = (MdmProductRespVo)productMap.get(item.getGoodsProductCode());
                        item.setSpec(product.getSpec());
                        item.setSaleUnit(product.getSaleUnit());
                        item.setSaleUnitName((String)saleUnitMap.get(product.getSaleUnit()));
                    }
                });
            }
            String conditionType = "sale_price";
            MdmPriceSearchReqVo searchReqVo = new MdmPriceSearchReqVo();
            searchReqVo.setCustomerCode(reqVo.getCustomerCode());
            searchReqVo.setProductCodeList(new ArrayList(collect));
            searchReqVo.setSearchTime(DateUtil.dateNow2Str());
            searchReqVo.setConditionTypeCodeList(Collections.singletonList("sale_price"));
            Result search = this.mdmPriceSettingFeign.search(searchReqVo);
            Assert.isTrue((boolean)search.isSuccess(), (String)"\u67e5\u8be2\u4ef7\u683c\u5931\u8d25");
            Map productPriceSearchMap = (Map)search.getResult();
            Map<String, BigDecimal> productPriceMap = productPriceSearchMap.values().stream().filter(item -> item.containsKey("sale_price") && item.get("sale_price") != null).map(item -> (MdmPriceResp)item.get("sale_price")).collect(Collectors.toMap(MdmPriceResp::getProductCode, MdmPriceResp::getPrice));
            list.forEach(item -> item.setPrice(productPriceMap.getOrDefault(item.getGoodsProductCode(), BigDecimal.ZERO)));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<FeePoolGoodsProductGroupRespVo> findFeePoolGoodsProductGroupList(FeePoolGoodsProductGroupReqVo reqVo) {
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolGoodsProductGroupRespVo> list = this.feePoolMapper.findFeePoolGoodsProductGroupList((Page<FeePoolGoodsProductGroupRespVo>)page, reqVo, FeePoolTypeEnum.GOODS.getValue());
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Set usableProductCodeSet;
            List paramProductLevelCodeList = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getGoodsProductLevelCode())).map(item -> Arrays.asList(item.getGoodsProductLevelCode().split(","))).flatMap(Collection::stream).collect(Collectors.toList());
            List paramProductCodeList = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getGoodsProductCode())).map(item -> Arrays.asList(item.getGoodsProductCode().split(","))).flatMap(Collection::stream).collect(Collectors.toList());
            ArrayList allProductList = new ArrayList();
            if (CollectionUtil.listNotEmptyNotSizeZero(paramProductLevelCodeList)) {
                Result productLevelResult = this.mdmProductFeign.queryBatchByProductLevelCodeList(paramProductLevelCodeList);
                Assert.isTrue((boolean)productLevelResult.isSuccess(), (String)("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff1a" + productLevelResult.getMessage()));
                allProductList.addAll((Collection)productLevelResult.getResult());
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(paramProductCodeList)) {
                Result productResult = this.mdmProductFeign.queryBatchByProductCodeList(paramProductCodeList);
                Assert.isTrue((boolean)productResult.isSuccess(), (String)("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff1a" + productResult.getMessage()));
                allProductList.addAll((Collection)productResult.getResult());
            }
            if (!(usableProductCodeSet = allProductList.stream().filter(item -> {
                if (!CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())) {
                    return false;
                }
                if (!IsShelfEnum.UP.getCode().equals(item.getIsShelf())) {
                    return false;
                }
                if (StringUtils.isNotEmpty((String)reqVo.getGoodsProductCode()) && !item.getProductCode().contains(reqVo.getGoodsProductCode())) {
                    return false;
                }
                return !StringUtils.isNotEmpty((String)reqVo.getGoodsProductName()) || item.getProductName().contains(reqVo.getGoodsProductName());
            }).map(MdmProductRespVo::getProductCode).collect(Collectors.toSet())).isEmpty()) {
                Map productPriceSearchMap = new HashMap(16);
                String conditionType = reqVo.getConditionType();
                boolean priceSearch = StringUtils.isNotEmpty((String)conditionType);
                if (priceSearch) {
                    MdmPriceSearchReqVo searchReqVo = new MdmPriceSearchReqVo();
                    searchReqVo.setCustomerCode(reqVo.getCustomerCode());
                    searchReqVo.setProductCodeList(new ArrayList(usableProductCodeSet));
                    searchReqVo.setSearchTime(DateUtil.dateNow2Str());
                    searchReqVo.setConditionTypeCodeList(Collections.singletonList(conditionType));
                    Result search = this.mdmPriceSettingFeign.search(searchReqVo);
                    Assert.isTrue((boolean)search.isSuccess(), (String)"\u67e5\u8be2\u4ef7\u683c\u5931\u8d25");
                    productPriceSearchMap = (Map)search.getResult();
                }
                HashMap productPriceMap = priceSearch ? productPriceSearchMap.values().stream().filter(item -> item.containsKey(conditionType) && item.get(conditionType) != null).map(item -> (MdmPriceResp)item.get(conditionType)).collect(Collectors.toMap(MdmPriceResp::getProductCode, MdmPriceResp::getPrice)) : new HashMap(16);
                List usableProductList = allProductList.stream().filter(item -> usableProductCodeSet.contains(item.getProductCode()) && (!priceSearch || productPriceMap.containsKey(item.getProductCode()))).collect(Collectors.toList());
                Map<String, MdmProductRespVo> usableProductMap = usableProductList.stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
                Map saleUnitMap = DictUtil.dictMap((String)"product_sale_unit");
                list.forEach(item -> {
                    List goodsProductLevelChildrenCodeList;
                    boolean singleProduct = false;
                    ArrayList productList = new ArrayList();
                    ArrayList goodsProductCodeList = new ArrayList();
                    if (StringUtils.isNotEmpty((String)item.getGoodsProductCode())) {
                        if (!item.getGoodsProductCode().contains(",")) {
                            singleProduct = true;
                        }
                        goodsProductCodeList.addAll(Arrays.asList(item.getGoodsProductCode().split(",")).stream().filter(x -> usableProductCodeSet.contains(x)).collect(Collectors.toList()));
                    } else if (StringUtils.isNotEmpty((String)item.getGoodsProductLevelCode()) && CollectionUtil.listNotEmptyNotSizeZero((List)(goodsProductLevelChildrenCodeList = ProductLevelUtil.getChildrenProductLevelCodeListIncludeSelfEnable(Arrays.asList(item.getGoodsProductLevelCode().split(",")))))) {
                        HashSet set = new HashSet(goodsProductCodeList);
                        goodsProductCodeList.addAll(usableProductList.stream().filter(x -> set.contains(x.getProductLevelCode())).map(MdmProductRespVo::getProductCode).collect(Collectors.toList()));
                    }
                    if (CollectionUtil.listNotEmptyNotSizeZero(goodsProductCodeList)) {
                        productList.addAll(goodsProductCodeList.stream().map(x -> {
                            MdmProductRespVo product = (MdmProductRespVo)usableProductMap.get(x);
                            FeePoolGoodsProductRespVo goodsProduct = new FeePoolGoodsProductRespVo();
                            goodsProduct.setProductCode(product.getProductCode());
                            goodsProduct.setProductName(product.getProductName());
                            goodsProduct.setSpec(product.getSpec());
                            goodsProduct.setSaleUnit(product.getSaleUnit());
                            goodsProduct.setSaleUnitName((String)saleUnitMap.get(product.getSaleUnit()));
                            if (priceSearch) {
                                goodsProduct.setPrice((BigDecimal)productPriceMap.get(product.getProductCode()));
                            }
                            return goodsProduct;
                        }).collect(Collectors.toList()));
                    }
                    if (singleProduct) {
                        item.setSingleProduct(true);
                        if (CollectionUtil.listNotEmptyNotSizeZero(productList)) {
                            item.setProductCode(((FeePoolGoodsProductRespVo)productList.get(0)).getProductCode());
                            item.setProductName(((FeePoolGoodsProductRespVo)productList.get(0)).getProductName());
                            item.setSpec(((FeePoolGoodsProductRespVo)productList.get(0)).getSpec());
                            item.setPrice(((FeePoolGoodsProductRespVo)productList.get(0)).getPrice());
                            item.setSaleUnit(((FeePoolGoodsProductRespVo)productList.get(0)).getSaleUnit());
                            item.setSaleUnitName(((FeePoolGoodsProductRespVo)productList.get(0)).getSaleUnitName());
                        }
                    }
                    item.setProductList(productList);
                });
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void account(FeePoolGoodsAccountReqVo reqVo) {
        FeePoolAccountReqVo copy = (FeePoolAccountReqVo)CrmBeanUtil.copy((Object)reqVo, FeePoolAccountReqVo.class);
        copy.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        this.feePoolService.account(copy);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjust(FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjust(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustByPoolCode(FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjustByPoolCode(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useGoodsPool(FeePoolGoodsUseReqVo reqVo) {
        String operationType = reqVo.getOperationType();
        String fromCode = reqVo.getFromCode();
        String fromDesc = reqVo.getFromDesc();
        String remarks = reqVo.getRemarks();
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.notEmpty((Collection)reqVo.getPoolProductAmountList(), (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d\u660e\u7ec6");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d");
        if (FeePoolOperationTypeEnum.ORDER_USE.getValue().equals(operationType)) {
            Assert.hasText((String)fromCode, (String)(operationTypeValue + "\u5fc5\u987b\u6709\u6765\u6e90\u5355\u53f7"));
        }
        reqVo.getPoolProductAmountList().forEach(x -> {
            Assert.hasText((String)x.getPoolCode(), (String)"\u7f3a\u5931\u8d39\u7528\u6c60\u7f16\u7801");
            Assert.hasText((String)x.getProductCode(), (String)"\u7f3a\u5931\u5546\u54c1\u7f16\u7801");
            Assert.isTrue((x.getAmount() != null ? 1 : 0) != 0, (String)"\u7f3a\u5931\u4f7f\u7528\u91d1\u989d");
            Assert.isTrue((x.getAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        });
        Result result = this.mdmProductFeign.queryBatchByProductCodeList(reqVo.getPoolProductAmountList().stream().map(FeePoolGoodsUseItemReqVo::getProductCode).collect(Collectors.toList()));
        Assert.isTrue((boolean)result.isSuccess(), (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
        Map<String, MdmProductRespVo> productMap = ((List)result.getResult()).stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v));
        reqVo.getPoolProductAmountList().forEach(x -> Assert.isTrue((boolean)productMap.containsKey(x.getProductCode()), (String)("\u5546\u54c1\u7f16\u7801\u3010" + x.getProductCode() + "\u3011\u4e0d\u5b58\u5728")));
        Map<String, List<FeePoolGoodsUseItemReqVo>> groupByPoolCodeMap = reqVo.getPoolProductAmountList().stream().collect(Collectors.groupingBy(FeePoolGoodsUseItemReqVo::getPoolCode));
        String operationDateTime = DateUtil.dateNowHms();
        FeePoolOperationTypeGroupEnum operationTypeGroupEnum = FeePoolConfigUtil.getOperationTypeGroup((String)operationType);
        for (Map.Entry<String, List<FeePoolGoodsUseItemReqVo>> entry : groupByPoolCodeMap.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolGoodsUseItemReqVo> itemList = entry.getValue();
            FeePoolEntity pool = (FeePoolEntity)((Object)((LambdaQueryChainWrapper)this.feePoolService.lambdaQuery().eq(FeePoolEntity::getPoolCode, (Object)entry.getKey())).one());
            BigDecimal amount = itemList.stream().map(FeePoolGoodsUseItemReqVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.notNull((Object)((Object)pool), (String)("\u672a\u627e\u5230\u8d39\u7528\u6c60[" + poolCode + "]"));
            Assert.isTrue((pool.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)("\u8d39\u7528\u6c60" + poolCode + "\u53ef\u4ee5\u4f59\u989d\u4e0d\u8db3"));
            pool.setHasUseAmount(pool.getHasUseAmount().add(amount));
            pool.setUsableAmount(pool.getUsableAmount().subtract(amount));
            this.feePoolService.updateById((Object)pool);
            String operationCode = this.feePoolOperationService.savePoolOperation(pool.getPoolCode(), operationType, fromCode, StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue, remarks, amount, operationTypeGroupEnum.getUsableAmountWeight(), operationDateTime, reqVo.getFileList());
            List poolDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().eq(FeePoolDetailEntity::getPoolCode, (Object)poolCode)).orderByAsc(FeePoolDetailEntity::getAccountDateTime)).list();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            for (FeePoolGoodsUseItemReqVo useItem : itemList) {
                BigDecimal restAmount = useItem.getAmount();
                for (FeePoolDetailEntity poolDetail : poolDetailList) {
                    if (restAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                    if (poolDetail.getUsableAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal itemUse = BigDecimal.ZERO;
                    itemUse = poolDetail.getUsableAmount().compareTo(restAmount) >= 0 ? restAmount : poolDetail.getUsableAmount();
                    restAmount = restAmount.subtract(itemUse);
                    poolDetail.setHasUseAmount(poolDetail.getHasUseAmount().add(itemUse));
                    poolDetail.setUsableAmount(poolDetail.getUsableAmount().subtract(itemUse));
                    FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                    detailLog.setPoolCode(poolCode);
                    detailLog.setPoolDetailCode(poolDetail.getPoolDetailCode());
                    detailLog.setOperationCode(operationCode);
                    detailLog.setOperationType(operationType);
                    detailLog.setFromCode(fromCode);
                    detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                    detailLog.setRemarks(remarks);
                    detailLog.setOperationAmount(itemUse.multiply(operationTypeGroupEnum.getUsableAmountWeight()));
                    detailLog.setOperationDateTime(operationDateTime);
                    detailLog.setProductCode(useItem.getProductCode());
                    detailLog.setProductName(productMap.get(useItem.getProductCode()).getProductName());
                    detailLogList.add(detailLog);
                }
                Assert.isTrue((restAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u6c60\u91d1\u989d\u5f02\u5e38");
            }
            this.feePoolDetailService.updateBatchById(poolDetailList);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backGoodsUseByFromCode(FeePoolGoodsUseBackReqVo reqVo) {
        String fromDesc = reqVo.getFromDesc();
        String remarks = reqVo.getRemarks();
        String operationType = reqVo.getOperationType();
        String fromCode = reqVo.getFromCode();
        Assert.hasText((String)operationType, (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b");
        Assert.hasText((String)fromCode, (String)"\u7f3a\u5931\u6765\u6e90\u5355\u53f7");
        Assert.notEmpty((Collection)reqVo.getItemList(), (String)"\u7f3a\u5931\u9000\u8fd8\u660e\u7ec6");
        String operationTypeValue = DictUtil.dictValue((String)"fee_pool_operation_type", (String)operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Assert.isTrue((boolean)FeePoolConfigUtil.checkOperationTypeGroup((String)operationType, (FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.BACK), (String)"\u8be5\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301\u56de\u9000\u91d1\u989d");
        reqVo.getItemList().forEach(item -> {
            Assert.hasText((String)item.getProductCode(), (String)"\u660e\u7ec6\u7f3a\u5931\u5546\u54c1\u7f16\u7801");
            Assert.isTrue((item.getAmount() != null ? 1 : 0) != 0, (String)"\u660e\u7ec6\u7f3a\u5931\u56de\u9000\u91d1\u989d");
            Assert.isTrue((item.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u660e\u7ec6\u56de\u9000\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        });
        List useDetailLogEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailLogService.lambdaQuery().eq(FeePoolDetailLogEntity::getFromCode, (Object)fromCode)).in(FeePoolDetailLogEntity::getOperationType, (Collection)FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.USE))).orderByAsc(FeePoolDetailLogEntity::getOperationDateTime)).list();
        Assert.notEmpty((Collection)useDetailLogEntityList, (String)("\u672a\u627e\u5230\u6765\u6e90\u5355\u53f7\u3010" + fromCode + "\u3011\u5bf9\u5e94\u7684\u8d39\u7528\u6c60\u4f7f\u7528\u8bb0\u5f55"));
        HashMap<String, BigDecimal> hasBackAmountMap = new HashMap<String, BigDecimal>(16);
        List backDetailLogEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.feePoolDetailLogService.lambdaQuery().eq(FeePoolDetailLogEntity::getFromCode, (Object)fromCode)).in(FeePoolDetailLogEntity::getOperationType, (Collection)FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeGroupEnum)FeePoolOperationTypeGroupEnum.BACK))).orderByAsc(FeePoolDetailLogEntity::getOperationDateTime)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)backDetailLogEntityList)) {
            for (FeePoolDetailLogEntity item2 : backDetailLogEntityList) {
                String key = item2.getPoolCode() + "_" + item2.getPoolDetailCode() + "_" + item2.getProductCode();
                BigDecimal bigDecimal = hasBackAmountMap.getOrDefault(key, BigDecimal.ZERO);
                bigDecimal = bigDecimal.add(item2.getOperationAmount());
                hasBackAmountMap.put(key, bigDecimal);
            }
        }
        Map<String, BigDecimal> backProductAmountMap = reqVo.getItemList().stream().collect(Collectors.groupingBy(FeePoolGoodsUseBackItemReqVo::getProductCode, Collectors.mapping(FeePoolGoodsUseBackItemReqVo::getAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<String, List<FeePoolDetailLogEntity>> groupByPoolCodeMap = useDetailLogEntityList.stream().collect(Collectors.groupingBy(FeePoolDetailLogEntity::getPoolCode));
        LinkedHashMap<String, BigDecimal> poolDetailCodeNeedBackAmountMap = new LinkedHashMap<String, BigDecimal>(16);
        for (Map.Entry<String, List<FeePoolDetailLogEntity>> entry : groupByPoolCodeMap.entrySet()) {
            String poolCode = entry.getKey();
            List<FeePoolDetailLogEntity> groupByPoolCodeList = entry.getValue();
            ArrayList<FeePoolDetailLogReqVo> detailLogList = new ArrayList<FeePoolDetailLogReqVo>();
            BigDecimal poolCodeNeedBackAmount = BigDecimal.ZERO;
            for (FeePoolDetailLogEntity item3 : groupByPoolCodeList) {
                BigDecimal productBackAmount;
                String key = item3.getPoolCode() + "_" + item3.getPoolDetailCode() + "_" + item3.getProductCode();
                BigDecimal notBackAmount = item3.getOperationAmount().abs();
                if (hasBackAmountMap.containsKey(key)) {
                    BigDecimal hasBack = (BigDecimal)hasBackAmountMap.get(key);
                    if (hasBack.compareTo(BigDecimal.ZERO) > 0) {
                        if (notBackAmount.compareTo(hasBack) >= 0) {
                            notBackAmount = notBackAmount.subtract(hasBack);
                            hasBack = BigDecimal.ZERO;
                        } else {
                            hasBack = hasBack.subtract(notBackAmount);
                            notBackAmount = BigDecimal.ZERO;
                        }
                    }
                    hasBackAmountMap.put(key, hasBack);
                }
                if (notBackAmount.compareTo(BigDecimal.ZERO) <= 0 || !backProductAmountMap.containsKey(item3.getProductCode()) || (productBackAmount = backProductAmountMap.get(item3.getProductCode())).compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal thisBackAmount = BigDecimal.ZERO;
                thisBackAmount = productBackAmount.compareTo(notBackAmount) <= 0 ? productBackAmount : notBackAmount;
                notBackAmount = notBackAmount.subtract(thisBackAmount);
                productBackAmount = productBackAmount.subtract(thisBackAmount);
                backProductAmountMap.put(item3.getProductCode(), productBackAmount);
                poolCodeNeedBackAmount = poolCodeNeedBackAmount.add(thisBackAmount);
                BigDecimal poolDetailCodeNeedBackAmount = thisBackAmount;
                if (poolDetailCodeNeedBackAmountMap.containsKey(item3.getPoolDetailCode())) {
                    poolDetailCodeNeedBackAmount = poolDetailCodeNeedBackAmount.add((BigDecimal)poolDetailCodeNeedBackAmountMap.get(item3.getPoolDetailCode()));
                }
                poolDetailCodeNeedBackAmountMap.put(item3.getPoolDetailCode(), poolDetailCodeNeedBackAmount);
                FeePoolDetailLogReqVo detailLog = new FeePoolDetailLogReqVo();
                detailLog.setPoolCode(poolCode);
                detailLog.setPoolDetailCode(item3.getPoolDetailCode());
                detailLog.setOperationType(operationType);
                detailLog.setFromCode(fromCode);
                detailLog.setFromDesc(StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue);
                detailLog.setRemarks(remarks);
                detailLog.setOperationAmount(thisBackAmount.multiply(FeePoolOperationTypeGroupEnum.BACK.getUsableAmountWeight()));
                detailLog.setProductCode(item3.getProductCode());
                detailLog.setProductName(item3.getProductName());
                detailLogList.add(detailLog);
            }
            if (poolCodeNeedBackAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            String operationDateTime = DateUtil.dateNowHms();
            String operationCode = this.feePoolOperationService.savePoolOperation(poolCode, operationType, fromCode, StringUtils.isNotEmpty((String)fromDesc) ? fromDesc : operationTypeValue, remarks, poolCodeNeedBackAmount, FeePoolOperationTypeGroupEnum.BACK.getUsableAmountWeight(), operationDateTime, null);
            detailLogList.forEach(item -> {
                item.setOperationCode(operationCode);
                item.setOperationDateTime(operationDateTime);
            });
            List list = ((LambdaQueryChainWrapper)this.feePoolDetailService.lambdaQuery().in(FeePoolDetailEntity::getPoolDetailCode, poolDetailCodeNeedBackAmountMap.keySet())).list();
            list.forEach(x -> {
                if (poolDetailCodeNeedBackAmountMap.containsKey(x.getPoolDetailCode())) {
                    BigDecimal detailNeedBack = (BigDecimal)poolDetailCodeNeedBackAmountMap.get(x.getPoolDetailCode());
                    if (x.getHasUseAmount().compareTo(detailNeedBack) < 0) {
                        throw new BusinessException("\u8d39\u7528\u6c60\u660e\u7ec6\u9000\u8fd8\u91d1\u989d\u4e0d\u8db3");
                    }
                    x.setHasUseAmount(x.getHasUseAmount().subtract(detailNeedBack));
                    x.setUsableAmount(x.getUsableAmount().add(detailNeedBack));
                }
            });
            this.feePoolDetailService.updateBatchById(list);
            this.feePoolService.subtractHasUseAmount(poolCode, poolCodeNeedBackAmount);
            this.feePoolDetailLogService.savePoolDetailLog(detailLogList);
        }
        for (Map.Entry<String, Object> entry : backProductAmountMap.entrySet()) {
            Assert.isTrue((((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u5546\u54c1" + entry.getKey() + "\u9000\u8fd8\u91d1\u989d\u8d85\u8fc7\u5df2\u4f7f\u7528\u91d1\u989d"));
        }
    }
}

