/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolDetailLogReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailLogPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolDetailLogRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolFileRespVo;
import com.biz.crm.pool.mapper.FeePoolDetailLogMapper;
import com.biz.crm.pool.model.FeePoolDetailLogEntity;
import com.biz.crm.pool.service.FeePoolDetailLogService;
import com.biz.crm.pool.service.FeePoolFileService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"FeePoolDetailLogServiceExpandImpl"})
public class FeePoolDetailLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolDetailLogMapper, FeePoolDetailLogEntity>
implements FeePoolDetailLogService {
    private static final Logger log = LoggerFactory.getLogger(FeePoolDetailLogServiceImpl.class);
    @Resource
    private FeePoolDetailLogMapper feePoolDetailLogMapper;
    @Resource
    private FeePoolFileService feePoolFileService;

    @Override
    public PageResult<FeePoolDetailLogPageRespVo> findDetailLogPageList(FeePoolDetailLogPageReqVo reqVo) {
        Set collect;
        Map<String, List<FeePoolFileRespVo>> fileGroupMap;
        List operationTypeList;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolDetailLogPageRespVo> list = this.feePoolDetailLogMapper.findDetailLogPageList((Page<FeePoolDetailLogPageRespVo>)page, reqVo, operationTypeList = FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeExtendEnum)FeePoolOperationTypeExtendEnum.SHOW_DETAIL_LOG_MAIN));
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && !(fileGroupMap = this.feePoolFileService.getFeePoolFileListGroupByOperationCodeList(new ArrayList<String>(collect = list.stream().map(FeePoolDetailLogPageRespVo::getOperationCode).collect(Collectors.toSet())))).isEmpty()) {
            list.forEach(item -> {
                if (fileGroupMap.containsKey(item.getOperationCode())) {
                    item.setFileList((List)fileGroupMap.get(item.getOperationCode()));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<FeePoolDetailLogRespVo> findList(FeePoolDetailLogReqVo reqVo, String thisPoolCode, String thisPoolDetailCode) {
        Set collect;
        Map<String, List<FeePoolFileRespVo>> fileGroupMap;
        List operationTypeList;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeePoolDetailLogRespVo> list = this.feePoolDetailLogMapper.findList((Page<FeePoolDetailLogRespVo>)page, reqVo, operationTypeList = FeePoolConfigUtil.getOperationTypeList((FeePoolOperationTypeExtendEnum)FeePoolOperationTypeExtendEnum.SHOW_DETAIL_LOG), thisPoolCode, thisPoolDetailCode);
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && !(fileGroupMap = this.feePoolFileService.getFeePoolFileListGroupByOperationCodeList(new ArrayList<String>(collect = list.stream().map(FeePoolDetailLogRespVo::getOperationCode).collect(Collectors.toSet())))).isEmpty()) {
            list.forEach(item -> {
                if (fileGroupMap.containsKey(item.getOperationCode())) {
                    item.setFileList((List)fileGroupMap.get(item.getOperationCode()));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetailLog(String poolCode, String poolDetailCode, String operationCode, String operationType, String fromCode, String fromDesc, String remarks, BigDecimal amount, BigDecimal weight, String operationDateTime) {
        FeePoolDetailLogReqVo reqVo = new FeePoolDetailLogReqVo();
        reqVo.setPoolCode(poolCode);
        reqVo.setPoolDetailCode(poolDetailCode);
        reqVo.setOperationCode(operationCode);
        reqVo.setOperationType(operationType);
        reqVo.setFromCode(fromCode);
        reqVo.setFromDesc(fromDesc);
        reqVo.setRemarks(remarks);
        reqVo.setOperationAmount(amount.multiply(weight));
        reqVo.setOperationDateTime(operationDateTime);
        this.savePoolDetailLog(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetailLog(String poolCode, String poolDetailCode, String operationCode, String operationType, String fromCode, String fromDesc, String remarks, BigDecimal amount, BigDecimal weight, String operationDateTime, String productCode, String productName) {
        FeePoolDetailLogReqVo reqVo = new FeePoolDetailLogReqVo();
        reqVo.setPoolCode(poolCode);
        reqVo.setPoolDetailCode(poolDetailCode);
        reqVo.setOperationCode(operationCode);
        reqVo.setOperationType(operationType);
        reqVo.setFromCode(fromCode);
        reqVo.setFromDesc(fromDesc);
        reqVo.setRemarks(remarks);
        reqVo.setOperationAmount(amount.multiply(weight));
        reqVo.setOperationDateTime(operationDateTime);
        reqVo.setProductCode(productCode);
        reqVo.setProductName(productName);
        this.savePoolDetailLog(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetailLog(FeePoolDetailLogReqVo reqVo) {
        this.save(CrmBeanUtil.copy((Object)reqVo, FeePoolDetailLogEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePoolDetailLog(List<FeePoolDetailLogReqVo> list) {
        this.saveBatch(CrmBeanUtil.copyList(list, FeePoolDetailLogEntity.class));
    }
}

