/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pool.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.fee.pool.req.FeePoolAccountReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAdjustReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOccupyBackAllReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolOccupyToUseReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolPageReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseBackAllReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseBackReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolPageConfigVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolPageRespVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolRespVo;
import com.biz.crm.pool.service.FeePoolService;
import com.biz.crm.util.Result;
import com.biz.crm.util.fee.FeePoolConfigUtil;
import com.biz.crm.util.fee.FeePoolRollbackUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/feePoolController"})
@Api(tags={"FEE-\u4ea7\u54c1\u7ec4-\u8d39\u7528\u6c60\u4e3b\u8868"})
@CrmGlobalLog
public class FeePoolController {
    private static final Logger log = LoggerFactory.getLogger(FeePoolController.class);
    @Resource
    private FeePoolService feePoolService;

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d39\u7528\u6c60\u4e3b\u8868\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findFeePoolPageList"})
    public Result<PageResult<FeePoolPageRespVo>> findFeePoolPageList(@RequestBody FeePoolPageReqVo reqVo) {
        PageResult<FeePoolPageRespVo> result = this.feePoolService.findFeePoolPageList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8d39\u7528\u6c60\u4e3b\u8868\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findFeePoolPageListByConfigCode"})
    public Result<PageResult<FeePoolPageRespVo>> findFeePoolPageListByConfigCode(@RequestBody FeePoolPageReqVo reqVo) {
        PageResult<FeePoolPageRespVo> result = this.feePoolService.findFeePoolPageListByConfigCode(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u901a\u8fc7\u914d\u7f6e\u7f16\u53f7\u67e5\u8be2\u9875\u9762\u914d\u7f6e", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="configCode", value="\u914d\u7f6e\u7f16\u7801", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/getFeePoolPageConfig"})
    public Result<FeePoolPageConfigVo> getFeePoolPageConfig(@RequestParam(value="configCode", required=true) String configCode) {
        return Result.ok((Object)FeePoolConfigUtil.getConfig((String)configCode));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u901a\u8fc7\u8d39\u7528\u6c60\u7f16\u53f7\u67e5\u8be2\u8d39\u7528\u6c60", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="poolCode", value="\u8d39\u7528\u6c60\u7f16\u53f7", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryByPoolCode"})
    public Result<FeePoolRespVo> queryByPoolCode(@RequestParam(value="poolCode", required=true) String poolCode) {
        return Result.ok((Object)this.feePoolService.queryByPoolCode(poolCode));
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u7ef4\u5ea6\u8c03\u6574")
    @PostMapping(value={"/adjust"})
    public Result adjust(@RequestBody FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjust(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u8d39\u7528\u6c60\u7ba1\u7406\u9875\u9762\u4e13\u7528\uff09\u8c03\u6574\uff0c\u6309\u7167\u8d39\u7528\u6c60\u7f16\u53f7")
    @PostMapping(value={"/adjustByPoolCode"})
    public Result adjustByPoolCode(@RequestBody FeePoolAdjustReqVo reqVo) {
        this.feePoolService.adjustByPoolCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u8d39\u7528\u6c60\u53ef\u7528\u91d1\u989d/\u6570\u91cf")
    @PostMapping(value={"/queryPoolAmount"})
    public Result<FeePoolAmountQueryRespVo> queryPoolAmount(@RequestBody FeePoolAmountQueryReqVo reqVo) {
        return Result.ok((Object)this.feePoolService.queryPoolAmount(reqVo));
    }

    @ApiOperation(value="\u4e0a\u8d26")
    @PostMapping(value={"/account"})
    public Result<String> account(@RequestBody FeePoolAccountReqVo reqVo) {
        this.feePoolService.account(reqVo);
        Result result = new Result();
        result.setResult((Object)FeePoolRollbackUtil.generateRollbackCode());
        return result;
    }

    @ApiOperation(value="\u4e0a\u8d26\uff08\u6279\u91cf\uff09")
    @PostMapping(value={"/accountBatch"})
    public Result<String> accountBatch(@RequestBody List<FeePoolAccountReqVo> list) {
        this.feePoolService.accountBatch(list);
        Result result = new Result();
        result.setResult((Object)FeePoolRollbackUtil.generateRollbackCode());
        return result;
    }

    @ApiOperation(value="\u56de\u6eda")
    @PostMapping(value={"/rollback"})
    public Result rollback(@RequestParam(value="rollbackCode", required=true) String rollbackCode) {
        this.feePoolService.rollback(rollbackCode);
        FeePoolRollbackUtil.removeRollbackCode((String)rollbackCode);
        return Result.ok();
    }

    @ApiOperation(value="\u4f7f\u7528\u8d39\u7528\u6c60")
    @PostMapping(value={"/usePool"})
    public Result usePool(@RequestBody FeePoolUseReqVo reqVo) {
        this.feePoolService.usePool(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u4f7f\u7528\u8d39\u7528\u6c60\uff08\u6279\u91cf\uff09")
    @PostMapping(value={"/usePoolBatch"})
    public Result usePoolBatch(@RequestBody List<FeePoolUseReqVo> list) {
        this.feePoolService.usePoolBatch(list);
        return Result.ok();
    }

    @ApiOperation(value="\u5148\u9000\u56de\u4f7f\u7528\u91d1\u989d\uff0c\u518d\u91cd\u65b0\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d")
    @PostMapping(value={"/usePoolAfterBackByFromCode"})
    public Result usePoolAfterBackByFromCode(@RequestBody FeePoolUseReqVo reqVo) {
        this.feePoolService.usePoolAfterBackByFromCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5148\u9000\u56de\u4f7f\u7528\u91d1\u989d\uff0c\u518d\u91cd\u65b0\u4f7f\u7528\u8d39\u7528\u6c60\u91d1\u989d\uff08\u6279\u91cf\uff09")
    @PostMapping(value={"/usePoolAfterBackByFromCodeBatch"})
    public Result usePoolAfterBackByFromCodeBatch(@RequestBody List<FeePoolUseReqVo> list) {
        this.feePoolService.usePoolAfterBackByFromCodeBatch(list);
        return Result.ok();
    }

    @ApiOperation(value="\u56de\u9000\u4f7f\u7528\u91d1\u989d\uff0c\u6839\u636e\u6765\u6e90\u5355\u53f7")
    @PostMapping(value={"/backUseByFromCode"})
    public Result backUseByFromCode(@RequestBody FeePoolUseBackReqVo reqVo) {
        this.feePoolService.backUseByFromCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u56de\u9000\u4f7f\u7528\u91d1\u989d\uff0c\u6839\u636e\u6765\u6e90\u5355\u53f7\uff08\u6279\u91cf\uff09")
    @PostMapping(value={"/backUseByFromCodeBatch"})
    public Result backUseByFromCodeBatch(@RequestBody List<FeePoolUseBackReqVo> list) {
        this.feePoolService.backUseByFromCodeBatch(list);
        return Result.ok();
    }

    @ApiOperation(value="\u5168\u91cf\u56de\u9000\u4f7f\u7528\u91d1\u989d\uff0c\u6839\u636e\u6765\u6e90\u5355\u53f7")
    @PostMapping(value={"/backAllUseByFromCode"})
    public Result backAllUseByFromCode(@RequestBody FeePoolUseBackAllReqVo reqVo) {
        this.feePoolService.backAllUseByFromCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5168\u91cf\u56de\u9000\u4f7f\u7528\u91d1\u989d\uff0c\u6839\u636e\u6765\u6e90\u5355\u53f7\uff08\u6279\u91cf\uff09")
    @PostMapping(value={"/backAllUseByFromCodeBatch"})
    public Result backAllUseByFromCodeBatch(@RequestBody List<FeePoolUseBackAllReqVo> list) {
        this.feePoolService.backAllUseByFromCodeBatch(list);
        return Result.ok();
    }

    @ApiOperation(value="\u5360\u7528\u8d39\u7528\u6c60")
    @PostMapping(value={"/occupyPool"})
    @Deprecated
    public Result occupyPool(@RequestBody FeePoolUseReqVo reqVo) {
        this.feePoolService.occupyPool(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5360\u7528\u8d39\u7528\u6c60\uff08\u6279\u91cf\uff09")
    @PostMapping(value={"/occupyPoolBatch"})
    public Result occupyPoolBatch(@RequestBody List<FeePoolUseReqVo> list) {
        this.feePoolService.occupyPoolBatch(list);
        return Result.ok();
    }

    @ApiOperation(value="\u5168\u91cf\u56de\u9000\u5360\u7528\u91d1\u989d\uff0c\u6839\u636e\u6765\u6e90\u5355\u53f7")
    @PostMapping(value={"/backAllOccupyByFromCode"})
    public Result backAllOccupyByFromCode(@RequestBody FeePoolOccupyBackAllReqVo reqVo) {
        this.feePoolService.backAllOccupyByFromCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5168\u91cf\u56de\u9000\u5360\u7528\u91d1\u989d\uff0c\u6839\u636e\u6765\u6e90\u5355\u53f7\uff08\u6279\u91cf\uff09")
    @PostMapping(value={"/backAllOccupyByFromCodeBatch"})
    public Result backAllOccupyByFromCodeBatch(@RequestBody List<FeePoolOccupyBackAllReqVo> list) {
        this.feePoolService.backAllOccupyByFromCodeBatch(list);
        return Result.ok();
    }

    @ApiOperation(value="\u5360\u7528\u53d8\u66f4\u4e3a\u4f7f\u7528\uff0c\u6839\u636e\u6765\u6e90\u5355\u53f7")
    @PostMapping(value={"/occupyToUseByFromCode"})
    public Result occupyToUseByFromCode(@RequestBody FeePoolOccupyToUseReqVo reqVo) {
        this.feePoolService.occupyToUseByFromCode(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5360\u7528\u53d8\u66f4\u4e3a\u4f7f\u7528\uff0c\u6839\u636e\u6765\u6e90\u5355\u53f7\uff08\u6279\u91cf\uff09")
    @PostMapping(value={"/occupyToUseByFromCodeBatch"})
    public Result occupyToUseByFromCodeBatch(@RequestBody List<FeePoolOccupyToUseReqVo> list) {
        this.feePoolService.occupyToUseByFromCodeBatch(list);
        return Result.ok();
    }
}

