/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.job.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.util.ScheduleUtils;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="scheduleService")
public class ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleService.class);
    @Autowired
    private Scheduler scheduler;

    public void createScheduleJob(String jobClassStr, String jobName, String jobGroup, String cronExpression) {
        Class<?> jobClass = null;
        try {
            jobClass = Class.forName(jobClassStr);
            ScheduleUtils.createScheduleJob(this.scheduler, jobClass, jobName, jobGroup, cronExpression);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BusinessException("\u6307\u5b9a\u6267\u884c\u7c7b\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u521b\u5efa\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void deleteScheduleJob(String jobName, String jobGroup) {
        try {
            ScheduleUtils.deleteScheduleJob(this.scheduler, jobName, jobGroup);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            throw new BusinessException("\u5220\u9664\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void runOnce(String jobName, String jobGroup) {
        try {
            ScheduleUtils.runOnce(this.scheduler, jobName, jobGroup);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            throw new BusinessException("\u8fd0\u884c\u4efb\u52a1\u5931\u8d25");
        }
    }
}

