/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.job.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.job.mapper.QrtzScheduleJobMapper;
import com.biz.crm.job.model.QrtzScheduleJobEntity;
import com.biz.crm.job.service.QrtzScheduleJobService;
import com.biz.crm.job.service.impl.ScheduleService;
import com.biz.crm.nebular.job.req.QrtzScheduleJobReqVo;
import com.biz.crm.nebular.job.resp.QrtzScheduleJobRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class QrtzScheduleJobServiceImpl
extends ServiceImpl<QrtzScheduleJobMapper, QrtzScheduleJobEntity>
implements QrtzScheduleJobService {
    private static final Logger log = LoggerFactory.getLogger(QrtzScheduleJobServiceImpl.class);
    @Autowired
    private QrtzScheduleJobMapper qrtzScheduleJobMapper;
    @Autowired
    private ScheduleService scheduleService;

    @Override
    public PageResult<QrtzScheduleJobRespVo> findList(QrtzScheduleJobReqVo qrtzScheduleJobReqVo) {
        Page page = new Page((long)qrtzScheduleJobReqVo.getPageNum().intValue(), (long)qrtzScheduleJobReqVo.getPageSize().intValue());
        List<QrtzScheduleJobRespVo> list = this.qrtzScheduleJobMapper.findList((Page<QrtzScheduleJobReqVo>)page, qrtzScheduleJobReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createScheduleJob(QrtzScheduleJobReqVo qrtzScheduleJobReqVo) {
        if (ObjectUtils.isEmpty((Object)qrtzScheduleJobReqVo)) {
            return;
        }
        QueryWrapper mdmScheduleJobEntityQueryWrapper = new QueryWrapper();
        mdmScheduleJobEntityQueryWrapper.eq((Object)"job_class", (Object)qrtzScheduleJobReqVo.getJobClass());
        QrtzScheduleJobEntity queryScheduleJobEntity = (QrtzScheduleJobEntity)((Object)this.getOne((Wrapper)mdmScheduleJobEntityQueryWrapper));
        if (queryScheduleJobEntity != null) {
            throw new BusinessException("\u6307\u5b9a\u6267\u884c\u7c7b\u5df2\u5b58\u5728\u4efb\u52a1[" + queryScheduleJobEntity.getJobName() + "]");
        }
        QrtzScheduleJobEntity mdmScheduleJobEntity = (QrtzScheduleJobEntity)((Object)CrmBeanUtil.copy((Object)qrtzScheduleJobReqVo, QrtzScheduleJobEntity.class));
        this.save((Object)mdmScheduleJobEntity);
        this.createTimerTask(mdmScheduleJobEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateScheduleJob(QrtzScheduleJobReqVo qrtzScheduleJobReqVo) {
        if (ObjectUtils.isEmpty((Object)qrtzScheduleJobReqVo)) {
            return;
        }
        QrtzScheduleJobEntity queryScheduleJobEntity = (QrtzScheduleJobEntity)((Object)this.getById((Serializable)((Object)qrtzScheduleJobReqVo.getId())));
        if (queryScheduleJobEntity == null) {
            throw new BusinessException("\u672a\u627e\u5230\u4efb\u52a1\u4fe1\u606f");
        }
        QueryWrapper mdmScheduleJobEntityQueryWrapper = new QueryWrapper();
        mdmScheduleJobEntityQueryWrapper.eq((Object)"job_class", (Object)qrtzScheduleJobReqVo.getJobClass());
        mdmScheduleJobEntityQueryWrapper.ne((Object)"id", (Object)qrtzScheduleJobReqVo.getId());
        QrtzScheduleJobEntity scheduleJobEntity = (QrtzScheduleJobEntity)((Object)this.getOne((Wrapper)mdmScheduleJobEntityQueryWrapper));
        if (scheduleJobEntity != null) {
            throw new BusinessException("\u6307\u5b9a\u6267\u884c\u7c7b\u5df2\u5b58\u5728\u4efb\u52a1[" + scheduleJobEntity.getJobName() + "]");
        }
        queryScheduleJobEntity.setCronExpression(qrtzScheduleJobReqVo.getCronExpression());
        queryScheduleJobEntity.setJobClass(qrtzScheduleJobReqVo.getJobClass());
        queryScheduleJobEntity.setJobGroup(qrtzScheduleJobReqVo.getJobGroup());
        queryScheduleJobEntity.setJobName(qrtzScheduleJobReqVo.getJobName());
        queryScheduleJobEntity.setRemarks(qrtzScheduleJobReqVo.getRemarks());
        this.updateById((Object)queryScheduleJobEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteScheduleJob(QrtzScheduleJobReqVo qrtzScheduleJobReqVo) {
        if (ObjectUtils.isEmpty((Object)qrtzScheduleJobReqVo)) {
            return;
        }
        QrtzScheduleJobEntity queryScheduleJobEntity = (QrtzScheduleJobEntity)((Object)this.getById((Serializable)((Object)qrtzScheduleJobReqVo.getId())));
        if (queryScheduleJobEntity == null) {
            throw new BusinessException("\u672a\u627e\u5230\u4efb\u52a1\u4fe1\u606f");
        }
        this.scheduleService.deleteScheduleJob(queryScheduleJobEntity.getJobName(), queryScheduleJobEntity.getJobGroup());
        queryScheduleJobEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
        this.updateById((Object)queryScheduleJobEntity);
    }

    private void createTimerTask(QrtzScheduleJobEntity queryScheduleJobEntity) {
        this.scheduleService.createScheduleJob(queryScheduleJobEntity.getJobClass(), queryScheduleJobEntity.getJobName(), queryScheduleJobEntity.getJobGroup(), queryScheduleJobEntity.getCronExpression());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void runOnce(QrtzScheduleJobReqVo qrtzScheduleJobReqVo) {
        QrtzScheduleJobEntity queryScheduleJobEntity = (QrtzScheduleJobEntity)((Object)this.getById((Serializable)((Object)qrtzScheduleJobReqVo.getId())));
        if (queryScheduleJobEntity == null) {
            throw new BusinessException("\u672a\u627e\u5230\u4efb\u52a1\u4fe1\u606f");
        }
        if (queryScheduleJobEntity.getEnableStatus() != null && queryScheduleJobEntity.getEnableStatus().equals(CrmEnableStatusEnum.ENABLE.getCode())) {
            throw new BusinessException("\u8bf7\u5148\u505c\u7528\u4efb\u52a1\u518d\u8fd0\u884c");
        }
        qrtzScheduleJobReqVo.setCronExpression(queryScheduleJobEntity.getCronExpression());
        qrtzScheduleJobReqVo.setJobClass(queryScheduleJobEntity.getJobClass());
        qrtzScheduleJobReqVo.setJobGroup(queryScheduleJobEntity.getJobGroup());
        qrtzScheduleJobReqVo.setJobName(queryScheduleJobEntity.getJobName());
        this.createTimerTask(queryScheduleJobEntity);
        this.scheduleService.runOnce(queryScheduleJobEntity.getJobName(), queryScheduleJobEntity.getJobGroup());
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.scheduleService.deleteScheduleJob(queryScheduleJobEntity.getJobName(), queryScheduleJobEntity.getJobGroup());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pauseJob(QrtzScheduleJobReqVo qrtzScheduleJobReqVo) {
        QrtzScheduleJobEntity queryScheduleJobEntity = (QrtzScheduleJobEntity)((Object)this.getById((Serializable)((Object)qrtzScheduleJobReqVo.getId())));
        if (queryScheduleJobEntity == null) {
            throw new BusinessException("\u672a\u627e\u5230\u4efb\u52a1\u4fe1\u606f");
        }
        if (queryScheduleJobEntity.getEnableStatus() != null && queryScheduleJobEntity.getEnableStatus().equals(CrmEnableStatusEnum.ENABLE.getCode())) {
            this.scheduleService.deleteScheduleJob(queryScheduleJobEntity.getJobName(), queryScheduleJobEntity.getJobGroup());
            queryScheduleJobEntity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            this.updateById((Object)queryScheduleJobEntity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resumeJob(QrtzScheduleJobReqVo qrtzScheduleJobReqVo) {
        QrtzScheduleJobEntity queryScheduleJobEntity = (QrtzScheduleJobEntity)((Object)this.getById((Serializable)((Object)qrtzScheduleJobReqVo.getId())));
        if (queryScheduleJobEntity == null) {
            throw new BusinessException("\u672a\u627e\u5230\u4efb\u52a1\u4fe1\u606f");
        }
        try {
            if (queryScheduleJobEntity.getEnableStatus() != null && queryScheduleJobEntity.getEnableStatus().equals(CrmEnableStatusEnum.DISABLE.getCode())) {
                qrtzScheduleJobReqVo.setCronExpression(queryScheduleJobEntity.getCronExpression());
                qrtzScheduleJobReqVo.setJobClass(queryScheduleJobEntity.getJobClass());
                qrtzScheduleJobReqVo.setJobGroup(queryScheduleJobEntity.getJobGroup());
                qrtzScheduleJobReqVo.setJobName(queryScheduleJobEntity.getJobName());
                this.createScheduleJob(qrtzScheduleJobReqVo);
                queryScheduleJobEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                this.updateById((Object)queryScheduleJobEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8fd0\u884c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public QrtzScheduleJobRespVo getOne(String id) {
        QrtzScheduleJobEntity mdmScheduleJobEntity = (QrtzScheduleJobEntity)((Object)this.getById((Serializable)((Object)id)));
        if (mdmScheduleJobEntity == null) {
            return null;
        }
        return (QrtzScheduleJobRespVo)CrmBeanUtil.copy((Object)((Object)mdmScheduleJobEntity), QrtzScheduleJobRespVo.class);
    }
}

