package com.biz.crm.confadmin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.model
 * @ClassName kms_direct_thread
 * @Author Gavin
 * @Date 2021/5/6 上午11:12
 * @Description 商超单据抓取方式
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_direct_thread")
@CrmTable(name = "kms_direct_thread", tableNote = "商超单据抓取方式")
public class KmsDirectThreadEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {
    private static final long serialVersionUID = -8766642590119835353L;

    @CrmColumn(name = "direct_id", length = 64, note = "商超ID")
    private String directId;

    @CrmColumn(name = "order_type", length = 64, note = "单据类型")
    private String orderType;

    @CrmColumn(name = "order_download_way", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "单据下载方式（0_单线程，1_多线程）")
    private Integer orderDownloadWay;

    @CrmColumn(name = "file_classify", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "原始文件格式（0_EXCEL,1_PDF,2_截屏）")
    private Integer fileClassify;

    @CrmColumn(name = "file_download_way", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "文件下载方式（0_单线程，1_多线程）")
    private Integer fileDownloadWay;
}