package com.biz.crm.confadmin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.model
 * @ClassName KmsInterfaceSubParamOptionEntity
 * @Author Gavin
 * @Date 2021/5/6 下午4:02
 * @Description kms抓单接口参数子参数
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_interface_sub_param_option")
@CrmTable(name = "kms_interface_sub_param_option", tableNote = "kms抓单接口参数子参数")
public class KmsInterfaceSubParamOptionEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {
    private static final long serialVersionUID = -5280353024034206753L;

    /**
     * 自定义融合日期ID
     */
    @CrmColumn(name = "field_id", length = 64, note = "抓单接口参数主表id")
    private String fieldId;

    /**
     * 开始或结束时间参数名称
     */
    @CrmColumn(name = "option_name", length = 64, note = "开始或结束时间参数名称")
    private String optionName;

    /**
     * 开始或结束时间参数属性
     */
    @CrmColumn(name = "option_value", length = 64, note = "开始或结束时间参数属性")
    private String optionValue;

    /**
     * 日期标记种类
     */
    @CrmColumn(name = "date_flag_classify", length = 64, note = "开始或结束时间参数属性")
    private String dateFlagClassify;

    /**
     * 展示顺序
     */
    @CrmColumn(name = "sort_index", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "展示顺序")
    private Integer sortIndex;
}