package com.biz.crm.finance.model;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.finance.model
 * @ClassName KmsAuditFormEntity
 * @Author Gavin
 * @Date 2021/5/26 下午3:14
 * @Description 稽核数据表
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_form")
@CrmTable(name = "kms_audit_form", tableNote = "稽核数据",indexes = {
        @Index(name = "kaf_ka_order_number_index", columnList = "ka_order_number"),
        @Index(name = "kaf_audit_number_index", columnList = "audit_number"),
        @Index(name = "kaf_audit_template_id_index", columnList = "audit_template_id"),
})
public class KmsAuditFormEntity extends CrmExtTenEntity<KmsAuditFormEntity> {
    private static final long serialVersionUID = 3688657946502536968L;

    @CrmColumn(name = "audit_number", length = 128, note = "稽核单号")
    private String auditNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超订单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "bukrs", length = 64, note = "公司代码")
    private String bukrs;

    @CrmColumn(name = "org_code", length = 64, note = "企业组织编码")
    private String orgCode;

    /**
     * 直营体系Id
     */
    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系Id")
    private String bsDirectSystemId;


    /**
     * 直营体系编码
     */
    @CrmColumn(name = "bs_direct_system_code", length = 64, note = "直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @CrmColumn(name = "bs_direct_system_name", length = 256, note = "直营体系名称")
    private String bsDirectSystemName;

    /**
     * 商超名称
     */
    @CrmColumn(name = "direct_name", length = 512, note = "商超名称")
    private String directName;

    /**
     * 稽核状态
     */
    @CrmColumn(name = "audit_status", length = 512, note = "稽核状态(待确认/已确认)")
    private String auditStatus;

    /**
     * 匹配结果
     */
    @CrmColumn(name = "audit_result", length = 512, note = "匹配结果（待匹配/无差异/有差异）")
    private String auditResult;

    /**
     * sap过账日期
     */
    @CrmColumn(name = "sap_posting_date", length = 512, note = "sap过账日期")
    private String sapPostingDate;

    /**
     * 送达方编号
     */
    @CrmColumn(name = "store_code", length = 512, note = "送达方编号")
    private String storeCode;

    /**
     * 售达方编码
     */
    @CrmColumn(name = "store_name", length = 512, note = "送达方名称")
    private String storeName;

    @CrmColumn(name = "sold_to_party_name", length = 255, note = "售达方名称")
    private String soldToPartyName;

    @CrmColumn(name = "sold_to_party_code", length = 64, note = "售达方编码")
    private String soldToPartyCode;

    /**
     * SAP物料号
     */
    @CrmColumn(name = "sap_materiel_code", length = 512, note = "SAP物料号")
    private String sapMaterielCode;

    /**
     * SAP物料名称
     */
    @CrmColumn(name = "sap_materiel_name", length = 512, note = "SAP物料名称")
    private String sapMaterielName;

    /**
     * 商品类型
     */
    @CrmColumn(name = "product_type", length = 512, note = "商品类型")
    private String productType;

    /**
     * SAP数量
     */
    @CrmColumn(name = "sap_quantity", length = 512, note = "SAP数量")
    private String sapQuantity;

    /**
     * 验收数量
     */
    @CrmColumn(name = "acceptance_quantity", length = 512, note = "验收数量")
    private String acceptanceQuantity;

    /**
     * 数量差异
     */
    @CrmColumn(name = "compare_quantity", length = 512, note = "数量差异")
    private String compareQuantity;

    /**
     * SAP总金额（不含税）
     */
    @CrmColumn(name = "sap_amount_not", length = 512, note = "SAP总金额（不含税）")
    private String sapAmountNot;

    /**
     * 验收金额（不含税）
     */
    @CrmColumn(name = "acceptance_amount_not", length = 512, note = "验收金额（不含税）")
    private String acceptanceAmountNot;

    /**
     * 金额差异
     */
    @CrmColumn(name = "compare_amount_not", length = 512, note = "金额差异（不含税）")
    private String compareAmountNot;

    /**
     * SAP总金额（含税）
     */
    @CrmColumn(name = "sap_amount", length = 512, note = "SAP总金额（含税）")
    private String sapAmount;

    /**
     * 验收金额（含税）
     */
    @CrmColumn(name = "acceptance_amount", length = 512, note = "验收金额（含税）")
    private String acceptanceAmount;

    /**
     * 金额差异
     */
    @CrmColumn(name = "compare_amount", length = 512, note = "金额差异（含税）")
    private String compareAmount;

    /**
     * 税率
     */
    @CrmColumn(name = "tax_rate", length = 512, note = "税率")
    private String taxRate;

    /**
     * 配送商
     */
    @CrmColumn(name = "distributor", length = 512, note = "配送商")
    private String distributor;

    /**
     * 完成日期
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @CrmColumn(name = "completion_date", length = 512, note = "完成日期")
    private String completionDate;

    /**
     * 完成人
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @CrmColumn(name = "rinisher", length = 512, note = "完成人")
    private String rinisher;

    /**
     * 匹配模版ID
     */
    @CrmColumn(name = "audit_template_id", length = 64, note = "稽核模版ID")
    private String auditTemplateId;

    /**
     * 容差规则（正/负/上下浮动）
     */
    @CrmColumn(name = "audit_rule", length = 255, note = "容差规则（正_Z/负_F/上下浮动_UD）")
    private String auditRule;

    /**
     * 金额容差值
     */
    @CrmColumn(name = "difference_price", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "价格允差")
    private BigDecimal differencePrice;

    /**
     * 对账匹配阈值（天数）
     * 匹配门店时对时间进行处理
     */
    @CrmColumn(name = "time_of_day", mysqlType = "int(11)", oracleType = "NUMBER(10,0)", note = "对账匹配阈值（天数）")
    private Integer timeOfDay;

    /**
     * 是否稽核
     */
    @CrmColumn(name = "is_audit", length = 32, note = "是否稽核yes/no")
    private String isAudit;

    /**
     * 是否稽核
     */
    @CrmColumn(name = "is_store_summary", length = 32, note = "是否门店汇总Y/N")
    private String isStoreSummary;
}