package com.biz.crm.grabrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 抓单规则参数配置表实体类
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_grab_rule_param")
@CrmTable(name = "kms_grab_rule_param", tableNote = "抓单规则参数配置表",indexes = {
        @Index(name = "kgrp_grab_rule_id_index", columnList = "grab_rule_id")
})
public class KmsGrabRuleParamEntity extends CrmExtTenEntity<KmsGrabRuleParamEntity> {


    private static final long serialVersionUID = -851156521455001375L;
    /**
     * 抓单规则ID
     */
    @CrmColumn(name = "grab_rule_id", length = 64, note = "抓单规则ID")
    private String grabRuleId;


    /**
     * 后台接口参数ID
     */
    @CrmColumn(name = "field_id", length = 64, note = "后台参数ID")
    private String fieldId;


    /**
     * 属性
     */
    @CrmColumn(name = "field_en", length = 64, note = "参数属性名称")
    private String fieldEn;


    /**
     * 参数名称
     */
    @CrmColumn(name = "field_cn", length = 64, note = "参数中文名称")
    private String fieldCn;


    /**
     * 下拉选项名称
     */
    @CrmColumn(name = "option_name", length = 64, note = "下拉选项名称")
    private String optionName;

    /**
     * 下拉选项Id
     */
    @CrmColumn(name = "option_id", length = 64, note = "下拉选项Id")
    private String optionId;


    /**
     * 已设置值
     */
    @CrmColumn(name = "field_value", length = 64, note = "参数值")
    private String fieldValue;

    /**
     * 日期控件开始时间属性
     */
    @CrmColumn(name = "start_time_field_en", length = 64, note = "日期控件开始时间属性名称")
    private String startTimeFieldEn;

    /**
     * 日期控件开始时间
     */
    @CrmColumn(name = "start_time", length = 64, note = "日期控件开始时间")
    private String startTime;

    /**
     * 日期控件结束时间属性
     */
    @CrmColumn(name = "end_time_field_en", length = 64, note = "日期控件结束时间属性名称")
    private String endTimeFieldEn;

    /**
     * 日期控件结束时间
     */
    @CrmColumn(name = "end_time", length = 64, note = "日期控件结束时间")
    private String endTime;

    /**
     * 是否固定抓单参数
     */
    @CrmColumn(name = "is_fix", length = 64, note = "是否固定抓单参数")
    private String isFix;

}
