package com.biz.crm.grabrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 抓单规则门店配置表实体类
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_grab_rule_store")
@CrmTable(name = "kms_grab_rule_store", tableNote = "抓单规则门店配置表",indexes = {
        @Index(name = "kgrs_grab_rule_id_index", columnList = "grab_rule_id")
})
public class KmsGrabRuleStoreEntity extends CrmExtTenEntity<KmsGrabRuleStoreEntity> {


    private static final long serialVersionUID = -7389714885485880110L;
    /**
     * 抓单规则ID
     */
    @CrmColumn(name = "grab_rule_id", length = 64, note = "抓单规则ID")
    private String grabRuleId;


    /**
     * 直营体系门店ID
     */
    @CrmColumn(name = "kms_store_id", length = 32, note = "直营体系门店ID")
    private String kmsStoreId;

}
