package com.biz.crm.grabrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Project crm
 * @PackageName com.biz.crm.grabrule.model
 * @ClassName KmsLoggerDataProcessEntity
 * @Author Gavin
 * @Date 2021/5/11 上午10:50
 * @Description 单据抓取日志
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_logger_data_process")
@CrmTable(name = "kms_logger_data_process", tableNote = "单据抓取日志",indexes = {
        @Index(name = "kldp_raw_data_id_index", columnList = "raw_data_id"),
        @Index(name = "kldp_bs_direct_system_id_index", columnList = "bs_direct_system_id")
})
public class KmsLoggerDataProcessEntity extends CrmExtTenEntity<KmsLoggerDataProcessEntity> {
    private static final long serialVersionUID = -3467234632492230951L;

    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系ID")
    private String bsDirectSystemId;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    /**
     * 登录账号
     */
    @CrmColumn(name = "login_acc", length = 32, note = "登录账号")
    private String loginAcc;

    /**
     * 单据类型名称
     */
    @CrmColumn(name = "order_type_name", length = 64, note = "单据类型名称")
    private String orderTypeName;

    /**
     * 抓单规则名称
     */
    @CrmColumn(name = "rule_name", length = 64, note = "抓单规则名称")
    private String ruleName;

    /**
     * 抓单方式
     */
    @CrmColumn(name = "style", length = 64, note = "抓单方式（自动抓单，手动抓单）")
    private String style;

    /**
     * 操作用户
     */
    @CrmColumn(name = "nick_name", length = 125, note = "操作用户")
    private String nickName;

    /**
     * 抓取状态（0:成功，1：失败）
     */
    @CrmColumn(name = "grab_state", length = 32, note = "抓取状态（0:成功，1：失败,2:抓取中）")
    private String grabState;

    /**
     * 结果信息
     */
    @CrmColumn(name = "grab_message", length = 255, note = "结果信息")
    private String grabMessage;

    /**
     * 请求GRPC的信息
     */
    @CrmColumn(name = "request", mysqlType = "MEDIUMTEXT",oracleType = "CLOB",note = "请求数据")
    private String request;
}