package com.biz.crm.orderform.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.orderform.model
 * @ClassName KmsOrderGoodsEntity
 * @Author Gavin
 * @Date 2021/4/28 下午2:54
 * @Description 商超订货单商品信息
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_order_goods")
@CrmTable(name = "kms_order_goods", tableNote = "商超订货单商品表",indexes = {
        @Index(name = "kog_tenantry_id_index",columnList = "tenantry_id"),
        @Index(name = "kog_order_number_index", columnList = "order_number"),
        @Index(name = "kog_version_number_index",columnList = "version_number"),
        @Index(name = "kog_ka_order_number_index", columnList = "ka_order_number"),
        @Index(name = "kog_raw_data_id_index",columnList = "raw_data_id")
})
public class KmsOrderGoodsEntity extends CrmExtTenEntity<KmsOrderFormEntity> {
    private static final long serialVersionUID = 3545806176662069669L;

    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的订单编号")
    private String orderNumber;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "订单版本号")
    private Integer versionNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超订单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "order_status", length = 64, note = "单据当前状态")
    private String orderStatus;

    @CrmColumn(name = "order_status_msg", length = 512, note = "单据当前状态信息")
    private String orderStatusMsg;

    @CrmColumn(name = "goods_code", length = 64, note = "企业产品编号")
    private String goodsCode;

    @CrmColumn(name = "goods_name", length = 255, note = "企业产品名称")
    private String goodsName;

    /**
     * 关联ID(企业商品与商超商品表ID)
     */
    @CrmColumn(name = "goods_related_id", length = 64, note = "关联ID(企业商品与商超商品表ID)")
    private String goodsRelatedId;

    @CrmColumn(name = "ka_goods_code", length = 64, note = "商超产品编号")
    private String kaGoodsCode;

    @CrmColumn(name = "ka_goods_name", length = 255, note = "商超产品名称")
    private String kaGoodsName;

    @CrmColumn(name = "goods_bar_code", length = 64, note = "产品国际条码")
    private String goodsBarCode;

    @CrmColumn(name = "specification", length = 64, note = "产品规格")
    private String specification;

    @CrmColumn(name = "unit_price", length = 64, note = "订货单价（含税）")
    private String unitPrice;

    @CrmColumn(name = "order_amount", length = 64, note = "订货金额小计（含税）")
    private String orderAmount;

    @CrmColumn(name = "unit_price_not", length = 64, note = "订货单价（不含税）")
    private String unitPriceNot;

    @CrmColumn(name = "order_amount_not", length = 64, note = "订货金额小计（不含税）")
    private String orderAmountNot;

    @CrmColumn(name = "sold_to_party_name", length = 255, note = "售达方名称")
    private String soldToPartyName;

    @CrmColumn(name = "sold_to_party_code", length = 64, note = "售达方编码")
    private String soldToPartyCode;

    @CrmColumn(name = "cur_unit_level", length = 64, note = "当前单位层级")
    private String curUnitLevel;

    @CrmColumn(name = "cur_unit", length = 64, note = "当前单位")
    private String curUnit;

    @CrmColumn(name = "cur_unit_order_quantity", length = 64, note = "当前单位订货数量")
    private String curUnitOrderQuantity;

    @CrmColumn(name = "ratio", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "单位转换比例系数")
    private BigDecimal ratio;

    /**
     * 企业单位数量
     */
    @CrmColumn(name = "numerator", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "企业单位数量")
    private BigDecimal numerator;

    @CrmColumn(name = "cur_company_unit", length = 64, note = "企业当前单位")
    private String curCompanyUnit;

    @CrmColumn(name = "cur_company_unit_order_quantity", length = 64, note = "企业当前单位订货数量")
    private String curCompanyUnitOrderQuantity;

    @CrmColumn(name = "min_unit_level", length = 64, note = "最小单位层级")
    private String minUnitLevel;

    @CrmColumn(name = "min_unit", length = 64, note = "最小单位")
    private String minUnit;

    @CrmColumn(name = "min_unit_order_quantity", length = 64, note = "最小单位订货数量")
    private String minUnitOrderQuantity;

    @CrmColumn(name = "max_unit_level", length = 64, note = "最大单位层级")
    private String maxUnitLevel;

    @CrmColumn(name = "max_unit", length = 64, note = "最大单位")
    private String maxUnit;

    @CrmColumn(name = "max_unit_order_quantity", length = 64, note = "最大单位订货数量")
    private String maxUnitOrderQuantity;

    @CrmColumn(name = "factory_code", length = 64, note = "工厂编码")
    private String factoryCode;

    @CrmColumn(name = "factory_name", length = 255, note = "工厂名称")
    private String factoryName;

    @CrmColumn(name = "pro_rate", length = 64, note = "产品税率")
    private String proRate;

    @CrmColumn(name = "pro_rebate", length = 64, note = "折扣")
    private String proRebate;

    @CrmColumn(name = "data_from", length = 255, note = "详情来源")
    private String dataFrom;

    @CrmColumn(name = "order_price", length = 255, note = "维护单价")
    private String orderPrice;

    @CrmColumn(name = "price_diff", length = 255, note = "单价差异")
    private String priceDiff;

    @CrmColumn(name = "item_index", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "行信息排序")
    private Integer itemIndex;

    @CrmColumn(name = "sap_item_no",length = 64, note = "sap行项目号")
    private String sapItemNo;
}